/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.board;

import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.ICustomCTBlocking;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.WaterloggedMultiStateCopycatBlock;
import com.copycatsplus.copycats.utility.BlockFaceUtils;
import com.copycatsplus.copycats.utility.BlockUtils;
import com.google.common.collect.ImmutableMap;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatBoardBlock
extends WaterloggedMultiStateCopycatBlock
implements ICustomCTBlocking,
SpecialBlockItemRequirement {
    public static BooleanProperty UP = BlockStateProperties.f_61366_;
    public static BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.f_55154_;
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;
    private final ImmutableMap<FaceData, VoxelShape> partialFaceCache;

    public CopycatBoardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = this.m_152458_(CopycatBoardBlock::calculateMultifaceShape);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(true));
        for (String property : this.storageProperties()) {
            for (Direction face : Direction.values()) {
                builder.put((Object)new FaceData(property, face), (Object)BlockFaceUtils.getPartialFaceShape(null, state, property, face));
            }
        }
        this.partialFaceCache = builder.build();
    }

    @Override
    public String defaultProperty() {
        return UP.m_61708_();
    }

    @Override
    public Vec3i vectorScale(BlockState state) {
        return new Vec3i(1, 1, 1);
    }

    @Override
    public Set<String> storageProperties() {
        return Set.of(UP, DOWN, NORTH, EAST, SOUTH, WEST).stream().map(Property::m_61708_).collect(Collectors.toSet());
    }

    @Override
    public int getColorIndex(String property) {
        if (property.equals(UP.m_61708_())) {
            return 0;
        }
        if (property.equals(DOWN.m_61708_())) {
            return 0;
        }
        if (property.equals(NORTH.m_61708_())) {
            return 1;
        }
        if (property.equals(SOUTH.m_61708_())) {
            return 1;
        }
        if (property.equals(EAST.m_61708_())) {
            return 2;
        }
        if (property.equals(WEST.m_61708_())) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean partExists(BlockState state, String property) {
        if (property.equals(UP.m_61708_())) {
            return (Boolean)state.m_61143_((Property)UP);
        }
        if (property.equals(DOWN.m_61708_())) {
            return (Boolean)state.m_61143_((Property)DOWN);
        }
        if (property.equals(NORTH.m_61708_())) {
            return (Boolean)state.m_61143_((Property)NORTH);
        }
        if (property.equals(SOUTH.m_61708_())) {
            return (Boolean)state.m_61143_((Property)SOUTH);
        }
        if (property.equals(EAST.m_61708_())) {
            return (Boolean)state.m_61143_((Property)EAST);
        }
        if (property.equals(WEST.m_61708_())) {
            return (Boolean)state.m_61143_((Property)WEST);
        }
        return false;
    }

    @Override
    public String getPropertyFromInteraction(BlockState state, BlockGetter level, Vec3i hitLocation, BlockPos blockPos, Direction facing, Vec3 unscaledHit) {
        facing = Direction.m_122387_((Direction.Axis)facing.m_122434_(), (Direction.AxisDirection)(unscaledHit.m_82507_(facing.m_122434_()) > 0.5 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
        BooleanProperty face = CopycatBoardBlock.byDirection(facing);
        return face.m_61708_();
    }

    @Override
    public String getPropertyFromRender(String renderingProperty, BlockState state, BlockGetter level, Vec3i vector, BlockPos blockPos) {
        return renderingProperty;
    }

    @Override
    public Vec3i getVectorFromProperty(BlockState state, String property) {
        return Vec3i.f_123288_;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST}));
    }

    @Override
    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos, BlockState toState) {
        return !reader.m_8055_(toPos).m_60713_((Block)this);
    }

    @Override
    public boolean canConnectTexturesToward(String property, BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        return reader.m_8055_(toPos).m_60713_((Block)this);
    }

    @Override
    public Optional<Boolean> blockCTTowards(BlockAndTintGetter reader, BlockState state, BlockPos pos, BlockPos ctPos, BlockPos connectingPos, Direction face) {
        if (!reader.m_8055_(ctPos).m_60713_((Block)this)) {
            return Optional.empty();
        }
        return Optional.of(false);
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return switch (pType) {
            case PathComputationType.LAND -> {
                if (!((Boolean)pState.m_61143_((Property)UP)).booleanValue() && ((Boolean)pState.m_61143_((Property)DOWN)).booleanValue() || ((Boolean)pState.m_61143_((Property)UP)).booleanValue()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static VoxelShape calculateMultifaceShape(BlockState pState) {
        VoxelShape shape = Shapes.m_83040_();
        for (Direction direction : Iterate.directions) {
            if (!((Boolean)pState.m_61143_((Property)CopycatBoardBlock.byDirection(direction))).booleanValue()) continue;
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)CCShapes.BOARD.get(direction).toShape(), (BooleanOp)BooleanOp.f_82695_);
        }
        return shape.m_83296_();
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return Objects.requireNonNull((VoxelShape)this.shapesCache.get((Object)pState));
    }

    @Override
    public VoxelShape getPartialFaceShape(BlockGetter level, BlockState state, String property, Direction face) {
        if (!this.partExists(state, property)) {
            return Shapes.m_83040_();
        }
        return Objects.requireNonNull((VoxelShape)this.partialFaceCache.getOrDefault((Object)new FaceData(property, face), (Object)Shapes.m_83040_()));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        if (stateForPlacement == null) {
            return null;
        }
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        if (state.m_60713_((Block)this)) {
            if (!((Boolean)state.m_61143_((Property)CopycatBoardBlock.byDirection(context.m_43719_().m_122424_()))).booleanValue()) {
                return (BlockState)state.m_61124_((Property)CopycatBoardBlock.byDirection(context.m_43719_().m_122424_()), (Comparable)Boolean.valueOf(true));
            }
            return (BlockState)state.m_61124_((Property)CopycatBoardBlock.byDirection(context.m_43719_()), (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)stateForPlacement.m_61124_((Property)CopycatBoardBlock.byDirection(context.m_43719_().m_122424_()), (Comparable)Boolean.valueOf(true));
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        if (!itemstack.m_150930_(this.m_5456_())) {
            return false;
        }
        if (!((Boolean)pState.m_61143_((Property)CopycatBoardBlock.byDirection(pUseContext.m_43719_().m_122424_()))).booleanValue()) {
            double loc;
            Direction direction = pUseContext.m_43719_().m_122424_();
            double pos = CopycatBoardBlock.getByAxis((Vec3i)pUseContext.m_8083_(), direction.m_122434_());
            if (CopycatBoardBlock.getByAxis(direction.m_122436_(), direction.m_122434_()) > 0) {
                pos += 1.0;
            }
            if (Math.abs(pos - (loc = CopycatBoardBlock.getByAxis((Position)pUseContext.m_43720_(), direction.m_122434_()))) < 0.125) {
                return true;
            }
        }
        if (!((Boolean)pState.m_61143_((Property)CopycatBoardBlock.byDirection(pUseContext.m_43719_()))).booleanValue()) {
            double hitLoc = CopycatBoardBlock.getByAxis((Position)pUseContext.m_43720_(), pUseContext.m_43719_().m_122434_());
            int direction = CopycatBoardBlock.getByAxis(pUseContext.m_43719_().m_122436_(), pUseContext.m_43719_().m_122434_());
            double offset = hitLoc - (double)Math.round(hitLoc);
            if (Mth.m_14205_((double)direction) == Mth.m_14205_((double)offset) && Math.abs(offset) < 0.125) {
                return true;
            }
        }
        return false;
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        this.onWrenched(state, context);
        int faceCount = 0;
        for (Direction direction : Iterate.directions) {
            if (!((Boolean)state.m_61143_((Property)CopycatBoardBlock.byDirection(direction))).booleanValue()) continue;
            ++faceCount;
        }
        if (faceCount <= 1) {
            return super.onSneakWrenched(state, context);
        }
        ArrayList<Direction> options = new ArrayList<Direction>(6);
        for (Direction direction : Iterate.directions) {
            double loc;
            if (!((Boolean)state.m_61143_((Property)CopycatBoardBlock.byDirection(direction))).booleanValue()) continue;
            double pos = CopycatBoardBlock.getByAxis((Vec3i)context.m_8083_(), direction.m_122434_());
            if (CopycatBoardBlock.getByAxis(direction.m_122436_(), direction.m_122434_()) > 0) {
                pos += 1.0;
            }
            if (!(Math.abs(pos - (loc = CopycatBoardBlock.getByAxis((Position)context.m_43720_(), direction.m_122434_()))) < 0.125)) continue;
            options.add(direction);
        }
        if (options.size() > 1) {
            Direction backup = (Direction)options.get(0);
            options.removeIf(d -> d.m_122434_() != context.m_43719_().m_122434_());
            if (options.size() == 0) {
                options.add(backup);
            }
        }
        if (options.size() == 0) {
            return super.onSneakWrenched(state, context);
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world instanceof ServerLevel) {
            if (player != null) {
                List drops = Block.m_49874_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CopycatBoardBlock.byDirection((Direction)options.get(0)), (Comparable)Boolean.valueOf(true))), (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_());
                if (!player.m_7500_()) {
                    for (ItemStack drop : drops) {
                        player.m_150109_().m_150079_(drop);
                    }
                }
            }
            BlockPos up = pos.m_121945_(Direction.UP);
            world.m_46597_(pos, ((BlockState)state.m_61124_((Property)CopycatBoardBlock.byDirection((Direction)options.get(0)), (Comparable)Boolean.valueOf(false))).m_60728_(Direction.UP, world.m_8055_(up), (LevelAccessor)world, pos, up));
            IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return IMultiStateCopycatBlock.getRequiredItemsForParts(state, UP, DOWN, NORTH, SOUTH, EAST, WEST);
    }

    private static int getByAxis(Vec3i pos, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> pos.m_123341_();
            case Direction.Axis.Y -> pos.m_123342_();
            case Direction.Axis.Z -> pos.m_123343_();
        };
    }

    private static double getByAxis(Position pos, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> pos.m_7096_();
            case Direction.Axis.Y -> pos.m_7098_();
            case Direction.Axis.Z -> pos.m_7094_();
        };
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        return this.mapDirections(state, dir -> BlockUtils.transformFacing(transform, dir));
    }

    @Override
    public void transformStorage(BlockState state, IMultiStateCopycatBlockEntity be, StructureTransform transform) {
        be.getMaterialItemStorage().remapStorage(key -> CopycatBoardBlock.directionToProperty(BlockUtils.transformFacing(transform, CopycatBoardBlock.propertyToDirection(key))));
    }

    private static Direction propertyToDirection(String property) {
        return switch (property) {
            case "up" -> Direction.UP;
            case "down" -> Direction.DOWN;
            case "north" -> Direction.NORTH;
            case "south" -> Direction.SOUTH;
            case "east" -> Direction.EAST;
            case "west" -> Direction.WEST;
            default -> throw new IllegalStateException("Unexpected value: " + property);
        };
    }

    public static String directionToProperty(Direction direction) {
        return direction.m_122433_().toLowerCase(Locale.ROOT);
    }

    private BlockState mapDirections(BlockState pState, Function<Direction, Direction> pDirectionalFunction) {
        BlockState blockstate = pState;
        for (Direction direction : Iterate.directions) {
            blockstate = (BlockState)blockstate.m_61124_((Property)CopycatBoardBlock.byDirection(pDirectionalFunction.apply(direction)), (Comparable)((Boolean)pState.m_61143_((Property)CopycatBoardBlock.byDirection(direction))));
        }
        return blockstate;
    }

    public static BooleanProperty byDirection(Direction direction) {
        return PROPERTY_BY_DIRECTION.get(direction);
    }

    public record FaceData(String property, Direction direction) {
    }
}

