/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.compat.kubejs;

import com.jesz.createdieselgenerators.fuel_type.FuelType;
import java.util.function.Consumer;

public class FuelTypeBuilder {
    float normalSpeed;
    float modularSpeed;
    float hugeSpeed;
    float normalStrength;
    float modularStrength;
    float hugeStrength;
    float burnerStrength;
    int normalBurn;
    int modularBurn;
    int hugeBurn;
    int soundSpeed;
    Consumer<FuelType> callback;

    public FuelTypeBuilder(Consumer<FuelType> callback) {
        this.callback = callback;
    }

    public FuelTypeBuilder normalSpeed(float speed) {
        this.normalSpeed = speed;
        return this;
    }

    public FuelTypeBuilder modularSpeed(float speed) {
        this.modularSpeed = speed;
        return this;
    }

    public FuelTypeBuilder hugeSpeed(float speed) {
        this.hugeSpeed = speed;
        return this;
    }

    public FuelTypeBuilder normalStrength(float strength) {
        this.normalStrength = strength;
        return this;
    }

    public FuelTypeBuilder modularStrength(float strength) {
        this.modularStrength = strength;
        return this;
    }

    public FuelTypeBuilder hugeStrength(float strength) {
        this.hugeStrength = strength;
        return this;
    }

    public FuelTypeBuilder normalBurn(int burn) {
        this.normalBurn = burn;
        return this;
    }

    public FuelTypeBuilder modularBurn(int burn) {
        this.modularBurn = burn;
        return this;
    }

    public FuelTypeBuilder hugeBurn(int burn) {
        this.hugeBurn = burn;
        return this;
    }

    public FuelTypeBuilder soundSpeed(int soundSpeed) {
        this.soundSpeed = soundSpeed;
        return this;
    }

    public FuelTypeBuilder burnerStrength(float burnerStrength) {
        this.burnerStrength = burnerStrength;
        return this;
    }

    public FuelType build() {
        FuelType type = new FuelType(this.normalSpeed, this.normalStrength, this.normalBurn, this.modularSpeed, this.modularStrength, this.modularBurn, this.hugeSpeed, this.hugeStrength, this.hugeBurn, this.soundSpeed, this.burnerStrength);
        this.callback.accept(type);
        return type;
    }
}

