/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine;

import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlock;
import com.jesz.createdieselgenerators.fuel_type.FuelTypeManager;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public interface IEngine {
    default public boolean enabled() {
        if (this.fs().isEmpty()) {
            return false;
        }
        if (FuelTypeManager.fuelTypes.containsKey(this.fs().getFluid())) {
            return (Boolean)CDGConfig.ENGINES_DISABLED_WITH_REDSTONE.get() == false || (Boolean)this.self().m_58900_().m_61143_((Property)DieselEngineBlock.POWERED) == false;
        }
        return false;
    }

    default public boolean validFS() {
        if (this.fs().isEmpty()) {
            return false;
        }
        return FuelTypeManager.fuelTypes.containsKey(this.fs().getRawFluid());
    }

    default public FluidStack fs() {
        return this.getTank().getPrimaryHandler().getFluid();
    }

    default public float getFuelSpeed() {
        return FuelTypeManager.getGeneratedSpeed((BlockEntity)this.self(), this.fs().getRawFluid());
    }

    default public float getFuelStress() {
        return FuelTypeManager.getGeneratedStress((BlockEntity)this.self(), this.fs().getRawFluid()) / this.getFuelSpeed();
    }

    default public void tickFuelUsage(float multiplier) {
        if (this.getTick() % 20 == 0) {
            this.getTank().getPrimaryHandler().drain((int)((float)FuelTypeManager.getBurnRate((BlockEntity)this.self(), this.fs().getRawFluid()) * multiplier), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    default public void tickFuelUsage() {
        this.tickFuelUsage(1.0f);
    }

    public int getTick();

    public SmartBlockEntity self();

    public SmartFluidTankBehaviour getTank();

    public void playSound();
}

