/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.huge;

import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.CDGSounds;
import com.jesz.createdieselgenerators.compat.computercraft.CCProxy;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineUpgrades;
import com.jesz.createdieselgenerators.content.diesel_engine.IEngine;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.HugeDieselEngineBlock;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.HugeDieselEngineValueBox;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.PoweredEngineShaftBlock;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.PoweredEngineShaftBlockEntity;
import com.jesz.createdieselgenerators.fuel_type.FuelTypeManager;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.lang.ref.WeakReference;
import java.util.List;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class HugeDieselEngineBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IEngine {
    public WeakReference<PoweredEngineShaftBlockEntity> target = new WeakReference<Object>(null);
    public SmartFluidTankBehaviour tank;
    EngineUpgrades upgrade = EngineUpgrades.NONE;
    int tick;
    float oldAngle = 0.0f;
    public ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public AbstractComputerBehaviour computerBehaviour;

    public HugeDieselEngineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.tank.write(compound, clientPacket);
        compound.m_128405_("Tick", this.tick);
        compound.m_128359_("Upgrade", this.upgrade.getId().toString());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tank.read(compound, clientPacket);
        this.tick = compound.m_128451_("Tick");
        this.upgrade = EngineUpgrades.NONE;
        for (EngineUpgrades upgrade : EngineUpgrades.allUpgrades) {
            if (!upgrade.getId().toString().equals(compound.m_128461_("Upgrade"))) continue;
            this.upgrade = upgrade;
            break;
        }
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(2.0);
    }

    public void tick() {
        super.tick();
        PoweredEngineShaftBlockEntity shaft = this.getShaft();
        if (shaft == null) {
            return;
        }
        if (this.enabled()) {
            float shaftR;
            this.tickFuelUsage();
            ++this.tick;
            if (shaft.movementDirection != 0 && shaft.movementDirection != (this.movementDirection.get() == WindmillBearingBlockEntity.RotationDirection.CLOCKWISE ? 1 : -1)) {
                shaft.removeGenerator(this.f_58858_);
                this.onDirectionChanged();
                return;
            }
            shaft.update(this.f_58858_, this.movementDirection.getValue() == 0 ? 1 : -1, this.upgrade.getStress(this.upgrade.getStress(this.getFuelStress(), this), this), this.upgrade.getSpeed(this.getFuelSpeed(), this));
            if (!this.f_58857_.f_46443_) {
                return;
            }
            Float angle = this.getTargetAngle();
            if (angle == null) {
                return;
            }
            angle = Float.valueOf((angle = Float.valueOf((float)((double)(angle.floatValue() * 180.0f) / Math.PI))).floatValue() < 0.0f ? 360.0f - angle.floatValue() : angle.floatValue());
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)HugeDieselEngineBlock.FACING);
            float f = facing == Direction.NORTH ? 180.0f : (facing == Direction.SOUTH ? 0.0f : (facing == Direction.EAST ? 0.0f : (facing == Direction.WEST ? 180.0f : (shaftR = facing == Direction.DOWN ? 90.0f : -90.0f))));
            if ((this.oldAngle + shaftR) % 360.0f > (angle.floatValue() + shaftR) % 360.0f) {
                this.upgrade.playSounds(0, this);
            }
            this.oldAngle = angle.floatValue();
        } else {
            shaft.removeGenerator(this.f_58858_);
        }
    }

    public PoweredEngineShaftBlockEntity getShaft() {
        PoweredEngineShaftBlockEntity shaft = (PoweredEngineShaftBlockEntity)((Object)this.target.get());
        if (shaft == null || shaft.m_58901_() || !shaft.canBePoweredBy(this.f_58858_)) {
            if (shaft != null) {
                this.target = new WeakReference<Object>(null);
            }
            BlockEntity anyShaftAt = this.f_58857_.m_7702_(this.f_58858_.m_5484_((Direction)this.m_58900_().m_61143_((Property)HugeDieselEngineBlock.FACING), 2));
            BlockState sState = this.f_58857_.m_8055_(this.f_58858_.m_5484_((Direction)this.m_58900_().m_61143_((Property)HugeDieselEngineBlock.FACING), 2));
            if (anyShaftAt instanceof PoweredEngineShaftBlockEntity) {
                PoweredEngineShaftBlockEntity ps;
                shaft = ps = (PoweredEngineShaftBlockEntity)anyShaftAt;
                this.target = new WeakReference<PoweredEngineShaftBlockEntity>(shaft);
            } else if (sState.m_60734_() instanceof ShaftBlock && sState.m_61143_((Property)RotatedPillarKineticBlock.AXIS) != ((Direction)this.m_58900_().m_61143_((Property)HugeDieselEngineBlock.FACING)).m_122434_()) {
                this.f_58857_.m_7731_(this.f_58858_.m_5484_((Direction)this.m_58900_().m_61143_((Property)HugeDieselEngineBlock.FACING), 2), PoweredEngineShaftBlock.getEquivalent(this.f_58857_.m_8055_(this.f_58858_.m_5484_((Direction)this.m_58900_().m_61143_((Property)HugeDieselEngineBlock.FACING), 2))), 3);
            }
        }
        return shaft;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = CCProxy.behaviour(this);
        behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)CreateLang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new HugeDieselEngineValueBox());
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)100);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    private void onDirectionChanged() {
        PoweredEngineShaftBlockEntity shaft = this.getShaft();
        if (shaft == null) {
            return;
        }
        for (Pair<BlockPos, Couple<Float>> engine : shaft.engines) {
            BlockEntity blockEntity = this.f_58857_.m_7702_((BlockPos)engine.getFirst());
            if (!(blockEntity instanceof HugeDieselEngineBlockEntity)) continue;
            HugeDieselEngineBlockEntity be = (HugeDieselEngineBlockEntity)blockEntity;
            be.movementDirection.setValue(this.movementDirection.getValue());
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == null) {
            return this.tank.getCapability().cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && ((Boolean)this.m_58900_().m_61143_((Property)BooleanProperty.m_61465_((String)side.toString()))).booleanValue() && side.m_122434_() != ((Direction)this.m_58900_().m_61143_((Property)HugeDieselEngineBlock.FACING)).m_122434_()) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled() || !this.enabled()) {
            return false;
        }
        PoweredEngineShaftBlockEntity shaft = this.getShaft();
        if (shaft == null) {
            return false;
        }
        float stressBase = FuelTypeManager.getGeneratedStress((BlockEntity)this, this.tank.getPrimaryHandler().getFluid().getFluid());
        if (Mth.m_14033_((float)stressBase, (float)0.0f)) {
            return false;
        }
        CreateLang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        float stressTotal = Math.abs(stressBase);
        CreateLang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability().cast());
    }

    @OnlyIn(value=Dist.CLIENT)
    public Float getTargetAngle() {
        BlockState state = this.m_58900_();
        if (!CDGBlocks.HUGE_DIESEL_ENGINE.has(state)) {
            return null;
        }
        Direction facing = (Direction)state.m_61143_((Property)HugeDieselEngineBlock.FACING);
        PoweredEngineShaftBlockEntity shaft = this.getShaft();
        Direction.Axis facingAxis = facing.m_122434_();
        if (shaft == null) {
            return null;
        }
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)shaft);
        float angle = KineticBlockEntityRenderer.getAngleForBe((KineticBlockEntity)shaft, (BlockPos)shaft.m_58899_(), (Direction.Axis)axis);
        if (axis == facingAxis) {
            return null;
        }
        if (axis.m_122479_() && facingAxis == Direction.Axis.X ^ facing.m_122421_() == Direction.AxisDirection.POSITIVE) {
            angle *= -1.0f;
        }
        if (axis == Direction.Axis.X && facing == Direction.DOWN) {
            angle *= -1.0f;
        }
        return Float.valueOf(angle);
    }

    @Override
    public int getTick() {
        return this.tick;
    }

    @Override
    public SmartBlockEntity self() {
        return this;
    }

    @Override
    public SmartFluidTankBehaviour getTank() {
        return this.tank;
    }

    @Override
    public void playSound() {
        if (this.f_58857_.f_46443_ && Minecraft.m_91087_().f_91074_.m_20182_().m_82554_(Vec3.m_82539_((Vec3i)this.f_58858_)) < 15.0) {
            this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (SoundEvent)CDGSounds.DIESEL_ENGINE_SOUND.get(), SoundSource.BLOCKS, 0.3f, 1.0f, false);
        }
    }
}

