/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.modular;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGSounds;
import com.jesz.createdieselgenerators.compat.computercraft.CCProxy;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineUpgrades;
import com.jesz.createdieselgenerators.content.diesel_engine.IEngine;
import com.jesz.createdieselgenerators.content.diesel_engine.modular.ModularDieselEngineBlock;
import com.jesz.createdieselgenerators.content.diesel_engine.modular.ModularDieselEngineValueBox;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ModularDieselEngineBlockEntity
extends GeneratingKineticBlockEntity
implements IEngine {
    public ModularDieselEngineBlockEntity controller = null;
    BlockPos controllerPos = null;
    int tick;
    public int length;
    EngineUpgrades upgrade = EngineUpgrades.NONE;
    public SmartFluidTankBehaviour tank;
    public ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public AbstractComputerBehaviour computerBehaviour;
    int soundCounter = 0;
    float currentStressPitch = 0.0f;
    float targetStressPitch = 0.0f;
    float lastSpeed = 0.0f;
    float lastCapacity = 0.0f;

    public ModularDieselEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)ModularDieselEngineBlock.PIPE)).booleanValue()) {
            ModularDieselEngineBlockEntity controller = this.controller;
            if (cap == ForgeCapabilities.FLUID_HANDLER && (side == Direction.UP || side == null)) {
                if (controller != null) {
                    return controller.tank.getCapability().cast();
                }
                return this.tank.getCapability().cast();
            }
        }
        return super.getCapability(cap, side);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Tick", this.tick);
        if (this.controllerPos != null) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controllerPos));
        }
        if (clientPacket) {
            compound.m_128350_("Pitch", this.targetStressPitch);
        }
        compound.m_128359_("Upgrade", this.upgrade.getId().toString());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tick = compound.m_128451_("Tick");
        this.controllerPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        if (clientPacket) {
            this.targetStressPitch = compound.m_128457_("Pitch");
        }
        this.upgrade = EngineUpgrades.NONE;
        for (EngineUpgrades upgrade : EngineUpgrades.allUpgrades) {
            if (!upgrade.getId().toString().equals(compound.m_128461_("Upgrade"))) continue;
            this.upgrade = upgrade;
            break;
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = CCProxy.behaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)CreateLang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new ModularDieselEngineValueBox());
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
        super.addBehaviours(behaviours);
    }

    public void onDirectionChanged() {
        ModularDieselEngineBlockEntity controller = this.controller;
        if (controller == null) {
            return;
        }
        ModularDieselEngineBlockEntity lastEngine = this.getBackEngine();
        if (lastEngine == null) {
            return;
        }
        while (lastEngine != null) {
            lastEngine.movementDirection.setValue(this.movementDirection.getValue());
            lastEngine = lastEngine.getBackEngine();
        }
    }

    public void initialize() {
        super.initialize();
        this.updateConnectivity();
    }

    public float calculateAddedStressCapacity() {
        this.capacity = this.getGeneratedSpeed() == 0.0f ? 0.0f : (!this.validFS() ? 0.0f : (!this.enabled() ? 0.0f : this.upgrade.getStress(this.getFuelStress() * (float)this.length, this)));
        this.lastCapacityProvided = this.capacity;
        return this.capacity;
    }

    public float getGeneratedSpeed() {
        if (!this.validFS() || this.controller != this) {
            return 0.0f;
        }
        if (!this.enabled()) {
            return 0.0f;
        }
        return ModularDieselEngineBlockEntity.convertToDirection((float)((float)(this.movementDirection.getValue() == 1 ? -1 : 1) * this.upgrade.getSpeed(IEngine.super.getFuelSpeed(), this)), (Direction)((Direction)this.m_58900_().m_61143_((Property)ModularDieselEngineBlock.FACING)));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        ModularDieselEngineBlockEntity frontEngine = this.controller;
        if (!IRotate.StressImpact.isEnabled() || frontEngine == null) {
            return added;
        }
        float stressBase = frontEngine.calculateAddedStressCapacity();
        if (Mth.m_14033_((float)stressBase, (float)0.0f)) {
            return added;
        }
        if (frontEngine != this) {
            CreateLang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
            CreateLang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            float stressTotal = Math.abs(frontEngine.getGeneratedSpeed() * stressBase);
            CreateLang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, frontEngine.tank.getCapability().cast());
    }

    public void tick() {
        ModularDieselEngineBlockEntity controller;
        super.tick();
        this.currentStressPitch = Mth.m_14179_((float)0.2f, (float)this.currentStressPitch, (float)this.targetStressPitch);
        if (this.getGeneratedSpeed() != this.lastSpeed || this.lastCapacity != this.calculateAddedStressCapacity()) {
            this.reActivateSource = true;
            this.lastCapacityProvided = this.lastCapacity;
            this.lastCapacity = this.calculateAddedStressCapacity();
            this.lastSpeed = this.getGeneratedSpeed();
        }
        if ((controller = this.controller) == null) {
            return;
        }
        if (controller != this) {
            this.tank.getPrimaryHandler().drain(controller.tank.getPrimaryHandler().fill(this.tank.getPrimaryHandler().getFluid(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            if (this.upgrade != EngineUpgrades.NONE && controller.upgrade == EngineUpgrades.NONE) {
                controller.upgrade = this.upgrade;
                this.upgrade = EngineUpgrades.NONE;
            }
        }
        if (controller.validFS() && controller.enabled() && (controller == this || this.f_58858_.hashCode() == 11)) {
            this.tickFuelUsage(this.length);
            controller.upgrade.playSounds(this.tick, this);
        }
        ++this.tick;
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.targetStressPitch = maxStress == 0.0f ? 0.0f : currentStress / maxStress * 4.0f;
        this.sendData();
    }

    public ModularDieselEngineBlockEntity getBackEngine() {
        ModularDieselEngineBlockEntity be;
        Direction facing = (Direction)this.m_58900_().m_61143_(ModularDieselEngineBlock.HORIZONTAL_FACING);
        if (facing.m_122421_() == Direction.AxisDirection.POSITIVE) {
            facing = facing.m_122424_();
        }
        return (be = (ModularDieselEngineBlockEntity)this.f_58857_.m_141902_(this.f_58858_.m_121945_(facing), (BlockEntityType)CDGBlockEntityTypes.LARGE_DIESEL_ENGINE.get()).orElse(null)) == null ? null : (((Direction)be.m_58900_().m_61143_((Property)ModularDieselEngineBlock.FACING)).m_122434_() != ((Direction)this.m_58900_().m_61143_((Property)ModularDieselEngineBlock.FACING)).m_122434_() ? null : be);
    }

    public ModularDieselEngineBlockEntity getFrontEngine() {
        ModularDieselEngineBlockEntity be;
        Direction facing = (Direction)this.m_58900_().m_61143_(ModularDieselEngineBlock.HORIZONTAL_FACING);
        if (facing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
            facing = facing.m_122424_();
        }
        return (be = (ModularDieselEngineBlockEntity)this.f_58857_.m_141902_(this.f_58858_.m_121945_(facing), (BlockEntityType)CDGBlockEntityTypes.LARGE_DIESEL_ENGINE.get()).orElse(null)) == null ? null : (((Direction)be.m_58900_().m_61143_((Property)ModularDieselEngineBlock.FACING)).m_122434_() != ((Direction)this.m_58900_().m_61143_((Property)ModularDieselEngineBlock.FACING)).m_122434_() ? null : be);
    }

    public void updateConnectivity() {
        ModularDieselEngineBlockEntity frontEngine = this.getFrontEngine();
        if (frontEngine != null) {
            frontEngine.updateConnectivity();
            return;
        }
        this.controller = this;
        this.controllerPos = this.f_58858_;
        ModularDieselEngineBlockEntity backEngine = this.getBackEngine();
        if (backEngine == null) {
            this.length = 1;
            return;
        }
        ModularDieselEngineBlockEntity lastEngine = backEngine;
        int length = 1;
        while (lastEngine != null) {
            lastEngine = lastEngine.getBackEngine();
            ++length;
        }
        this.length = length;
        for (lastEngine = backEngine; lastEngine != null; lastEngine = lastEngine.getBackEngine()) {
            lastEngine.length = length;
            lastEngine.controller = this.controller;
            lastEngine.controllerPos = this.controllerPos;
        }
    }

    public void removed() {
        for (ModularDieselEngineBlockEntity lastEngine = this.getBackEngine(); lastEngine != null; lastEngine = lastEngine.getBackEngine()) {
            this.tank.getPrimaryHandler().drain(lastEngine.tank.getPrimaryHandler().fill(this.tank.getPrimaryHandler().getFluid(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            lastEngine.length = 1;
            lastEngine.controller = null;
        }
    }

    @Override
    public int getTick() {
        return this.tick;
    }

    @Override
    public SmartBlockEntity self() {
        return this;
    }

    @Override
    public SmartFluidTankBehaviour getTank() {
        return this.tank;
    }

    @Override
    public void playSound() {
        if (this.f_58857_.f_46443_ && Minecraft.m_91087_().f_91074_.m_20182_().m_82554_(Vec3.m_82539_((Vec3i)this.f_58858_)) < 15.0) {
            this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (SoundEvent)CDGSounds.DIESEL_ENGINE_SOUND.get(), SoundSource.BLOCKS, 0.3f, 1.0f + this.currentStressPitch, false);
        }
    }
}

