/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.normal;

import com.jesz.createdieselgenerators.CDGSounds;
import com.jesz.createdieselgenerators.compat.computercraft.CCProxy;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineUpgrades;
import com.jesz.createdieselgenerators.content.diesel_engine.IEngine;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlock;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineValueBox;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;

public class DieselEngineBlockEntity
extends GeneratingKineticBlockEntity
implements IEngine {
    public SmartFluidTankBehaviour tank;
    public AbstractComputerBehaviour computerBehaviour;
    public ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    int tick;
    EngineUpgrades upgrade = EngineUpgrades.NONE;
    BlockState state;
    float currentStressPitch = 0.0f;
    float targetStressPitch = 0.0f;

    public DieselEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.state = state;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        if (this.state.m_61143_((Property)DieselEngineBlock.FACING) == Direction.DOWN) {
            if (cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.WEST) {
                return this.tank.getCapability().cast();
            }
            if (cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.EAST) {
                return this.tank.getCapability().cast();
            }
        } else if (this.state.m_61143_((Property)DieselEngineBlock.FACING) == Direction.UP) {
            if (cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.NORTH) {
                return this.tank.getCapability().cast();
            }
            if (cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.SOUTH) {
                return this.tank.getCapability().cast();
            }
        } else if (cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.DOWN) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Tick", this.tick);
        if (clientPacket) {
            compound.m_128350_("Pitch", this.targetStressPitch);
        }
        compound.m_128359_("Upgrade", this.upgrade.getId().toString());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tick = compound.m_128451_("Tick");
        if (clientPacket) {
            this.targetStressPitch = compound.m_128457_("Pitch");
        }
        this.upgrade = EngineUpgrades.NONE;
        for (EngineUpgrades upgrade : EngineUpgrades.allUpgrades) {
            if (!upgrade.getId().toString().equals(compound.m_128461_("Upgrade"))) continue;
            this.upgrade = upgrade;
            break;
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = CCProxy.behaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)CreateLang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new DieselEngineValueBox());
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
        super.addBehaviours(behaviours);
    }

    public void onDirectionChanged() {
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        if (this.getGeneratedSpeed() == 0.0f || !this.enabled()) {
            return 0.0f;
        }
        this.lastCapacityProvided = capacity = this.upgrade.getStress(this.getFuelStress(), this);
        return capacity;
    }

    public float getGeneratedSpeed() {
        if (!this.enabled()) {
            return 0.0f;
        }
        return DieselEngineBlockEntity.convertToDirection((float)((float)(this.movementDirection.getValue() == 1 ? -1 : 1) * this.upgrade.getStress(IEngine.super.getFuelSpeed(), this)), (Direction)((Direction)this.state.m_61143_((Property)DieselEngineBlock.FACING)));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!IRotate.StressImpact.isEnabled()) {
            return added;
        }
        float stressBase = this.calculateAddedStressCapacity();
        if (Mth.m_14033_((float)stressBase, (float)0.0f)) {
            return added;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability().cast());
    }

    public void tick() {
        super.tick();
        this.state = this.m_58900_();
        this.reActivateSource = true;
        this.currentStressPitch = Mth.m_14179_((float)0.2f, (float)this.currentStressPitch, (float)this.targetStressPitch);
        if (this.f_58857_.f_46443_ && this.enabled()) {
            this.upgrade.playSounds(this.tick, this);
        }
        if (this.enabled()) {
            this.tickFuelUsage();
            ++this.tick;
        }
    }

    @Override
    public void playSound() {
        if (this.f_58857_.f_46443_ && Minecraft.m_91087_().f_91074_.m_20182_().m_82554_(Vec3.m_82539_((Vec3i)this.f_58858_)) < 15.0) {
            this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (SoundEvent)CDGSounds.DIESEL_ENGINE_SOUND.get(), SoundSource.BLOCKS, 0.3f, 1.0f + this.currentStressPitch, false);
        }
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.targetStressPitch = maxStress == 0.0f ? 0.0f : currentStress / maxStress * 4.0f;
        this.sendData();
    }

    @Override
    public int getTick() {
        return this.tick;
    }

    @Override
    public SmartBlockEntity self() {
        return this;
    }

    @Override
    public SmartFluidTankBehaviour getTank() {
        return this.tank;
    }
}

