/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.entity_filter;

import com.jesz.createdieselgenerators.CDGMenuTypes;
import com.jesz.createdieselgenerators.content.entity_filter.EntityAttribute;
import com.jesz.createdieselgenerators.content.entity_filter.EntityFilterMenu;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class EntityFilterItem
extends Item {
    public EntityFilterItem(Item.Properties properties) {
        super(properties);
    }

    static Map<EntityAttribute, CompoundTag> getEntries(ItemStack stack) {
        HashMap<EntityAttribute, CompoundTag> entries = new HashMap<EntityAttribute, CompoundTag>();
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return entries;
        }
        NBTHelper.iterateCompoundList((ListTag)tag.m_128437_("MatchedAttributes", 10), t -> {
            EntityAttribute attribute = EntityAttribute.fromNBT(t);
            if (attribute != null) {
                entries.put(attribute, (CompoundTag)t);
            }
        });
        return entries;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (AllKeys.shiftDown()) {
            return;
        }
        List<Component> makeSummary = this.makeSummary(stack);
        if (makeSummary.isEmpty()) {
            return;
        }
        tooltip.add(CommonComponents.f_263701_);
        tooltip.addAll(makeSummary);
    }

    private List<Component> makeSummary(ItemStack filter) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (!filter.m_41782_()) {
            return list;
        }
        AttributeFilterMenu.WhitelistMode whitelistMode = AttributeFilterMenu.WhitelistMode.values()[filter.m_41784_().m_128451_("WhitelistMode")];
        list.add((Component)(whitelistMode == AttributeFilterMenu.WhitelistMode.WHITELIST_CONJ ? CreateLang.translateDirect((String)"gui.attribute_filter.allow_list_conjunctive", (Object[])new Object[0]) : (whitelistMode == AttributeFilterMenu.WhitelistMode.WHITELIST_DISJ ? CreateLang.translateDirect((String)"gui.attribute_filter.allow_list_disjunctive", (Object[])new Object[0]) : CreateLang.translateDirect((String)"gui.attribute_filter.deny_list", (Object[])new Object[0]))).m_130940_(ChatFormatting.GOLD));
        int count = 0;
        ListTag attributes = filter.m_41784_().m_128437_("MatchedAttributes", 10);
        for (Tag inbt : attributes) {
            CompoundTag compound = (CompoundTag)inbt;
            EntityAttribute attribute = EntityAttribute.fromNBT(compound);
            if (attribute == null) continue;
            boolean inverted = compound.m_128471_("Inverted");
            if (count > 3) {
                list.add((Component)Component.m_237113_((String)"- ...").m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            list.add((Component)Component.m_237113_((String)"- ").m_7220_(attribute.format(inverted)));
            ++count;
        }
        if (count == 0) {
            return Collections.emptyList();
        }
        return list;
    }

    public static boolean test(ItemStack stack, Entity entity) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        AtomicBoolean passed = new AtomicBoolean(false);
        if (tag.m_128451_("Whitelist") == 1) {
            passed.set(true);
        }
        EntityFilterItem.getEntries(stack).forEach((entry, data) -> {
            boolean currentAttributePassed = entry.test(entity) ^ data.m_128471_("Inverted");
            if (tag.m_128451_("Whitelist") != 1 && !passed.get()) {
                passed.set(currentAttributePassed);
            }
            if (tag.m_128451_("Whitelist") == 1) {
                passed.set(currentAttributePassed && passed.get());
            }
        });
        return passed.get() ^ tag.m_128451_("Whitelist") == 2;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stackInHand = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19096_((Object)stackInHand);
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inventory, player1) -> new EntityFilterMenu((MenuType)CDGMenuTypes.ENTITY_FILTER.get(), id, inventory, stackInHand), this.m_41466_()), buf -> buf.m_130055_(stackInHand));
        return InteractionResultHolder.m_19090_((Object)stackInHand);
    }
}

