/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.entity_filter;

import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.content.entity_filter.EntityAttribute;
import com.jesz.createdieselgenerators.content.entity_filter.EntityFilterMenu;
import com.jesz.createdieselgenerators.packets.CDGPackets;
import com.jesz.createdieselgenerators.packets.EntityFilterScreenPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.filter.AbstractFilterMenu;
import com.simibubi.create.content.logistics.filter.AbstractFilterScreen;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.FilterScreenPacket;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class EntityFilterScreen
extends AbstractFilterScreen<EntityFilterMenu> {
    IconButton whitelistCon;
    IconButton whitelistDis;
    IconButton blacklist;
    IconButton add;
    IconButton addInverted;
    Indicator whitelistConIndicator;
    Indicator whitelistDisIndicator;
    Indicator blacklistIndicator;
    SelectionScrollInput attributeSelector;
    List<Component> selectedAttributes = new ArrayList<Component>();
    List<EntityAttribute> attributesOfItem = new ArrayList<EntityAttribute>();
    Label attributeSelectorLabel;
    ItemStack lastItemScanned = ItemStack.f_41583_;

    public EntityFilterScreen(EntityFilterMenu menu, Inventory inv, Component title) {
        super((AbstractFilterMenu)menu, inv, title, AllGuiTextures.ATTRIBUTE_FILTER);
    }

    protected void m_7856_() {
        this.setWindowOffset(-11, 7);
        super.m_7856_();
        this.whitelistDis = new IconButton(this.f_97735_ + 38, this.f_97736_ + 61, (ScreenElement)AllIcons.I_WHITELIST_OR);
        this.whitelistCon = new IconButton(this.f_97735_ + 56, this.f_97736_ + 61, (ScreenElement)AllIcons.I_WHITELIST_AND);
        this.blacklist = new IconButton(this.f_97735_ + 74, this.f_97736_ + 61, (ScreenElement)AllIcons.I_WHITELIST_NOT);
        this.whitelistCon.withCallback(() -> {
            ((EntityFilterMenu)this.f_97732_).whitelist = AttributeFilterMenu.WhitelistMode.WHITELIST_CONJ;
            this.sendOptionUpdate(FilterScreenPacket.Option.WHITELIST2);
        });
        this.whitelistCon.setToolTip(CreateDieselGenerators.lang("gui.entity_filter.allow_list_conjunctive", new Object[0]));
        this.whitelistDis.withCallback(() -> {
            ((EntityFilterMenu)this.f_97732_).whitelist = AttributeFilterMenu.WhitelistMode.WHITELIST_DISJ;
            this.sendOptionUpdate(FilterScreenPacket.Option.WHITELIST);
        });
        this.whitelistDis.setToolTip(CreateDieselGenerators.lang("gui.entity_filter.allow_list_disjunctive", new Object[0]));
        this.blacklist.withCallback(() -> {
            ((EntityFilterMenu)this.f_97732_).whitelist = AttributeFilterMenu.WhitelistMode.BLACKLIST;
            this.sendOptionUpdate(FilterScreenPacket.Option.BLACKLIST);
        });
        this.blacklist.setToolTip(CreateDieselGenerators.lang("gui.entity_filter.deny_list", new Object[0]));
        this.addRenderableWidgets((GuiEventListener[])new IconButton[]{this.whitelistCon, this.whitelistDis, this.blacklist});
        this.add = new IconButton(this.f_97735_ + 182, this.f_97736_ + 26, (ScreenElement)AllIcons.I_ADD);
        this.m_142416_((GuiEventListener)this.add);
        this.addInverted = new IconButton(this.f_97735_ + 200, this.f_97736_ + 26, (ScreenElement)AllIcons.I_ADD_INVERTED_ATTRIBUTE);
        this.m_142416_((GuiEventListener)this.addInverted);
        this.add.withCallback(() -> this.handleAddedAttribute(false));
        this.add.setToolTip(CreateDieselGenerators.lang("gui.entity_filter.add_attribute", new Object[0]));
        this.addInverted.withCallback(() -> this.handleAddedAttribute(true));
        this.addInverted.setToolTip(CreateDieselGenerators.lang("gui.entity_filter.add_inverted_attribute", new Object[0]));
        this.handleIndicators();
        this.attributeSelectorLabel = new Label(this.f_97735_ + 43, this.f_97736_ + 31, (Component)Component.m_237119_()).colored(15985630).withShadow();
        this.attributeSelector = new SelectionScrollInput(this.f_97735_ + 39, this.f_97736_ + 26, 137, 18);
        this.attributeSelector.forOptions(Arrays.asList(Component.m_237119_()));
        this.attributeSelector.removeCallback();
        this.referenceItemChanged(((EntityFilterMenu)this.f_97732_).ghostInventory.getStackInSlot(0));
        this.m_142416_((GuiEventListener)this.attributeSelector);
        this.m_142416_((GuiEventListener)this.attributeSelectorLabel);
        this.selectedAttributes.clear();
        this.selectedAttributes.add((Component)(((EntityFilterMenu)this.f_97732_).selectedAttributes.isEmpty() ? CreateDieselGenerators.lang("gui.entity_filter.no_selected_attributes", new Object[0]) : CreateDieselGenerators.lang("gui.entity_filter.selected_attributes", new Object[0])).m_6879_().m_130940_(ChatFormatting.YELLOW));
        ((EntityFilterMenu)this.f_97732_).selectedAttributes.forEach(at -> this.selectedAttributes.add((Component)Component.m_237113_((String)"- ").m_7220_(((EntityAttribute)at.getFirst()).format((Boolean)at.getSecond())).m_130940_(ChatFormatting.GRAY)));
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.f_97736_ + this.background.getHeight() + 4;
        this.renderPlayerInventory(graphics, invX, invY);
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.background.render(graphics, x, y);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)((ItemStack)((EntityFilterMenu)this.f_97732_).contentHolder)).at((float)(x + this.background.getWidth() + 8), (float)(y + this.background.getHeight() - 52), -200.0f)).scale(4.0).render(graphics);
    }

    private void referenceItemChanged(ItemStack stack) {
        this.lastItemScanned = stack;
        if (stack.m_41619_()) {
            this.attributeSelector.f_93623_ = false;
            this.attributeSelector.f_93624_ = false;
            this.attributeSelectorLabel.text = CreateDieselGenerators.lang("gui.entity_filter.add_reference_item", new Object[0]).m_6879_().m_130940_(ChatFormatting.ITALIC);
            this.add.f_93623_ = false;
            this.addInverted.f_93623_ = false;
            this.attributeSelector.calling(s -> {});
            return;
        }
        this.add.f_93623_ = true;
        this.addInverted.f_93623_ = true;
        this.attributeSelector.titled(stack.m_41786_().m_6879_().m_130946_("..."));
        this.attributesOfItem.clear();
        for (EntityAttribute entityAttribute : EntityAttribute.all) {
            this.attributesOfItem.addAll(entityAttribute.listAttributesOf(stack));
        }
        List options = this.attributesOfItem.stream().map(a -> a.format(false)).collect(Collectors.toList());
        this.attributeSelector.forOptions(options);
        this.attributeSelector.f_93623_ = true;
        this.attributeSelector.f_93624_ = true;
        this.attributeSelector.setState(0);
        this.attributeSelector.calling(i -> {
            if (options.isEmpty()) {
                return;
            }
            this.attributeSelectorLabel.setTextAndTrim((Component)options.get((int)i), true, 112);
            EntityAttribute selected = this.attributesOfItem.get((int)i);
            for (Pair<EntityAttribute, Boolean> existing : ((EntityFilterMenu)this.f_97732_).selectedAttributes) {
                CompoundTag testTag2;
                CompoundTag testTag = ((EntityAttribute)existing.getFirst()).write();
                if (!testTag.equals((Object)(testTag2 = selected.write()))) continue;
                this.add.f_93623_ = false;
                this.addInverted.f_93623_ = false;
                return;
            }
            this.add.f_93623_ = true;
            this.addInverted.f_93623_ = true;
        });
        this.attributeSelector.onChanged();
    }

    protected boolean handleAddedAttribute(boolean inverted) {
        int index = this.attributeSelector.getState();
        if (index >= this.attributesOfItem.size()) {
            return false;
        }
        this.add.f_93623_ = false;
        this.addInverted.f_93623_ = false;
        EntityAttribute itemAttribute = this.attributesOfItem.get(index);
        CompoundTag tag = itemAttribute.write();
        CDGPackets.getChannel().sendToServer((Object)new EntityFilterScreenPacket(inverted ? FilterScreenPacket.Option.ADD_INVERTED_TAG : FilterScreenPacket.Option.ADD_TAG, tag));
        ((EntityFilterMenu)this.f_97732_).appendSelectedAttribute(itemAttribute, inverted);
        if (((EntityFilterMenu)this.f_97732_).selectedAttributes.size() == 1) {
            this.selectedAttributes.set(0, (Component)CreateDieselGenerators.lang("gui.entity_filter.selected_attributes", new Object[0]).m_6879_().m_130940_(ChatFormatting.YELLOW));
        }
        this.selectedAttributes.add((Component)Component.m_237113_((String)"- ").m_7220_(itemAttribute.format(inverted)).m_130940_(ChatFormatting.GRAY));
        return true;
    }

    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ItemStack stack = ((EntityFilterMenu)this.f_97732_).ghostInventory.getStackInSlot(1);
        PoseStack matrixStack = graphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, 0.0f, 150.0f);
        graphics.m_280302_(this.f_96547_, stack, this.f_97735_ + 16, this.f_97736_ + 62, String.valueOf(this.selectedAttributes.size() - 1));
        matrixStack.m_85849_();
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        if (((EntityFilterMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ != null && this.f_97734_.m_6657_()) {
            if (this.f_97734_.f_40219_ == 37) {
                graphics.m_280666_(this.f_96547_, this.selectedAttributes, mouseX, mouseY);
                return;
            }
            graphics.m_280153_(this.f_96547_, this.f_97734_.m_7993_(), mouseX, mouseY);
        }
        super.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_181908_() {
        super.m_181908_();
        ItemStack stackInSlot = ((EntityFilterMenu)this.f_97732_).ghostInventory.getStackInSlot(0);
        if (!stackInSlot.equals(this.lastItemScanned, false)) {
            this.referenceItemChanged(stackInSlot);
        }
    }

    protected void contentsCleared() {
        this.selectedAttributes.clear();
        this.selectedAttributes.add((Component)CreateDieselGenerators.lang("gui.entity_filter.no_selected_attributes", new Object[0]).m_6879_().m_130940_(ChatFormatting.YELLOW));
        if (!this.lastItemScanned.m_41619_()) {
            this.add.f_93623_ = true;
            this.addInverted.f_93623_ = true;
        }
    }

    protected boolean isButtonEnabled(IconButton button) {
        if (button == this.blacklist) {
            return ((EntityFilterMenu)this.f_97732_).whitelist != AttributeFilterMenu.WhitelistMode.BLACKLIST;
        }
        if (button == this.whitelistCon) {
            return ((EntityFilterMenu)this.f_97732_).whitelist != AttributeFilterMenu.WhitelistMode.WHITELIST_CONJ;
        }
        if (button == this.whitelistDis) {
            return ((EntityFilterMenu)this.f_97732_).whitelist != AttributeFilterMenu.WhitelistMode.WHITELIST_DISJ;
        }
        return true;
    }

    protected List<IconButton> getTooltipButtons() {
        return Arrays.asList(this.blacklist, this.whitelistCon, this.whitelistDis);
    }

    protected List<MutableComponent> getTooltipDescriptions() {
        return Arrays.asList(CreateDieselGenerators.lang("gui.entity_filter.deny_list.description", new Object[0]).m_6879_(), CreateDieselGenerators.lang("gui.entity_filter.allow_list_conjunctive.description", new Object[0]).m_6879_(), CreateDieselGenerators.lang("gui.entity_filter.allow_list_disjunctive.description", new Object[0]).m_6879_());
    }

    protected void sendOptionUpdate(FilterScreenPacket.Option option) {
        CDGPackets.getChannel().sendToServer((Object)new EntityFilterScreenPacket(option));
    }
}

