/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.fluid_coupling;

import com.jesz.createdieselgenerators.content.fluid_coupling.FluidCouplingBlock;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FluidCouplingBlockEntity
extends GeneratingKineticBlockEntity {
    WeakReference<FluidCouplingBlockEntity> coupledBE = new WeakReference<Object>(null);
    SmartFluidTankBehaviour tank;
    float generatedSpeed = 0.0f;
    float generatedCapacity = 0.0f;
    float lastStressAvailable = 0.0f;
    float soundRotations = 0.0f;

    public FluidCouplingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public void tick() {
        super.tick();
        FluidCouplingBlockEntity coupled = (FluidCouplingBlockEntity)((Object)this.coupledBE.get());
        if (coupled == null) {
            this.generatedSpeed = 0.0f;
            this.generatedCapacity = 0.0f;
            this.updateGeneratedRotation();
            return;
        }
        if (this.soundRotations >= 1.0f && ((Boolean)this.m_58900_().m_61143_((Property)FluidCouplingBlock.INPUT)).booleanValue() && this.f_58857_.f_46443_) {
            AllSoundEvents.MIXING.playAt(this.f_58857_, (Vec3i)this.f_58858_, 1.0f, 0.7f, true);
            this.soundRotations = 0.0f;
        }
        this.soundRotations += Math.abs(this.getSpeed()) / 128.0f;
        if (coupled.getOrCreateNetwork() == this.getOrCreateNetwork()) {
            this.generatedCapacity = 0.0f;
            this.generatedSpeed = 0.0f;
            this.updateGeneratedRotation();
            return;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)FluidCouplingBlock.INPUT)).booleanValue()) {
            coupled.generatedSpeed = this.getSpeed() * 0.9f;
            if (coupled.generatedSpeed != 0.0f) {
                coupled.generatedCapacity += 1.0f;
                coupled.generatedCapacity = Math.min(this.lastStressAvailable / Math.abs(this.getSpeed()) * 2.0f, coupled.generatedCapacity);
            } else {
                coupled.generatedCapacity = 0.0f;
            }
            coupled.updateGeneratedRotation();
            KineticNetwork network = this.getOrCreateNetwork();
            if (network != null) {
                network.updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
            }
        }
    }

    boolean isController() {
        FluidCouplingBlockEntity coupled = (FluidCouplingBlockEntity)((Object)this.coupledBE.get());
        if (coupled == null) {
            return false;
        }
        return ((Direction)coupled.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122421_() == Direction.AxisDirection.POSITIVE;
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        super.updateFromNetwork(maxStress, currentStress, networkSize);
        this.lastStressAvailable = maxStress - currentStress;
    }

    public void initialize() {
        super.initialize();
        this.updateCoupledBE();
    }

    public float calculateStressApplied() {
        FluidCouplingBlockEntity coupled = (FluidCouplingBlockEntity)((Object)this.coupledBE.get());
        float impact = 0.0f;
        if (coupled != null && ((Boolean)this.m_58900_().m_61143_((Property)FluidCouplingBlock.INPUT)).booleanValue()) {
            impact = coupled.generatedCapacity;
        }
        this.lastStressApplied = impact;
        return impact;
    }

    public float calculateAddedStressCapacity() {
        if (((Boolean)this.m_58900_().m_61143_((Property)FluidCouplingBlock.INPUT)).booleanValue()) {
            this.lastCapacityProvided = 0.0f;
            return 0.0f;
        }
        this.lastCapacityProvided = this.generatedCapacity;
        return this.generatedCapacity;
    }

    public float getGeneratedSpeed() {
        if (((Boolean)this.m_58900_().m_61143_((Property)FluidCouplingBlock.INPUT)).booleanValue()) {
            return 0.0f;
        }
        return this.generatedSpeed;
    }

    public void updateCoupledBE() {
        FluidCouplingBlockEntity be;
        BlockEntity otherEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122424_()));
        if (otherEntity instanceof FluidCouplingBlockEntity && (be = (FluidCouplingBlockEntity)otherEntity).m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING) == ((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122424_()) {
            this.coupledBE = new WeakReference<FluidCouplingBlockEntity>(be);
            if (be.m_58900_().m_61143_((Property)FluidCouplingBlock.INPUT) == this.m_58900_().m_61143_((Property)FluidCouplingBlock.INPUT)) {
                this.f_58857_.m_7731_(be.m_58899_(), (BlockState)be.m_58900_().m_61124_((Property)FluidCouplingBlock.INPUT, (Comparable)Boolean.valueOf((Boolean)this.m_58900_().m_61143_((Property)FluidCouplingBlock.INPUT) == false)), 3);
            }
        }
    }
}

