/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.blocks.bee_port;

import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.simibubi.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import de.theidler.create_mobile_packages.CreateMobilePackages;
import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBlock;
import de.theidler.create_mobile_packages.blocks.bee_port.BeePortMenu;
import de.theidler.create_mobile_packages.blocks.bee_port.ModCapabilities;
import de.theidler.create_mobile_packages.entities.RoboBeeEntity;
import de.theidler.create_mobile_packages.entities.robo_entity.RoboEntity;
import de.theidler.create_mobile_packages.entities.robo_entity.states.AdjustRotationToTarget;
import de.theidler.create_mobile_packages.index.CMPItems;
import de.theidler.create_mobile_packages.index.config.CMPConfigs;
import de.theidler.create_mobile_packages.items.robo_bee.RoboBeeItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BeePortBlockEntity
extends PackagePortBlockEntity {
    private final ContainerData data = new SimpleContainerData(2);
    private final ItemStackHandler roboBeeInventory = new ItemStackHandler(1);
    private final IItemHandler handler = new IItemHandler(){

        public int getSlots() {
            return BeePortBlockEntity.this.inventory.getSlots() + BeePortBlockEntity.this.roboBeeInventory.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.getStackInSlot(slot);
            }
            return BeePortBlockEntity.this.roboBeeInventory.getStackInSlot(slot - BeePortBlockEntity.this.inventory.getSlots());
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.m_41720_() instanceof RoboBeeItem) {
                if (slot >= BeePortBlockEntity.this.inventory.getSlots()) {
                    return BeePortBlockEntity.this.roboBeeInventory.insertItem(slot - BeePortBlockEntity.this.inventory.getSlots(), stack, simulate);
                }
                return stack;
            }
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.extractItem(slot, amount, simulate);
            }
            return BeePortBlockEntity.this.roboBeeInventory.extractItem(slot - BeePortBlockEntity.this.inventory.getSlots(), amount, simulate);
        }

        public int getSlotLimit(int slot) {
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.getSlotLimit(slot);
            }
            return BeePortBlockEntity.this.roboBeeInventory.getSlotLimit(slot - BeePortBlockEntity.this.inventory.getSlots());
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (stack.m_41720_() instanceof RoboBeeItem) {
                if (slot >= BeePortBlockEntity.this.inventory.getSlots()) {
                    return BeePortBlockEntity.this.roboBeeInventory.isItemValid(slot - BeePortBlockEntity.this.inventory.getSlots(), stack);
                }
                return false;
            }
            if (slot < BeePortBlockEntity.this.inventory.getSlots()) {
                return BeePortBlockEntity.this.inventory.isItemValid(slot, stack);
            }
            return false;
        }
    };
    private int tickCounter = 0;
    private int sendItemThisTime = 0;
    private RoboEntity entityOnTravel = null;

    public BeePortBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.itemHandler = LazyOptional.of(() -> this.handler);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("RoboBeeInventory", (Tag)this.roboBeeInventory.serializeNBT());
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.m_128441_("RoboBeeInventory")) {
            this.roboBeeInventory.deserializeNBT(tag.m_128469_("RoboBeeInventory"));
        }
    }

    public void tick() {
        super.tick();
        if (++this.tickCounter % 20 == 0) {
            this.processItems();
        }
        if (!this.f_58857_.m_5776_()) {
            if (this.getRoboEntity() != null) {
                this.data.m_8050_(0, RoboEntity.calcETA(this.m_58899_().m_252807_(), this.getRoboEntity().m_20182_()));
            }
            this.data.m_8050_(1, this.entityOnTravel != null ? 1 : 0);
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.tryPullingFromAdjacentInventories();
        if (this.f_58857_ != null && this.f_58857_.m_276867_(this.f_58858_)) {
            this.tryPushingToAdjacentInventories();
        }
    }

    private void tryPushingToAdjacentInventories() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemStack = this.inventory.getStackInSlot(i);
            if (!PackageItem.isPackage((ItemStack)itemStack) || !PackageItem.matchAddress((ItemStack)itemStack, (String)this.addressFilter)) continue;
            for (IItemHandler adjacentInventory : this.getAdjacentInventories()) {
                if (!this.tryPushingToInventory(adjacentInventory, itemStack, i)) continue;
                return;
            }
        }
    }

    private boolean tryPushingToInventory(IItemHandler inventory, ItemStack itemStack, int extractSlot) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).m_41619_()) continue;
            inventory.insertItem(i, this.inventory.extractItem(extractSlot, 1, false), false);
            return true;
        }
        return false;
    }

    private void tryPullingFromAdjacentInventories() {
        if (this.hasFullInventory(this.entityOnTravel != null ? 1 : 0)) {
            return;
        }
        this.getAdjacentInventories().forEach(inventory -> {
            if (inventory == null) {
                return;
            }
            if (this.hasFullInventory(this.entityOnTravel != null ? 1 : 0)) {
                return;
            }
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack itemStack = inventory.getStackInSlot(i);
                if (itemStack.m_41619_() || !PackageItem.isPackage((ItemStack)itemStack)) continue;
                this.addItemStack(inventory.extractItem(i, 1, false));
            }
        });
    }

    private List<IItemHandler> getAdjacentInventories() {
        ArrayList<IItemHandler> inventories = new ArrayList<IItemHandler>();
        for (Direction side : Direction.values()) {
            IItemHandler inventory = this.getAdjacentInventory(side);
            if (inventory == null) continue;
            inventories.add(inventory);
        }
        return inventories;
    }

    private IItemHandler getAdjacentInventory(Direction side) {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side));
        if (blockEntity == null || blockEntity instanceof FrogportBlockEntity) {
            return null;
        }
        return (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side.m_122424_()).orElse(null);
    }

    private void processItems() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.sendItemThisTime-- > 0) {
                return;
            }
            ItemStack itemStack = this.inventory.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            this.sendItem(itemStack, i);
        }
    }

    private void sendItem(ItemStack itemStack, int slot) {
        BeePortBlockEntity beePortBlockEntity;
        if (this.f_58857_ == null || !PackageItem.isPackage((ItemStack)itemStack)) {
            return;
        }
        String address = PackageItem.getAddress((ItemStack)itemStack);
        for (Player player : this.f_58857_.m_6907_()) {
            if (!BeePortBlockEntity.doesAddressStringMatchPlayerName(player, address) || !RoboEntity.isWithinRange(player.m_20183_(), this.m_58899_())) continue;
            this.sendToPlayer(player, itemStack, slot);
            return;
        }
        if (((Boolean)CMPConfigs.server().portToPort.get()).booleanValue() && !PackageItem.matchAddress((String)address, (String)this.addressFilter) && (beePortBlockEntity = RoboEntity.getClosestBeePort(this.f_58857_, address, this.m_58899_(), null)) != null && !beePortBlockEntity.isFull()) {
            this.sendDrone(itemStack, slot);
        }
    }

    public static boolean doesAddressStringMatchPlayerName(Player player, String address) {
        String playerName = player.m_7755_().getString();
        int atIndex = address.lastIndexOf(64);
        if (atIndex == -1) {
            return address.equals(playerName);
        }
        return address.substring(atIndex + 1).equals(playerName);
    }

    private static void requestRoboEntity(Level level, BlockPos blockPos) {
        level.getCapability(ModCapabilities.BEE_PORT_ENTITY_TRACKER_CAP).ifPresent(tracker -> {
            ArrayList<BeePortBlockEntity> allBEs = new ArrayList<BeePortBlockEntity>(tracker.getAll());
            allBEs.removeIf(be -> be.m_58899_().equals((Object)blockPos));
            allBEs.removeIf(be -> be.getRoboBeeInventory().getStackInSlot(0).m_41613_() <= 0);
            BeePortBlockEntity target = allBEs.stream().min(Comparator.comparingDouble(a -> a.m_58899_().m_123331_((Vec3i)blockPos))).orElse(null);
            if (target != null) {
                target.sendDrone(blockPos, true);
            }
        });
    }

    private void sendToPlayer(Player player, ItemStack itemStack, int slot) {
        if (this.roboBeeInventory.getStackInSlot(0).m_41613_() <= 0) {
            if (this.entityOnTravel == null) {
                BeePortBlockEntity.requestRoboEntity(this.f_58857_, this.m_58899_());
                return;
            }
            return;
        }
        this.sendItemThisTime = 2;
        CreateMobilePackages.LOGGER.info("Sending package to player: {}", (Object)player.m_7755_().getString());
        this.sendDrone(itemStack, slot);
    }

    private void sendDrone(ItemStack itemStack, int slot) {
        if (this.roboBeeInventory.getStackInSlot(0).m_41613_() <= 0) {
            if (this.entityOnTravel == null) {
                BeePortBlockEntity.requestRoboEntity(this.f_58857_, this.m_58899_());
                return;
            }
            return;
        }
        this.sendItemThisTime = 2;
        RoboBeeEntity drone = new RoboBeeEntity(this.f_58857_, itemStack, null, this.m_58899_());
        this.f_58857_.m_7967_((Entity)drone);
        drone.setRequest(false);
        this.roboBeeInventory.getStackInSlot(0).m_41774_(1);
        this.inventory.setStackInSlot(slot, ItemStack.f_41583_);
    }

    private void sendDrone(BlockPos tagetPos, boolean request) {
        if (this.roboBeeInventory.getStackInSlot(0).m_41613_() <= 0) {
            return;
        }
        this.sendItemThisTime = 2;
        RoboBeeEntity drone = new RoboBeeEntity(this.f_58857_, ItemStack.f_41583_, tagetPos, this.m_58899_());
        this.f_58857_.m_7967_((Entity)drone);
        drone.setRequest(request);
        this.roboBeeInventory.getStackInSlot(0).m_41774_(1);
    }

    public static void setOpen(BeePortBlockEntity entity, boolean open) {
        if (entity == null || entity.f_58857_ == null) {
            return;
        }
        entity.f_58857_.m_46597_(entity.m_58899_(), (BlockState)entity.m_58900_().m_61124_((Property)BeePortBlock.IS_OPEN_TEXTURE, (Comparable)Boolean.valueOf(open)));
        entity.f_58857_.m_247517_(null, entity.m_58899_(), open ? SoundEvents.f_11725_ : SoundEvents.f_11724_, SoundSource.BLOCKS);
    }

    public boolean addItemStack(ItemStack itemStack) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
            this.inventory.insertItem(i, itemStack, false);
            return true;
        }
        return false;
    }

    public static boolean isPlayerInventoryFull(Player player) {
        return player.m_150109_().f_35974_.stream().limit(player.m_150109_().m_6643_() - 5).noneMatch(ItemStack::m_41619_);
    }

    public static boolean sendPackageToPlayer(Player player, ItemStack itemStack) {
        if (player == null || itemStack.m_41619_()) {
            return false;
        }
        player.m_5661_((Component)Component.m_264568_((String)"create_mobile_packages.drone_port.send_items", (String)"Send Items to Player"), true);
        if (BeePortBlockEntity.isPlayerInventoryFull(player)) {
            return false;
        }
        player.m_150109_().m_36054_(itemStack);
        return true;
    }

    protected void onOpenChange(boolean open) {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_247517_(null, this.f_58858_, open ? SoundEvents.f_11725_ : SoundEvents.f_11724_, SoundSource.BLOCKS);
        BeePortBlockEntity.setOpen(this, open);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.getCapability(ModCapabilities.BEE_PORT_ENTITY_TRACKER_CAP).ifPresent(tracker -> tracker.add(this));
        }
    }

    public void remove() {
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.getCapability(ModCapabilities.BEE_PORT_ENTITY_TRACKER_CAP).ifPresent(tracker -> tracker.remove(this));
            if (this.entityOnTravel != null) {
                this.entityOnTravel.setTargetVelocity(Vec3.f_82478_);
                this.entityOnTravel.setState(new AdjustRotationToTarget());
            }
            if (this.roboBeeInventory.getStackInSlot(0).m_41613_() > 0) {
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), this.roboBeeInventory.getStackInSlot(0)));
            }
        }
        super.remove();
    }

    public boolean hasFullInventory(int slotsToLeaveEmpty) {
        int emptySlots = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
            ++emptySlots;
        }
        return emptySlots <= slotsToLeaveEmpty;
    }

    public boolean hasFullRoboSlot(int leaveEmpty) {
        return this.roboBeeInventory.getStackInSlot(0).m_41613_() >= this.roboBeeInventory.getSlotLimit(0) - leaveEmpty;
    }

    public boolean isFull() {
        return this.isFull(0);
    }

    public boolean isFull(int slotsToLeaveEmpty) {
        return this.hasFullInventory(slotsToLeaveEmpty) || this.hasFullRoboSlot(0);
    }

    public boolean canAcceptEntity(RoboEntity entity, Boolean hasPackage) {
        if (this.m_58901_()) {
            return false;
        }
        if (entity == null) {
            return hasPackage.booleanValue() ? !this.isFull() : !this.hasFullRoboSlot(0);
        }
        if (this.entityOnTravel != null && this.entityOnTravel != entity) {
            return false;
        }
        return hasPackage.booleanValue() ? !this.isFull() : !this.hasFullRoboSlot(0);
    }

    public synchronized boolean trySetEntityOnTravel(RoboEntity entity) {
        if (this.entityOnTravel == null || entity == null) {
            this.entityOnTravel = entity;
            return true;
        }
        return false;
    }

    public ItemStackHandler getRoboBeeInventory() {
        return this.roboBeeInventory;
    }

    public void addBeeToRoboBeeInventory(int amount) {
        this.roboBeeInventory.insertItem(0, new ItemStack((ItemLike)CMPItems.ROBO_BEE.get(), amount), false);
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return BeePortMenu.create(pContainerId, pPlayerInventory, this);
    }

    public RoboEntity getRoboEntity() {
        return this.entityOnTravel;
    }

    public ContainerData getData() {
        return this.data;
    }
}

