/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.compat.jei;

import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.CraftableBigItemStack;
import com.simibubi.create.foundation.utility.CreateLang;
import de.theidler.create_mobile_packages.index.CMPMenuTypes;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.PortableStockTickerMenu;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.PortableStockTickerScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.common.transfer.RecipeTransferOperationsResult;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.library.transfer.RecipeTransferErrorMissingSlots;
import mezz.jei.library.transfer.RecipeTransferErrorTooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class DroneControllerTransferHandler
implements IUniversalRecipeTransferHandler<PortableStockTickerMenu> {
    private IJeiHelpers helpers;

    public DroneControllerTransferHandler(IJeiHelpers helpers) {
        this.helpers = helpers;
    }

    public Class<? extends PortableStockTickerMenu> getContainerClass() {
        return PortableStockTickerMenu.class;
    }

    public Optional<MenuType<PortableStockTickerMenu>> getMenuType() {
        return Optional.of((MenuType)CMPMenuTypes.PORTABLE_STOCK_TICKER_MENU.get());
    }

    @Nullable
    public IRecipeTransferError transferRecipe(PortableStockTickerMenu container, Object object, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        Level level = player.m_9236_();
        if (!(object instanceof Recipe)) {
            return null;
        }
        Recipe recipe = (Recipe)object;
        MutableObject result = new MutableObject();
        if (level.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> result.setValue((Object)this.transferRecipeOnClient(container, recipe, recipeSlots, player, maxTransfer, doTransfer)));
        }
        return (IRecipeTransferError)result.getValue();
    }

    private IRecipeTransferError transferRecipeOnClient(PortableStockTickerMenu container, Recipe<?> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        Iterator<CraftableBigItemStack> iterator = container.screenReference;
        if (!(iterator instanceof PortableStockTickerScreen)) {
            return null;
        }
        PortableStockTickerScreen screen = (PortableStockTickerScreen)((Object)iterator);
        for (CraftableBigItemStack craftableBigItemStack : screen.recipesToOrder) {
            if (craftableBigItemStack.recipe != recipe) continue;
            return new RecipeTransferErrorTooltip((Component)CreateLang.translate((String)"gui.stock_keeper.already_ordering_recipe", (Object[])new Object[0]).component());
        }
        if (screen.itemsToOrder.size() >= 9) {
            return new RecipeTransferErrorTooltip((Component)CreateLang.translate((String)"gui.stock_keeper.slots_full", (Object[])new Object[0]).component());
        }
        InventorySummary summary = new InventorySummary();
        for (List<BigItemStack> list : screen.displayedItems) {
            for (BigItemStack stack : list) {
                summary.add(stack);
            }
        }
        RecipeWrapper recipeWrapper = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(9));
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        for (int i = 0; i < recipeWrapper.m_6643_(); ++i) {
            arrayList.add(new Slot((Container)recipeWrapper, i, 0, 0));
        }
        List stacksByCount = summary.getStacksByCount();
        RecipeWrapper inputDummy = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(stacksByCount.size()));
        HashMap<Slot, ItemStack> availableItemStacks = new HashMap<Slot, ItemStack>();
        for (int j = 0; j < stacksByCount.size(); ++j) {
            BigItemStack bigItemStack = (BigItemStack)stacksByCount.get(j);
            availableItemStacks.put(new Slot((Container)inputDummy, j, 0, 0), bigItemStack.stack.m_255036_(bigItemStack.count));
        }
        RecipeTransferOperationsResult transferOperations = RecipeTransferUtil.getRecipeTransferOperations((IStackHelper)this.helpers.getStackHelper(), availableItemStacks, (List)recipeSlots.getSlotViews(RecipeIngredientRole.INPUT), arrayList);
        if (!transferOperations.missingItems.isEmpty()) {
            return new RecipeTransferErrorMissingSlots((Component)CreateLang.translate((String)"gui.stock_keeper.not_in_stock", (Object[])new Object[0]).component(), (Collection)transferOperations.missingItems);
        }
        if (!doTransfer) {
            return null;
        }
        CraftableBigItemStack cbis = new CraftableBigItemStack(recipe.m_8043_(player.m_9236_().m_9598_()), recipe);
        screen.recipesToOrder.add(cbis);
        screen.searchBox.m_94144_("");
        screen.refreshSearchNextTick = true;
        screen.requestCraftable(cbis, maxTransfer ? cbis.stack.m_41741_() : 1);
        return null;
    }
}

