/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.entities.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.logistics.box.PackageItem;
import de.theidler.create_mobile_packages.CreateMobilePackages;
import de.theidler.create_mobile_packages.entities.RoboBeeEntity;
import de.theidler.create_mobile_packages.entities.models.RoboBeeModel;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class DroneEntityRenderer
extends MobRenderer<RoboBeeEntity, RoboBeeModel<RoboBeeEntity>> {
    private static final ResourceLocation TEXTURE = CreateMobilePackages.asResource("textures/entity/robo_bee.png");

    public DroneEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new RoboBeeModel(pContext.m_174023_(RoboBeeModel.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(RoboBeeEntity pEntity) {
        return TEXTURE;
    }

    public void render(RoboBeeEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        ItemStack stack = entity.getItemStack();
        if (!PackageItem.isPackage((ItemStack)stack)) {
            return;
        }
        ResourceLocation modelKey = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        float riggingOffset = PackageItem.getHookDistance((ItemStack)stack);
        float heightScale = entity.getPackageHeightScale().floatValue();
        poseStack.m_85836_();
        poseStack.m_85837_(-0.5, (double)(0.0f - (riggingOffset - 0.3125f) * heightScale), -0.5);
        poseStack.m_85841_(1.0f, heightScale * 1.0f, 1.0f);
        BakedModel rig = ((PartialModel)AllPartialModels.PACKAGE_RIGGING.get(modelKey)).get();
        Minecraft.m_91087_().m_91291_().m_115189_(rig, ItemStack.f_41583_, packedLight, OverlayTexture.f_118083_, poseStack, buffer.m_6299_(ItemBlockRenderTypes.m_109279_((ItemStack)ItemStack.f_41583_, (boolean)true)));
        poseStack.m_85849_();
        if (!stack.m_41619_()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, (double)(0.0f - (riggingOffset - 1.0f + 0.1875f) * heightScale), 0.0);
            poseStack.m_85841_(2.0f, heightScale * 2.0f, 2.0f);
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.f_118083_, poseStack, buffer, entity.m_9236_(), entity.m_19879_());
            poseStack.m_85849_();
        }
    }
}

