/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.entities.robo_entity;

import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.box.PackageItem;
import de.theidler.create_mobile_packages.CreateMobilePackages;
import de.theidler.create_mobile_packages.blocks.bee_port.BeePortBlockEntity;
import de.theidler.create_mobile_packages.blocks.bee_port.ModCapabilities;
import de.theidler.create_mobile_packages.entities.robo_entity.RoboEntityState;
import de.theidler.create_mobile_packages.entities.robo_entity.states.AdjustRotationToTarget;
import de.theidler.create_mobile_packages.entities.robo_entity.states.LandingDescendFinishState;
import de.theidler.create_mobile_packages.entities.robo_entity.states.LaunchPrepareState;
import de.theidler.create_mobile_packages.index.CMPItems;
import de.theidler.create_mobile_packages.index.config.CMPConfigs;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class RoboEntity
extends Mob {
    private static final EntityDataAccessor<Float> ROT_YAW = SynchedEntityData.m_135353_(RoboEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(RoboEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Float> PACKAGE_HEIGHT_SCALE = SynchedEntityData.m_135353_(RoboEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private RoboEntityState state;
    private Vec3 targetVelocity = Vec3.f_82478_;
    private Player targetPlayer;
    private BeePortBlockEntity targetBlockEntity;
    private BeePortBlockEntity startBeePortBlockEntity;
    private String targetAddress = "";
    private int damageCounter = 0;
    private boolean isRequest = true;
    private String activeTargetAddress = "";

    public RoboEntity(EntityType<? extends Mob> type, Level level, ItemStack itemStack, BlockPos targetPos, BlockPos spawnPos) {
        super(type, level);
        BeePortBlockEntity dpbe;
        BlockEntity blockEntity;
        CreateMobilePackages.ROBO_MANAGER.addRobo(this);
        if (targetPos != null) {
            blockEntity = level.m_7702_(targetPos);
            BeePortBlockEntity beePortBlockEntity = this.targetBlockEntity = blockEntity instanceof BeePortBlockEntity ? (dpbe = (BeePortBlockEntity)blockEntity) : null;
            if (this.targetBlockEntity != null) {
                this.setState(new LaunchPrepareState());
            }
        }
        this.setItemStack(itemStack);
        this.setTargetFromItemStack(itemStack);
        this.m_146884_(spawnPos.m_252807_().m_82492_(0.0, 0.5, 0.0));
        if (this.targetBlockEntity != null) {
            this.targetBlockEntity.trySetEntityOnTravel(this);
        }
        if ((blockEntity = this.m_9236_().m_7702_(spawnPos)) instanceof BeePortBlockEntity) {
            this.startBeePortBlockEntity = dpbe = (BeePortBlockEntity)blockEntity;
        }
        if (!this.m_9236_().m_5776_()) {
            this.f_19804_.m_135381_(ROT_YAW, (Object)Float.valueOf(this.getSnapAngle(this.getAngleToTarget())));
        }
        if (this.targetBlockEntity != null && ((Object)((Object)this.targetBlockEntity)).equals((Object)this.startBeePortBlockEntity)) {
            this.setState(new LandingDescendFinishState());
            return;
        }
        if (this.startBeePortBlockEntity == null) {
            this.setState(new AdjustRotationToTarget());
            return;
        }
        this.setState(new LaunchPrepareState());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ROT_YAW, (Object)Float.valueOf(this.m_146908_()));
        this.f_19804_.m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(PACKAGE_HEIGHT_SCALE, (Object)Float.valueOf(0.0f));
    }

    private void setTargetFromItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        this.targetAddress = PackageItem.getAddress((ItemStack)itemStack);
        this.updateTarget();
    }

    private Player getTargetPlayerFromAddress() {
        return this.m_9236_().m_6907_().stream().filter(player -> BeePortBlockEntity.doesAddressStringMatchPlayerName(player, PackageItem.getAddress((ItemStack)this.getItemStack()))).findFirst().orElse(null);
    }

    private void updateTarget() {
        BeePortBlockEntity newTargetBlockEntity;
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.targetPlayer = this.getTargetPlayerFromAddress();
        if (this.targetPlayer != null) {
            return;
        }
        if (this.targetBlockEntity == null || !this.targetBlockEntity.canAcceptEntity(this, !this.getItemStack().m_41619_()) || !Objects.equals(this.activeTargetAddress, this.targetAddress)) {
            BeePortBlockEntity oldTarget = this.targetBlockEntity;
            this.activeTargetAddress = this.targetAddress;
            this.targetBlockEntity = RoboEntity.getClosestBeePort(this.m_9236_(), Objects.equals(this.targetAddress, "") ? null : this.targetAddress, this.m_20183_(), this);
            if (oldTarget != this.targetBlockEntity) {
                if (oldTarget != null) {
                    oldTarget.trySetEntityOnTravel(null);
                }
                if (this.targetBlockEntity != null) {
                    this.targetBlockEntity.trySetEntityOnTravel(this);
                }
            }
            if (this.targetBlockEntity == null && this.targetPlayer == null) {
                this.setTargetVelocity(Vec3.f_82478_);
            }
        }
        if (!this.isRequest && (newTargetBlockEntity = RoboEntity.getClosestBeePort(this.m_9236_(), Objects.equals(this.targetAddress, "") ? null : this.targetAddress, this.m_20183_(), this)) != null && newTargetBlockEntity != this.targetBlockEntity) {
            if (this.targetBlockEntity != null) {
                this.targetBlockEntity.trySetEntityOnTravel(null);
            }
            this.targetBlockEntity = newTargetBlockEntity;
            this.targetBlockEntity.trySetEntityOnTravel(this);
        }
    }

    public BlockPos getTargetPosition() {
        this.updateTarget();
        if (this.targetPlayer != null) {
            return RoboEntity.isWithinRange(this.targetPlayer.m_20183_(), this.m_20183_()) ? this.targetPlayer.m_20183_().m_7494_().m_7494_() : null;
        }
        if (this.targetBlockEntity != null) {
            return RoboEntity.isWithinRange(this.targetBlockEntity.m_58899_(), this.m_20183_()) ? this.targetBlockEntity.m_58899_().m_7494_().m_7494_() : null;
        }
        return null;
    }

    public static boolean isWithinRange(BlockPos targetPos, BlockPos originPos) {
        int maxDistance = (Integer)CMPConfigs.server().beeMaxDistance.get();
        if (targetPos == null || originPos == null) {
            return false;
        }
        if (maxDistance == -1) {
            return true;
        }
        return targetPos.m_123331_((Vec3i)originPos) <= (double)(maxDistance * maxDistance);
    }

    public static BeePortBlockEntity getClosestBeePort(Level level, String address, BlockPos origin, RoboEntity entity) {
        BeePortBlockEntity[] closest = new BeePortBlockEntity[]{null};
        level.getCapability(ModCapabilities.BEE_PORT_ENTITY_TRACKER_CAP).ifPresent(tracker -> {
            ArrayList<BeePortBlockEntity> allBEs = new ArrayList<BeePortBlockEntity>(tracker.getAll());
            allBEs.removeIf(dpbe -> !RoboEntity.isWithinRange(dpbe.m_58899_(), origin));
            if (address != null) {
                allBEs.removeIf(dpbe -> !PackageItem.matchAddress((String)address, (String)dpbe.addressFilter));
            }
            allBEs.removeIf(dpbe -> !dpbe.canAcceptEntity(entity, entity != null && !entity.getItemStack().m_41619_()));
            closest[0] = allBEs.stream().min(Comparator.comparingDouble(a -> a.m_58899_().m_123331_((Vec3i)origin))).orElse(null);
        });
        return closest[0];
    }

    public void m_8119_() {
    }

    public void roboMangerTick() {
        super.m_8119_();
        CreateMobilePackages.ROBO_MANAGER.markDirty();
        if (this.state != null) {
            this.state.tick(this);
        }
        this.m_20256_(this.targetVelocity);
        this.m_6478_(MoverType.SELF, this.targetVelocity);
        float rotYaw = ((Float)this.f_19804_.m_135370_(ROT_YAW)).floatValue();
        this.m_146922_(rotYaw);
        this.m_5616_(rotYaw);
        this.f_20883_ = rotYaw;
        this.updateNametag();
    }

    private void updateNametag() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!((Boolean)CMPConfigs.server().displayNametag.get()).booleanValue()) {
            this.m_6593_(null);
            this.m_20340_(false);
        } else if (this.targetAddress != null && !this.targetAddress.isBlank()) {
            this.m_6593_((Component)Component.m_237113_((String)("-> " + this.targetAddress)));
            this.m_20340_(true);
        } else if (this.targetBlockEntity != null) {
            BlockPos pos = this.targetBlockEntity.m_58899_();
            this.m_6593_((Component)Component.m_237113_((String)("-> [" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + "]")));
            this.m_20340_(true);
        } else {
            this.m_6593_(null);
            this.m_20340_(false);
        }
    }

    public void setState(RoboEntityState state) {
        if (state == null) {
            return;
        }
        this.state = state;
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ITEM_STACK);
    }

    public void setItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        this.f_19804_.m_135381_(DATA_ITEM_STACK, (Object)itemStack);
    }

    public Float getPackageHeightScale() {
        return (Float)this.f_19804_.m_135370_(PACKAGE_HEIGHT_SCALE);
    }

    public void setPackageHeightScale(float scale) {
        if (scale < 0.0f || scale > 1.0f) {
            return;
        }
        this.f_19804_.m_135381_(PACKAGE_HEIGHT_SCALE, (Object)Float.valueOf(scale));
    }

    public BeePortBlockEntity getStartBeePortBlockEntity() {
        return this.startBeePortBlockEntity;
    }

    public void setTargetVelocity(Vec3 targetVelocity) {
        if (targetVelocity == null) {
            return;
        }
        this.targetVelocity = targetVelocity;
    }

    public int getSnapAngle(double angle) {
        return (int)Math.abs(Math.round(angle / 90.0) * 90L - 45L);
    }

    public double getAngleToTarget() {
        BlockPos targetPos = this.getTargetPosition();
        return targetPos != null ? Math.atan2((double)targetPos.m_123343_() - this.m_20189_(), (double)targetPos.m_123341_() - this.m_20185_()) : 0.0;
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        this.handleItemStackOnRemove();
        if (this.getTargetBlockEntity() != null) {
            this.getTargetBlockEntity().trySetEntityOnTravel(null);
        }
        super.m_142687_(pReason);
    }

    private void handleItemStackOnRemove() {
        if (!this.getItemStack().m_41619_()) {
            this.m_9236_().m_7967_((Entity)PackageEntity.fromItemStack((Level)this.m_9236_(), (Vec3)this.m_20182_(), (ItemStack)this.getItemStack()));
            this.setItemStack(ItemStack.f_41583_);
            if (this.targetPlayer != null) {
                this.targetPlayer.m_5661_((Component)Component.m_237110_((String)"create_mobile_packages.robo_entity.death", (Object[])new Object[]{Math.round(this.m_20185_()), Math.round(this.m_20186_()), Math.round(this.m_20189_()), this.targetPlayer.m_7755_().getString()}), false);
            }
        }
    }

    public Player getTargetPlayer() {
        this.updateTarget();
        return this.targetPlayer;
    }

    public BeePortBlockEntity getTargetBlockEntity() {
        return this.targetBlockEntity;
    }

    public void updateDisplay(Player player) {
        if (player == null) {
            return;
        }
        player.m_5661_((Component)Component.m_237110_((String)"create_mobile_packages.robo_entity.eta", (Object[])new Object[]{RoboEntity.calcETA(player.m_20182_(), this.m_20182_())}), true);
    }

    public static int calcETA(Vec3 targetPosition, Vec3 currentPosition) {
        if (targetPosition == null || currentPosition == null) {
            return Integer.MAX_VALUE;
        }
        double distance = targetPosition.m_82554_(currentPosition);
        return (int)(distance / (double)((Integer)CMPConfigs.server().beeSpeed.get()).intValue()) + 1;
    }

    public void lookAtTarget() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        BlockPos targetPos = this.getTargetPosition();
        if (targetPos != null) {
            Vec3 direction = new Vec3((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_()).m_82546_(this.m_20182_()).m_82541_();
            this.f_19804_.m_135381_(ROT_YAW, (Object)Float.valueOf((float)Math.toDegrees(Math.atan2(direction.f_82481_, direction.f_82479_)) - 90.0f));
        }
    }

    public int rotateLookAtTarget() {
        return this.rotateToAngle((float)this.getAngleToTarget() + 90.0f);
    }

    public int rotateToSnap() {
        return this.rotateToAngle((float)this.getSnapAngle(this.getAngleToTarget()) + 90.0f);
    }

    private int rotateToAngle(float targetYaw) {
        if (this.m_9236_().m_5776_()) {
            return -1;
        }
        float currentYaw = ((Float)this.f_19804_.m_135370_(ROT_YAW)).floatValue();
        float deltaYaw = targetYaw - currentYaw;
        deltaYaw = deltaYaw > 180.0f ? deltaYaw - 360.0f : (deltaYaw < -180.0f ? deltaYaw + 360.0f : deltaYaw);
        float rotationSpeed = ((Integer)CMPConfigs.server().beeRotationSpeed.get()).intValue();
        currentYaw = Math.abs(deltaYaw) > rotationSpeed ? (currentYaw += deltaYaw > 0.0f ? rotationSpeed : -rotationSpeed) : targetYaw;
        this.f_19804_.m_135381_(ROT_YAW, (Object)Float.valueOf(currentYaw));
        return (int)Math.ceil(Math.abs(deltaYaw) / rotationSpeed);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (!this.getItemStack().m_41619_()) {
            nbt.m_128365_("itemStack", (Tag)this.getItemStack().m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("itemStack", 10)) {
            this.setItemStack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("itemStack")));
        } else {
            this.setItemStack(ItemStack.f_41583_);
        }
        this.setTargetFromItemStack(this.getItemStack());
    }

    public void m_20258_(CompoundTag pCompound) {
        super.m_20258_(pCompound);
        if (pCompound.m_128441_("itemStack")) {
            this.setItemStack(ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("itemStack")));
        }
        this.setTargetFromItemStack(this.getItemStack());
        if (!this.m_9236_().m_5776_() && !this.getItemStack().m_41619_()) {
            this.setPackageHeightScale(1.0f);
        }
    }

    public void setTargetAddress(String address) {
        this.targetAddress = address;
        this.updateTarget();
    }

    public void m_6074_() {
        this.m_9236_().m_7605_((Entity)this, (byte)60);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack drop = new ItemStack((ItemLike)CMPItems.ROBO_BEE.get());
            Containers.m_18992_((Level)serverLevel, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)drop);
        }
        this.m_146870_();
    }

    public void m_7822_(byte pId) {
        if (pId == 60) {
            for (int i = 0; i < 3; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        } else {
            super.m_7822_(pId);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            this.m_5834_();
            this.damageCounter += (int)(pAmount * 10.0f);
            if (this.damageCounter > 40) {
                this.handleItemStackOnRemove();
                this.m_146870_();
                this.m_6074_();
            }
        }
        return true;
    }

    public void setRequest(boolean request) {
        this.isRequest = request;
    }
}

