/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.portable_stock_ticker;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.WiFiEffectPacket;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.AdventureUtil;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.PortableStockTicker;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class SendPackage
extends SimplePacketBase {
    private final PackageOrderWithCrafts order;
    private final String address;
    private final boolean encodeRequester;

    public SendPackage(PackageOrderWithCrafts order, String address, boolean encodeRequester) {
        this.order = order;
        this.address = address;
        this.encodeRequester = encodeRequester;
    }

    public SendPackage(FriendlyByteBuf buffer) {
        this.address = buffer.m_130277_();
        int orderSize = buffer.m_130242_();
        ArrayList<BigItemStack> stacks = new ArrayList<BigItemStack>();
        for (int i = 0; i < orderSize; ++i) {
            stacks.add(new BigItemStack(buffer.m_130267_(), buffer.m_130242_()));
        }
        int craftingInfoSize = buffer.m_130242_();
        ArrayList<PackageOrderWithCrafts.CraftingEntry> craftingInformation = new ArrayList<PackageOrderWithCrafts.CraftingEntry>();
        for (int i = 0; i < craftingInfoSize; ++i) {
            craftingInformation.add(PackageOrderWithCrafts.CraftingEntry.read((FriendlyByteBuf)buffer));
        }
        this.order = new PackageOrderWithCrafts(new PackageOrder(stacks), craftingInformation);
        this.encodeRequester = buffer.readBoolean();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.address);
        buffer.m_130130_(this.order.orderedStacks().stacks().size());
        this.order.orderedStacks().stacks().forEach(stack -> {
            buffer.m_130055_(stack.stack);
            buffer.m_130130_(stack.count);
        });
        buffer.m_130130_(this.order.orderedCrafts().size());
        this.order.orderedCrafts().forEach(stack -> stack.write(buffer));
        buffer.writeBoolean(this.encodeRequester);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null || player.m_5833_() || AdventureUtil.isAdventure((Player)player)) {
                return;
            }
            Level world = player.m_9236_();
            if (!world.m_46749_(player.m_20183_())) {
                return;
            }
            this.applySettings(player);
        });
        return true;
    }

    protected void applySettings(ServerPlayer player) {
        ItemStack pstStack;
        PortableStockTicker pst;
        if (!this.order.isEmpty()) {
            AllSoundEvents.STOCK_TICKER_REQUEST.playOnServer(player.m_9236_(), (Vec3i)player.m_20183_());
            AllAdvancements.STOCK_TICKER.awardTo((Player)player);
            WiFiEffectPacket.send((Level)player.m_9236_(), (BlockPos)player.m_20183_());
        }
        PortableStockTicker portableStockTicker = pst = (pstStack = PortableStockTicker.find(player.m_150109_())) != null ? (PortableStockTicker)pstStack.m_41720_() : null;
        if (pst != null) {
            pst.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.PLAYER, this.order, null, this.address, (Player)player);
        }
    }
}

