/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.compat.jei;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import net.createmod.catnip.data.Pair;
import net.minecraft.world.inventory.Slot;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_logistics.compat.jei.TransferOperation;
import ru.zznty.create_factory_logistics.compat.jei.TransferOperationsResult;
import ru.zznty.create_factory_logistics.logistics.ingredient.BoardIngredient;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKey;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKeyProvider;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientRegistry;

public final class IngredientTransfer {
    public static Optional<BoardIngredient> tryConvert(IIngredientManager ingredientManager, ITypedIngredient<?> typedIngredient) {
        String typeUid = typedIngredient.getType().getUid();
        for (IngredientKeyProvider provider : IngredientRegistry.REGISTRY.get().getValues()) {
            if (!provider.ingredientTypeUid().equals(typeUid)) continue;
            IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper(typedIngredient.getType());
            return Optional.of(new BoardIngredient((IngredientKey<?>)provider.wrap(typedIngredient.getIngredient()), (int)ingredientHelper.getAmount(typedIngredient.getIngredient())));
        }
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    public static TransferOperationsResult getRecipeTransferOperations(final IIngredientManager ingredientManager, List<BoardIngredient> availableIngredients, List<IRecipeSlotView> requiredStacks, List<Slot> craftingSlots) {
        TransferOperationsResult transferOperations = TransferOperationsResult.create();
        IdentityHashMap<IRecipeSlotView, Map> relevantSlots = new IdentityHashMap<IRecipeSlotView, Map>();
        IdentityHashMap<IRecipeSlotView, Map> slotUidCache = new IdentityHashMap<IRecipeSlotView, Map>();
        List<IRecipeSlotView> nonEmptyRequiredStacks = requiredStacks.stream().filter(r -> !r.isEmpty()).toList();
        List<MutableObject> availableStacks = availableIngredients.stream().map(MutableObject::new).toList();
        for (int i = 0; i < availableStacks.size(); ++i) {
            MutableObject availableStack = availableStacks.get(i);
            String string = IngredientTransfer.getStackUid(ingredientManager, (BoardIngredient)availableStack.getValue(), UidContext.Ingredient);
            for (IRecipeSlotView iRecipeSlotView : nonEmptyRequiredStacks) {
                Map map = slotUidCache.computeIfAbsent(iRecipeSlotView, s -> s.getAllIngredients().map(typedIngredient -> {
                    IIngredientHelper ingredientHelper1 = ingredientManager.getIngredientHelper(typedIngredient.getType());
                    return Pair.of((Object)ingredientHelper1.getUniqueId(typedIngredient.getIngredient(), UidContext.Ingredient), (Object)typedIngredient);
                }).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond)));
                ITypedIngredient selectedIngredient = (ITypedIngredient)map.get(string);
                if (selectedIngredient == null) continue;
                relevantSlots.computeIfAbsent(iRecipeSlotView, it -> new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<MutableObject<BoardIngredient>>(){

                    public int hashCode(MutableObject<BoardIngredient> o) {
                        return ((BoardIngredient)o.getValue()).key().hashCode();
                    }

                    public boolean equals(MutableObject<BoardIngredient> a, MutableObject<BoardIngredient> b) {
                        if (a == null || b == null) {
                            return false;
                        }
                        return IngredientTransfer.getStackUid(ingredientManager, (BoardIngredient)a.getValue(), UidContext.Ingredient).equals(IngredientTransfer.getStackUid(ingredientManager, (BoardIngredient)b.getValue(), UidContext.Ingredient));
                    }
                })).computeIfAbsent(availableStack, it -> new ArrayList()).add(new PhantomSlotState(i, (MutableObject<BoardIngredient>)availableStack, selectedIngredient));
            }
        }
        Object2ObjectArrayMap bestMatches = new Object2ObjectArrayMap();
        for (Map.Entry entry : relevantSlots.entrySet()) {
            ArrayList<PhantomSlotStateList> countedAndSorted = new ArrayList<PhantomSlotStateList>();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                ((ArrayList)entry2.getValue()).sort((o1, o2) -> {
                    int compare = Integer.compare(((BoardIngredient)o1.stack.getValue()).amount(), ((BoardIngredient)o2.stack.getValue()).amount());
                    if (compare == 0) {
                        return Integer.compare(o1.slot, o2.slot);
                    }
                    return compare;
                });
                countedAndSorted.add(new PhantomSlotStateList((List)entry2.getValue()));
            }
            countedAndSorted.sort((o1, o2) -> {
                int compare = Long.compare(o2.totalAmount, o1.totalAmount);
                if (compare == 0) {
                    return Integer.compare(o1.stateList.stream().mapToInt(it -> it.slot).min().orElse(0), o2.stateList.stream().mapToInt(it -> it.slot).min().orElse(0));
                }
                return compare;
            });
            bestMatches.put((IRecipeSlotView)entry.getKey(), countedAndSorted);
        }
        for (int i = 0; i < requiredStacks.size(); ++i) {
            void var13_25;
            IRecipeSlotView iRecipeSlotView = requiredStacks.get(i);
            if (iRecipeSlotView.isEmpty()) continue;
            Slot craftingSlot = craftingSlots.get(i);
            Object var13_23 = null;
            List list = (List)bestMatches.get(iRecipeSlotView);
            if (list != null) {
                for (PhantomSlotStateList phantomSlotStateList : list) {
                    PhantomSlotState first = phantomSlotStateList.getFirstNonEmpty();
                    if (first == null) continue;
                    PhantomSlotState phantomSlotState = first;
                    break;
                }
            }
            if (var13_25 == null) {
                transferOperations.missingItems().add(iRecipeSlotView);
                continue;
            }
            var13_25.stack.setValue((Object)((BoardIngredient)var13_25.stack.getValue()).withAmount(((BoardIngredient)var13_25.stack.getValue()).amount() - 1));
            transferOperations.results().add(new TransferOperation(var13_25.slot, craftingSlot.f_40219_, var13_25.typedIngredient));
        }
        return transferOperations;
    }

    @NotNull
    private static String getStackUid(IIngredientManager ingredientManager, BoardIngredient availableStack, UidContext context) {
        IIngredientHelper ingredientHelper = ingredientManager.getIngredientHelper((IIngredientType)ingredientManager.getIngredientTypeForUid(availableStack.key().provider().ingredientTypeUid()).orElseThrow());
        return ingredientHelper.getUniqueId(availableStack.key().get(), context);
    }

    private record PhantomSlotState(int slot, MutableObject<BoardIngredient> stack, ITypedIngredient<?> typedIngredient) {
    }

    private record PhantomSlotStateList(List<PhantomSlotState> stateList, long totalAmount) {
        public PhantomSlotStateList(List<PhantomSlotState> states) {
            this(states, states.stream().mapToLong(it -> ((BoardIngredient)it.stack.getValue()).amount()).sum());
        }

        @Nullable
        public PhantomSlotState getFirstNonEmpty() {
            for (PhantomSlotState state : this.stateList) {
                if (((BoardIngredient)state.stack.getValue()).isEmpty()) continue;
                return state;
            }
            return null;
        }
    }
}

