/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.ingredient;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientFilterProvider;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKey;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKeyProvider;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientProviders;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientRegistry;

public record BoardIngredient(IngredientKey<?> key, int amount) {
    public boolean isEmpty() {
        return this.amount == 0 || this.key.provider() == IngredientProviders.EMPTY.get();
    }

    public BoardIngredient withAmount(int amount) {
        return new BoardIngredient(this.key, amount);
    }

    public boolean canStack(BoardIngredient ingredient) {
        return this.key.equals(ingredient.key);
    }

    public boolean canStack(IngredientKey<?> otherKey) {
        return this.key.equals(otherKey);
    }

    public static BoardIngredient read(FriendlyByteBuf buf) {
        IngredientKeyProvider provider = (IngredientKeyProvider)buf.readRegistryIdSafe(IngredientKeyProvider.class);
        return new BoardIngredient((IngredientKey<?>)provider.serializer().read(buf), buf.m_130242_());
    }

    public static BoardIngredient read(CompoundTag tag) {
        int amount = tag.m_128451_("Amount");
        IngredientKeyProvider provider = (IngredientKeyProvider)IngredientRegistry.REGISTRY.get().getValue(ResourceLocation.parse((String)tag.m_128461_("id")));
        return provider == null ? BoardIngredient.of() : new BoardIngredient((IngredientKey<?>)provider.serializer().read(tag.m_128469_("key")), amount);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeRegistryId(IngredientRegistry.REGISTRY.get(), (Object)this.key.provider());
        this.key.provider().serializer().write(this.key, buf);
        buf.m_130130_(this.amount);
    }

    public void write(CompoundTag tag) {
        tag.m_128405_("Amount", this.amount);
        ResourceLocation resourceLocation = IngredientRegistry.REGISTRY.get().getKey((Object)this.key.provider());
        if (resourceLocation == null) {
            resourceLocation = Objects.requireNonNull(IngredientRegistry.REGISTRY.get().getDefaultKey());
        }
        tag.m_128359_("id", resourceLocation.toString());
        CompoundTag keyTag = new CompoundTag();
        this.key.provider().serializer().write(this.key, keyTag);
        tag.m_128365_("key", (Tag)keyTag);
    }

    public static BoardIngredient of() {
        return new BoardIngredient(IngredientKey.EMPTY, 0);
    }

    public static BoardIngredient of(FactoryPanelBehaviour behaviour) {
        IngredientFilterProvider filterProvider = (IngredientFilterProvider)behaviour;
        return filterProvider.ingredient();
    }
}

