/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.ingredient;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import ru.zznty.create_factory_logistics.logistics.ingredient.BoardIngredient;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientGuiHandler;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKey;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKeyProvider;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientProviders;
import ru.zznty.create_factory_logistics.logistics.ingredient.impl.EmptyGuiHandler;
import ru.zznty.create_factory_logistics.logistics.ingredient.impl.fluid.FluidGuiHandler;
import ru.zznty.create_factory_logistics.logistics.ingredient.impl.item.ItemGuiHandler;

public final class IngredientGui {
    public static final Map<IngredientKeyProvider, IngredientGuiHandler> HANDLERS = new IdentityHashMap<IngredientKeyProvider, IngredientGuiHandler>();

    public static void renderDecorations(GuiGraphics graphics, BoardIngredient ingredient, int x, int y) {
        IngredientGui.getUnchecked(ingredient.key()).renderDecorations(graphics, ingredient.key(), ingredient.amount(), x, y);
    }

    public static LangBuilder nameBuilder(BoardIngredient ingredient) {
        return IngredientGui.getUnchecked(ingredient.key()).nameBuilder(ingredient.key(), ingredient.amount());
    }

    public static List<Component> tooltipBuilder(IngredientKey key, int amount) {
        return IngredientGui.getUnchecked(key).tooltipBuilder(key, amount);
    }

    public static LangBuilder nameBuilder(IngredientKey key) {
        return IngredientGui.getUnchecked(key).nameBuilder(key);
    }

    public static int stackSize(IngredientKey key) {
        return IngredientGui.getUnchecked(key).stackSize(key);
    }

    public static int maxStackSize(IngredientKey key) {
        return IngredientGui.getUnchecked(key).maxStackSize(key);
    }

    public static void renderSlot(GuiGraphics graphics, IngredientKey key, int x, int y) {
        IngredientGui.getUnchecked(key).renderSlot(graphics, key, x, y);
    }

    private static IngredientGuiHandler getUnchecked(IngredientKey key) {
        return HANDLERS.get(key.provider());
    }

    static {
        HANDLERS.put((IngredientKeyProvider)IngredientProviders.EMPTY.get(), new EmptyGuiHandler());
        HANDLERS.put((IngredientKeyProvider)IngredientProviders.ITEM.get(), new ItemGuiHandler());
        HANDLERS.put((IngredientKeyProvider)IngredientProviders.FLUID.get(), new FluidGuiHandler());
    }
}

