/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.ingredient;

import java.util.Comparator;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKeyProvider;
import ru.zznty.create_factory_logistics.logistics.ingredient.impl.EmptyIngredientKey;
import ru.zznty.create_factory_logistics.logistics.ingredient.impl.fluid.FluidIngredientKey;
import ru.zznty.create_factory_logistics.logistics.ingredient.impl.item.ItemIngredientKey;

public interface IngredientKey<T> {
    public static final IngredientKey<?> EMPTY = new EmptyIngredientKey();
    public static final Comparator<IngredientKey<?>> COMPARATOR = (a, b) -> {
        if (a.equals(b)) {
            return 0;
        }
        if (a.equals(EMPTY)) {
            return -1;
        }
        if (b.equals(EMPTY)) {
            return 1;
        }
        if (a.provider().equals(b.provider())) {
            return a.provider().compare(a, b);
        }
        return 0;
    };

    public IngredientKeyProvider provider();

    public T get();

    public IngredientKey<?> genericCopy();

    public static IngredientKey<?> of() {
        return EMPTY;
    }

    public static IngredientKey<?> of(ItemStack item) {
        if (item.m_41720_() == Items.f_41852_) {
            return EMPTY;
        }
        return new ItemIngredientKey(item.m_255036_(1));
    }

    public static IngredientKey<?> of(FluidStack fluid) {
        if (fluid.getRawFluid() == Fluids.f_76191_) {
            return EMPTY;
        }
        return new FluidIngredientKey(fluid.getFluid(), fluid.hasTag() ? fluid.getTag().m_6426_() : null);
    }
}

