/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.ingredient.impl.fluid;

import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientGuiHandler;
import ru.zznty.create_factory_logistics.logistics.ingredient.impl.fluid.FluidIngredientKey;
import ru.zznty.create_factory_logistics.logistics.panel.FactoryFluidPanelBehaviour;
import ru.zznty.create_factory_logistics.render.FluidSlotRenderer;
import ru.zznty.create_factory_logistics.render.SlotAmountRenderer;

public class FluidGuiHandler
implements IngredientGuiHandler<FluidIngredientKey> {
    @Override
    public void renderDecorations(GuiGraphics graphics, FluidIngredientKey key, int amount, int x, int y) {
        SlotAmountRenderer.render(graphics, x, y, FluidGuiHandler.formatValue(amount));
    }

    @Override
    public void renderSlot(GuiGraphics graphics, FluidIngredientKey key, int x, int y) {
        FluidSlotRenderer.renderFluidSlot(graphics, x, y, key.stack());
    }

    @Override
    public LangBuilder nameBuilder(FluidIngredientKey key, int amount) {
        return CreateLang.fluidName((FluidStack)key.stack()).space().add(FactoryFluidPanelBehaviour.formatLevel(amount));
    }

    @Override
    public List<Component> tooltipBuilder(FluidIngredientKey key, int amount) {
        ArrayList<Component> list = new ArrayList<Component>(3);
        list.add(key.stack().getDisplayName());
        list.add((Component)Component.m_237119_());
        list.add((Component)FactoryFluidPanelBehaviour.formatLevel(amount, false).style(ChatFormatting.GRAY).component());
        return list;
    }

    @Override
    public LangBuilder nameBuilder(FluidIngredientKey key) {
        return CreateLang.fluidName((FluidStack)key.stack());
    }

    @Override
    public int stackSize(FluidIngredientKey key) {
        return 1000;
    }

    @Override
    public int maxStackSize(FluidIngredientKey key) {
        return -1;
    }

    public static String formatValue(int count) {
        return FactoryFluidPanelBehaviour.formatLevelShort(count).string();
    }
}

