/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.ingredient.impl.fluid;

import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import ru.zznty.create_factory_logistics.logistics.ingredient.CapabilityFactory;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKey;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKeyProvider;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKeySerializer;
import ru.zznty.create_factory_logistics.logistics.ingredient.impl.fluid.FluidIngredientKey;
import ru.zznty.create_factory_logistics.logistics.ingredient.impl.fluid.FluidKeySerializer;
import ru.zznty.create_factory_logistics.logistics.networkLink.NetworkFluidHandler;

@ApiStatus.Internal
public class FluidIngredientProvider
implements IngredientKeyProvider {
    private final FluidKeySerializer serializer = new FluidKeySerializer();
    private final CapabilityFactory<IFluidHandler> capFactory = (cap, mode, behaviour) -> ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of(() -> new NetworkFluidHandler(behaviour.freqId, mode)));

    @Override
    public <K extends IngredientKey> K defaultKey() {
        return (K)new FluidIngredientKey(Fluids.f_76191_, null);
    }

    @Override
    public <T, K extends IngredientKey<T>> K wrap(T value) {
        return (K)IngredientKey.of((FluidStack)value);
    }

    @Override
    public <K extends IngredientKey> IngredientKeySerializer<K> serializer() {
        return this.serializer;
    }

    @Override
    public <K extends IngredientKey> int compare(K a, K b) {
        FluidIngredientKey key1 = (FluidIngredientKey)a;
        FluidIngredientKey key2 = (FluidIngredientKey)b;
        return ForgeRegistries.FLUIDS.getKey((Object)key1.fluid()).compareTo(ForgeRegistries.FLUIDS.getKey((Object)key2.fluid()));
    }

    @Override
    public <T> CapabilityFactory<T> capabilityFactory() {
        return this.capFactory;
    }

    @Override
    public String ingredientTypeUid() {
        return "fluid_stack";
    }
}

