/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.jar;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.joml.Quaternionfc;
import ru.zznty.create_factory_logistics.Config;
import ru.zznty.create_factory_logistics.logistics.jar.JarPackageRenderer;

public class JarItemRenderer
extends CustomRenderedItemModelRenderer {
    public void render(ItemStack box, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext displayContext, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        renderer.render(model.getOriginalModel(), light);
        if (!JarPackageRenderer.entityRendering) {
            JarItemRenderer.renderFluidContents(box, -1.0f, ms, buffer, light);
        }
    }

    public static void renderFluidContents(ItemStack box, float fluidLevel, PoseStack ms, MultiBufferSource buffer, int light) {
        Optional containedFluid = FluidUtil.getFluidContained((ItemStack)box);
        if (containedFluid.isEmpty() || ((FluidStack)containedFluid.get()).isEmpty()) {
            return;
        }
        if (fluidLevel < 0.0f) {
            fluidLevel = ((FluidStack)containedFluid.get()).getAmount();
        }
        float capHeight = 0.0625f;
        float tankHullWidth = 0.0078125f;
        float minPuddleHeight = -0.03125f;
        float totalHeight = 8.0f * capHeight - minPuddleHeight;
        float tankWidth = 0.5f;
        float level = fluidLevel / (float)Config.jarCapacity * totalHeight;
        if (level == 0.0f) {
            return;
        }
        boolean top = ((FluidStack)containedFluid.get()).getFluid().getFluidType().isLighterThanAir();
        float xMin = 0.0f;
        float xMax = xMin + tankWidth - 2.0f * tankHullWidth;
        float yMin = capHeight + minPuddleHeight - level;
        float yMax = yMin + level;
        if (top) {
            yMin += totalHeight - level;
            yMax += totalHeight - level;
        }
        float zMin = 0.0f;
        float zMax = zMin + tankWidth - 2.0f * tankHullWidth;
        ms.m_85836_();
        TransformStack.of((PoseStack)ms).rotate((Quaternionfc)Direction.UP.m_253075_());
        ms.m_252880_(-xMax / 2.0f, level - totalHeight, -zMax / 2.0f);
        FluidRenderer.renderFluidBox((Fluid)((FluidStack)containedFluid.get()).getFluid(), (long)((FluidStack)containedFluid.get()).getAmount(), (float)xMin, (float)yMin, (float)zMin, (float)xMax, (float)yMax, (float)zMax, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)false, (boolean)true, (CompoundTag)((FluidStack)containedFluid.get()).getTag());
        ms.m_85849_();
    }
}

