/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.jar;

import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_logistics.Config;
import ru.zznty.create_factory_logistics.FactoryEntities;
import ru.zznty.create_factory_logistics.logistics.jar.JarItemRenderer;
import ru.zznty.create_factory_logistics.logistics.jar.JarPackageEntity;
import ru.zznty.create_factory_logistics.logistics.jar.JarStyles;
import ru.zznty.create_factory_logistics.logistics.panel.FactoryFluidPanelBehaviour;

public class JarPackageItem
extends PackageItem {
    public JarPackageItem(Item.Properties properties, PackageStyles.PackageStyle style) {
        super(properties, style);
        PackageStyles.ALL_BOXES.remove((Object)this);
        (style.rare() ? PackageStyles.RARE_BOXES : PackageStyles.STANDARD_BOXES).remove((Object)this);
        JarStyles.ALL_JARS.add(this);
    }

    public String m_5524_() {
        return "item.create_factory_logistics" + (this.style.rare() ? ".rare_jar" : ".jar");
    }

    public Entity createEntity(Level world, Entity location, ItemStack itemstack) {
        return JarPackageEntity.fromDroppedItem(world, location, itemstack);
    }

    public InteractionResultHolder<ItemStack> open(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack box = playerIn.m_21120_(handIn);
        BlockHitResult hitResult = JarPackageItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)box);
        }
        BlockPos relative = hitResult.m_82425_().m_121945_(hitResult.m_82434_());
        return box.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(fluidItem -> {
            BlockPos placePos;
            FluidStack fluid = fluidItem.drain(Config.jarCapacity, IFluidHandler.FluidAction.SIMULATE);
            if (!(fluid.getAmount() == Config.jarCapacity && fluid.getFluid() instanceof FlowingFluid && worldIn.m_7966_(playerIn, relative) && playerIn.m_36204_(relative, hitResult.m_82434_(), box))) {
                return InteractionResultHolder.m_19100_((Object)box);
            }
            BlockState blockState = worldIn.m_8055_(hitResult.m_82425_());
            BlockPos blockPos = placePos = this.canBlockContainFluid(worldIn, hitResult.m_82425_(), blockState, fluid) ? hitResult.m_82425_() : relative;
            if (this.emptyContents(playerIn, worldIn, handIn, placePos, box)) {
                playerIn.m_21008_(handIn, ItemStack.f_41583_);
                return InteractionResultHolder.m_19092_((Object)ItemStack.f_41583_, (boolean)worldIn.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)box);
        }).orElse(InteractionResultHolder.m_19098_((Object)box));
    }

    protected boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockState, FluidStack fluid) {
        LiquidBlockContainer liquidBlockContainer;
        Block block = blockState.m_60734_();
        return block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).m_6044_((BlockGetter)worldIn, posIn, blockState, fluid.getFluid());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_().m_6144_()) {
            return this.open(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
        }
        Vec3 point = context.m_43720_();
        float h = (float)this.style.height() / 16.0f;
        float r = (float)this.style.width() / 2.0f / 16.0f;
        if (context.m_43719_() == Direction.DOWN) {
            point = point.m_82492_(0.0, (double)(h + 0.25f), 0.0);
        } else if (context.m_43719_().m_122434_().m_122479_()) {
            point = point.m_82549_(Vec3.m_82528_((Vec3i)context.m_43719_().m_122436_()).m_82490_((double)r));
        }
        AABB scanBB = new AABB(point, point).m_82377_((double)r, 0.0, (double)r).m_82363_(0.0, (double)h, 0.0);
        Level world = context.m_43725_();
        if (!world.m_142425_((EntityTypeTest)FactoryEntities.JAR.get(), scanBB, e -> true).isEmpty()) {
            return InteractionResult.PASS;
        }
        JarPackageEntity jarEntity = new JarPackageEntity(world, point.f_82479_, point.f_82480_, point.f_82481_);
        ItemStack itemInHand = context.m_43722_();
        jarEntity.setBox(itemInHand.m_41777_());
        world.m_7967_((Entity)jarEntity);
        itemInHand.m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int ticks) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int i = this.m_8105_(stack) - ticks;
        if (i < 0) {
            return;
        }
        float f = JarPackageItem.getPackageVelocity((int)i);
        if ((double)f < 0.1) {
            return;
        }
        if (world.f_46443_) {
            return;
        }
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.5f);
        ItemStack copy = stack.m_41777_();
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        Vec3 vec = new Vec3(entity.m_20185_(), entity.m_20186_() + entity.m_20191_().m_82376_() / 2.0, entity.m_20189_());
        Vec3 motion = entity.m_20154_().m_82490_((double)(f * 2.0f));
        vec = vec.m_82549_(motion);
        JarPackageEntity jarEntity = new JarPackageEntity(world, vec.f_82479_, vec.f_82480_, vec.f_82481_);
        jarEntity.setBox(copy);
        jarEntity.m_20256_(motion);
        jarEntity.tossedBy = new WeakReference<Player>(player);
        world.m_7967_((Entity)jarEntity);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidHandlerItemStack(stack, Config.jarCapacity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new JarItemRenderer()));
        super.initializeClient(consumer);
    }

    public static ItemStack slurp(Level world, BlockPos pos, IFluidHandler tank, FluidStack extractedFluid, int amount) {
        ItemStack jar;
        FluidActionResult result;
        if (amount < 1) {
            amount = Config.jarCapacity;
        }
        if (!(result = FluidUtil.tryFillContainer((ItemStack)(jar = new ItemStack((ItemLike)JarStyles.getRandomJar())), (IFluidHandler)tank, (int)amount, null, (boolean)true)).isSuccess()) {
            return ItemStack.f_41583_;
        }
        world.m_5594_(null, pos, FluidHelper.getFillSound((FluidStack)extractedFluid), SoundSource.BLOCKS, 0.5f, 1.0f);
        return result.getResult();
    }

    public static ItemStack getDefaultJar() {
        return JarStyles.ALL_JARS.get(0).m_7968_();
    }

    public boolean emptyContents(@Nullable Player player, Level level, InteractionHand hand, BlockPos pos, ItemStack container) {
        FluidStack resource = FluidUtil.getFluidContained((ItemStack)container).orElse(FluidStack.EMPTY);
        if (resource.getAmount() < 1000) {
            return false;
        }
        return FluidUtil.tryPlaceFluid((Player)player, (Level)level, (InteractionHand)hand, (BlockPos)pos, (ItemStack)container, (FluidStack)resource).isSuccess();
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        FluidStack contained = FluidUtil.getFluidContained((ItemStack)pStack).orElse(FluidStack.EMPTY);
        if (contained.isEmpty()) {
            return;
        }
        pTooltipComponents.add((Component)contained.getDisplayName().m_6881_().m_130946_(" ").m_7220_((Component)FactoryFluidPanelBehaviour.formatLevel(contained.getAmount()).component()).m_130940_(ChatFormatting.GRAY));
    }
}

