/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.jarPackager;

import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import ru.zznty.create_factory_logistics.Config;
import ru.zznty.create_factory_logistics.logistics.ingredient.BoardIngredient;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKey;
import ru.zznty.create_factory_logistics.logistics.ingredient.capability.PackageBuilder;
import ru.zznty.create_factory_logistics.logistics.ingredient.capability.PackageMeasureResult;
import ru.zznty.create_factory_logistics.logistics.ingredient.impl.fluid.FluidIngredientKey;
import ru.zznty.create_factory_logistics.logistics.jar.JarStyles;

class JarPackageBuilder
implements PackageBuilder {
    private FluidStack fluidStack = FluidStack.EMPTY;

    JarPackageBuilder() {
    }

    @Override
    public int add(BoardIngredient content) {
        IngredientKey<?> ingredientKey = content.key();
        if (!(ingredientKey instanceof FluidIngredientKey)) {
            throw new IllegalArgumentException("Unsupported content: " + String.valueOf(content));
        }
        FluidIngredientKey fluidKey = (FluidIngredientKey)ingredientKey;
        if (!this.fluidStack.isEmpty() && !this.fluidStack.isFluidEqual(fluidKey.stack())) {
            return -1;
        }
        if (this.fluidStack.isEmpty()) {
            this.fluidStack = fluidKey.stack().copy();
            this.fluidStack.setAmount(0);
        }
        int remainingAmount = content.amount();
        int amountToAdd = Math.min(Config.jarCapacity - this.fluidStack.getAmount(), remainingAmount);
        this.fluidStack.grow(amountToAdd);
        return remainingAmount - amountToAdd;
    }

    @Override
    public List<BoardIngredient> content() {
        return List.of(new BoardIngredient(IngredientKey.of(this.fluidStack), this.fluidStack.getAmount()));
    }

    @Override
    public boolean isFull() {
        return this.fluidStack.getAmount() >= Config.jarCapacity;
    }

    @Override
    public int maxPerSlot() {
        return Config.jarCapacity;
    }

    @Override
    public int slotCount() {
        return 1;
    }

    @Override
    public PackageMeasureResult measure(IngredientKey key) {
        if (key instanceof FluidIngredientKey) {
            FluidIngredientKey fluidKey = (FluidIngredientKey)key;
            return PackageMeasureResult.BULKY;
        }
        throw new IllegalArgumentException("Unsupported key: " + String.valueOf(key));
    }

    @Override
    public ItemStack build() {
        if (this.fluidStack.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack jar = new ItemStack((ItemLike)JarStyles.getRandomJar());
        FluidUtil.getFluidHandler((ItemStack)jar).ifPresent(handler -> handler.fill(this.fluidStack, IFluidHandler.FluidAction.EXECUTE));
        return jar;
    }
}

