/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.jarPackager;

import com.simibubi.create.api.packager.InventoryIdentifier;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.foundation.fluid.FluidHelper;
import java.util.Optional;
import net.createmod.catnip.math.BlockFace;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_logistics.FactoryBlocks;
import ru.zznty.create_factory_logistics.logistics.ingredient.BoardIngredient;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKey;
import ru.zznty.create_factory_logistics.logistics.ingredient.capability.PackageBuilder;
import ru.zznty.create_factory_logistics.logistics.ingredient.capability.PackagerAttachedHandler;
import ru.zznty.create_factory_logistics.logistics.jar.JarPackageItem;
import ru.zznty.create_factory_logistics.logistics.jarPackager.JarPackageBuilder;
import ru.zznty.create_factory_logistics.logistics.jarPackager.JarPackagerBlockEntity;
import ru.zznty.create_factory_logistics.logistics.panel.request.IngredientIdentifiedInventory;
import ru.zznty.create_factory_logistics.logistics.stock.IngredientInventorySummary;

@ApiStatus.Internal
public class JarPackagerAttachedHandler
implements PackagerAttachedHandler {
    private final JarPackagerBlockEntity packagerBE;

    public JarPackagerAttachedHandler(JarPackagerBlockEntity packagerBE) {
        this.packagerBE = packagerBE;
    }

    @Override
    public int slotCount() {
        return this.packagerBE.drainInventory.hasInventory() ? ((IFluidHandler)this.packagerBE.drainInventory.getInventory()).getTanks() : 0;
    }

    @Override
    public BoardIngredient extract(int slot, int amount, boolean simulate) {
        if (!this.packagerBE.drainInventory.hasInventory()) {
            return BoardIngredient.of();
        }
        FluidStack existing = ((IFluidHandler)this.packagerBE.drainInventory.getInventory()).getFluidInTank(slot);
        if (existing.isEmpty()) {
            return BoardIngredient.of();
        }
        FluidStack extracted = ((IFluidHandler)this.packagerBE.drainInventory.getInventory()).drain(FluidHelper.copyStackWithAmount((FluidStack)existing, (int)amount), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        return extracted.isEmpty() ? BoardIngredient.of() : new BoardIngredient(IngredientKey.of(extracted), extracted.getAmount());
    }

    @Override
    public boolean unwrap(Level level, BlockPos pos, BlockState state, Direction side, @Nullable PackageOrderWithCrafts orderContext, ItemStack box, boolean simulate) {
        if (!(box.m_41720_() instanceof JarPackageItem)) {
            return false;
        }
        Optional source = FluidUtil.getFluidContained((ItemStack)box);
        Optional destination = FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, (Direction)side).resolve();
        if (source.isEmpty() || destination.isEmpty()) {
            return false;
        }
        if (((IFluidHandler)destination.get()).fill((FluidStack)source.get(), IFluidHandler.FluidAction.SIMULATE) != ((FluidStack)source.get()).getAmount()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        return ((IFluidHandler)destination.get()).fill((FluidStack)source.get(), IFluidHandler.FluidAction.EXECUTE) == ((FluidStack)source.get()).getAmount();
    }

    @Override
    public PackageBuilder newPackage() {
        return new JarPackageBuilder();
    }

    @Override
    public boolean hasChanges() {
        return true;
    }

    @Override
    public void collectAvailable(boolean scanInputSlots, IngredientInventorySummary summary) {
        if (!this.packagerBE.drainInventory.hasInventory()) {
            this.packagerBE.drainInventory.findNewCapability();
            if (!this.packagerBE.drainInventory.hasInventory()) {
                return;
            }
        }
        IFluidHandler fluidHandler = (IFluidHandler)this.packagerBE.drainInventory.getInventory();
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            FluidStack stack = fluidHandler.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            if (!scanInputSlots) {
                stack = fluidHandler.drain(stack, IFluidHandler.FluidAction.SIMULATE);
            }
            if (fluidHandler instanceof CreativeFluidTankBlockEntity.CreativeSmartFluidTank) {
                stack.setAmount(1000000000);
            }
            summary.add(new BoardIngredient(IngredientKey.of(stack), stack.getAmount()));
        }
    }

    @Override
    public Block supportedGauge() {
        return (Block)FactoryBlocks.FACTORY_FLUID_GAUGE.get();
    }

    @Override
    @Nullable
    public IdentifiedInventory identifiedInventory() {
        IdentifiedInventory inv = new IdentifiedInventory(InventoryIdentifier.get((Level)this.packagerBE.drainInventory.getWorld(), (BlockFace)this.packagerBE.drainInventory.getTarget().getOpposite()), null);
        IngredientIdentifiedInventory identifiedInventory = IngredientIdentifiedInventory.from(inv);
        identifiedInventory.setCapability(ForgeCapabilities.FLUID_HANDLER, (IFluidHandler)this.packagerBE.drainInventory.getInventory());
        return inv;
    }
}

