/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.networkLink;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packagerLink.LogisticsManager;
import com.simibubi.create.content.logistics.packagerLink.RequestPromise;
import com.simibubi.create.content.logistics.packagerLink.RequestPromiseQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import ru.zznty.create_factory_logistics.logistics.ingredient.BigIngredientStack;
import ru.zznty.create_factory_logistics.logistics.ingredient.BoardIngredient;
import ru.zznty.create_factory_logistics.logistics.networkLink.NetworkLinkMode;
import ru.zznty.create_factory_logistics.logistics.stock.IngredientInventorySummary;

abstract class BaseNetworkHandler {
    protected final UUID network;
    private final NetworkLinkMode mode;
    private List<BoardIngredient> cachedIngredients = null;

    BaseNetworkHandler(UUID network, NetworkLinkMode mode) {
        this.network = network;
        this.mode = mode;
    }

    protected List<BoardIngredient> summary() {
        if (this.cachedIngredients == null) {
            RequestPromiseQueue queue;
            if (this.mode.includesStored()) {
                IngredientInventorySummary summary = (IngredientInventorySummary)LogisticsManager.getSummaryOfNetwork((UUID)this.network, (boolean)true);
                this.cachedIngredients = summary.get();
            } else {
                this.cachedIngredients = new ArrayList<BoardIngredient>();
            }
            if (this.mode.includesPromised() && (queue = Create.LOGISTICS.getQueuedPromises(this.network)) != null) {
                for (RequestPromise promise : queue.flatten(false)) {
                    BigIngredientStack stack = (BigIngredientStack)promise.promisedStack;
                    if (stack.ingredient().isEmpty()) continue;
                    this.cachedIngredients.add(stack.ingredient());
                }
            }
        }
        return this.cachedIngredients;
    }
}

