/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.networkLink;

import com.simibubi.create.foundation.fluid.FluidHelper;
import java.util.UUID;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import ru.zznty.create_factory_logistics.logistics.ingredient.BoardIngredient;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientCasts;
import ru.zznty.create_factory_logistics.logistics.networkLink.BaseNetworkHandler;
import ru.zznty.create_factory_logistics.logistics.networkLink.NetworkLinkMode;

public class NetworkFluidHandler
extends BaseNetworkHandler
implements IFluidHandler {
    public NetworkFluidHandler(UUID network, NetworkLinkMode mode) {
        super(network, mode);
    }

    public int getTanks() {
        return this.summary().size();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return IngredientCasts.asFluidStack(this.summary().get(tank));
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE - 1 / this.getTanks();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return IngredientCasts.asFluidStack(this.summary().get(tank)).isFluidEqual(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (action != IFluidHandler.FluidAction.SIMULATE || resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int amount = 0;
        for (BoardIngredient ingredient : this.summary()) {
            FluidStack stack = IngredientCasts.asFluidStack(ingredient);
            if (stack.isFluidEqual(resource)) {
                amount += Math.min(stack.getAmount(), resource.getAmount() - amount);
            }
            if (amount < resource.getAmount()) continue;
            break;
        }
        return FluidHelper.copyStackWithAmount((FluidStack)resource, (int)amount);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack resource = FluidStack.EMPTY;
        for (BoardIngredient ingredient : this.summary()) {
            FluidStack stack = IngredientCasts.asFluidStack(ingredient);
            if (stack.isEmpty()) continue;
            resource = stack;
            break;
        }
        return this.drain(FluidHelper.copyStackWithAmount((FluidStack)resource, (int)maxDrain), action);
    }
}

