/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.networkLink;

import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class NetworkLinkBlockItem
extends LogisticallyLinkedBlockItem {
    public NetworkLinkBlockItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public boolean m_5812_(ItemStack pStack) {
        return NetworkLinkBlockItem.isTuned(pStack);
    }

    public static boolean isTuned(ItemStack pStack) {
        if (!pStack.m_41782_()) {
            return false;
        }
        CompoundTag tag = pStack.m_41737_("BlockEntityTag");
        return tag != null && tag.m_128441_("Freq");
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        CompoundTag tag = pStack.m_41737_("BlockEntityTag");
        if (tag == null || !tag.m_128425_("ingredient_type", 8)) {
            return;
        }
        ResourceLocation ingredientType = ResourceLocation.parse((String)tag.m_128461_("ingredient_type"));
        if (ingredientType.m_135815_().equals("empty_ingredient_key")) {
            return;
        }
        CreateLang.builder((String)ingredientType.m_135827_()).add(CreateLang.builder((String)"create_factory_logistics").translate("gui.ingredient_type_qualified_item", new Object[0])).space().translate("gui.ingredient_type." + ingredientType.m_135815_(), new Object[0]).style(ChatFormatting.ITALIC).addTo(pTooltip);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43722_();
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        Player player = pContext.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.m_6144_()) {
            return super.m_6225_(pContext);
        }
        LogisticallyLinkedBehaviour link = (LogisticallyLinkedBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, (BehaviourType)LogisticallyLinkedBehaviour.TYPE);
        boolean tuned = NetworkLinkBlockItem.isTuned(stack);
        if (link != null) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!link.mayInteractMessage(player)) {
                return InteractionResult.SUCCESS;
            }
            NetworkLinkBlockItem.assignFrequency(stack, player, link.freqId);
            return InteractionResult.SUCCESS;
        }
        InteractionResult useOn = super.m_6225_(pContext);
        if (level.f_46443_ || useOn == InteractionResult.FAIL) {
            return useOn;
        }
        player.m_5661_((Component)(tuned ? CreateLang.translateDirect((String)"logistically_linked.connected", (Object[])new Object[0]) : CreateLang.translateDirect((String)"logistically_linked.new_network_started", (Object[])new Object[0])), true);
        return useOn;
    }

    public static void assignFrequency(ItemStack stack, Player player, UUID frequency) {
        CompoundTag teTag = stack.m_41698_("BlockEntityTag");
        teTag.m_128362_("Freq", frequency);
        player.m_5661_((Component)CreateLang.translateDirect((String)"logistically_linked.tuned", (Object[])new Object[0]), true);
    }
}

