/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.networkLink;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_logistics.CreateFactoryLogistics;
import ru.zznty.create_factory_logistics.FactoryBlocks;
import ru.zznty.create_factory_logistics.FactoryRecipes;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientProviders;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientRegistry;

public class NetworkLinkQualificationRecipe
extends CustomRecipe {
    private final ResourceLocation key;

    public NetworkLinkQualificationRecipe(ResourceLocation p_252125_, ResourceLocation key, CraftingBookCategory p_249010_) {
        super(p_252125_, p_249010_);
        this.key = key;
    }

    public boolean matches(CraftingContainer p_44002_, Level p_44003_) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(p_44002_.m_280657_());
        list.removeIf(ItemStack::m_41619_);
        boolean isEmpty = this.key.equals((Object)IngredientProviders.EMPTY.getId());
        if (list.size() != (isEmpty ? 1 : 2)) {
            return false;
        }
        return (isEmpty || list.stream().anyMatch(Ingredient.m_204132_(NetworkLinkQualificationRecipe.tag(this.key)))) && list.stream().anyMatch(Ingredient.m_43929_((ItemLike[])new ItemLike[]{FactoryBlocks.NETWORK_LINK}));
    }

    @Nullable
    private ResourceLocation test(ItemStack item) {
        return Ingredient.m_204132_(NetworkLinkQualificationRecipe.tag(this.key)).test(item) ? this.key : null;
    }

    public static TagKey<Item> tag(ResourceLocation location) {
        if (!IngredientRegistry.REGISTRY.get().containsKey(location)) {
            throw new IllegalArgumentException("Location" + String.valueOf(location) + " does not belong to ingredient types registry");
        }
        return TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)CreateFactoryLogistics.resource("network_link_qualifier/" + location.m_135827_() + "/" + location.m_135815_()));
    }

    public ItemStack assemble(CraftingContainer p_44001_, RegistryAccess p_267165_) {
        ItemStack link = null;
        ResourceLocation qualifier = null;
        boolean air = true;
        for (int i = 0; i < p_44001_.m_6643_(); ++i) {
            if (p_44001_.m_8020_(i).m_41720_() == FactoryBlocks.NETWORK_LINK.m_5456_()) {
                if (link != null) {
                    return ItemStack.f_41583_;
                }
                link = p_44001_.m_8020_(i);
                continue;
            }
            if (p_44001_.m_8020_(i).m_41619_()) continue;
            air = false;
            if (qualifier != null) {
                return ItemStack.f_41583_;
            }
            qualifier = this.test(p_44001_.m_8020_(i));
        }
        if (air) {
            qualifier = IngredientRegistry.REGISTRY.get().getDefaultKey();
        }
        if (link == null || qualifier == null) {
            return ItemStack.f_41583_;
        }
        link = NetworkLinkQualificationRecipe.qualifyTo(link, qualifier);
        if (air) {
            Objects.requireNonNull(link.m_41737_("BlockEntityTag")).m_128473_("Freq");
        }
        return link;
    }

    @NotNull
    public static ItemStack qualifyTo(ItemStack link, ResourceLocation qualifier) {
        link = link.m_41777_();
        CompoundTag tag = link.m_41698_("BlockEntityTag");
        tag.m_128359_("ingredient_type", qualifier.toString());
        return link;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return p_43999_ * p_44000_ >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FactoryRecipes.NETWORK_LINK_QUALIFICATION.get();
    }

    public ResourceLocation key() {
        return this.key;
    }

    public static class Serializer
    implements RecipeSerializer<NetworkLinkQualificationRecipe> {
        public NetworkLinkQualificationRecipe fromJson(ResourceLocation p_44103_, JsonObject p_44104_) {
            return new NetworkLinkQualificationRecipe(p_44103_, ResourceLocation.parse((String)p_44104_.get("key").getAsString()), (CraftingBookCategory)CraftingBookCategory.f_244644_.m_216455_(p_44104_.get("category").getAsString()));
        }

        @Nullable
        public NetworkLinkQualificationRecipe fromNetwork(ResourceLocation p_44105_, FriendlyByteBuf p_44106_) {
            return new NetworkLinkQualificationRecipe(p_44105_, p_44106_.m_130281_(), (CraftingBookCategory)p_44106_.m_130066_(CraftingBookCategory.class));
        }

        public void toNetwork(FriendlyByteBuf p_44101_, NetworkLinkQualificationRecipe p_44102_) {
            p_44101_.m_130085_(p_44102_.key);
            p_44101_.m_130068_((Enum)p_44102_.m_245232_());
        }
    }
}

