/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.packager;

import com.simibubi.create.content.logistics.box.PackageItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ru.zznty.create_factory_logistics.logistics.ingredient.BoardIngredient;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKey;
import ru.zznty.create_factory_logistics.logistics.ingredient.capability.PackageBuilder;
import ru.zznty.create_factory_logistics.logistics.ingredient.capability.PackageMeasureResult;
import ru.zznty.create_factory_logistics.logistics.ingredient.impl.item.ItemIngredientKey;

class BuiltInPackageBuilder
implements PackageBuilder {
    private final ItemStackHandler inventory = new ItemStackHandler(9);
    private boolean hasBulky = false;

    BuiltInPackageBuilder() {
    }

    @Override
    public int add(BoardIngredient content) {
        if (this.hasBulky) {
            return -1;
        }
        IngredientKey<?> ingredientKey = content.key();
        if (ingredientKey instanceof ItemIngredientKey) {
            ItemIngredientKey itemKey = (ItemIngredientKey)ingredientKey;
            this.hasBulky = this.measure(itemKey) == PackageMeasureResult.BULKY;
            return ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventory, (ItemStack)itemKey.stack().m_255036_(content.amount()), (boolean)false).m_41613_();
        }
        throw new IllegalArgumentException("Unsupported content: " + String.valueOf(content));
    }

    @Override
    public List<BoardIngredient> content() {
        ArrayList<BoardIngredient> list = new ArrayList<BoardIngredient>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            list.add(new BoardIngredient(IngredientKey.of(stackInSlot), stackInSlot.m_41613_()));
        }
        return list;
    }

    @Override
    public boolean isFull() {
        if (this.hasBulky) {
            return true;
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            if (!stackInSlot.m_41619_() && stackInSlot.m_41613_() >= stackInSlot.m_41741_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int maxPerSlot() {
        return 64;
    }

    @Override
    public int slotCount() {
        return 9;
    }

    @Override
    public PackageMeasureResult measure(IngredientKey key) {
        if (key instanceof ItemIngredientKey) {
            ItemIngredientKey itemKey = (ItemIngredientKey)key;
            return itemKey.stack().m_41720_().m_142095_() ? PackageMeasureResult.REGULAR : PackageMeasureResult.BULKY;
        }
        throw new IllegalArgumentException("Unsupported key: " + String.valueOf(key));
    }

    @Override
    public ItemStack build() {
        return this.inventory.getStackInSlot(0).m_41619_() ? ItemStack.f_41583_ : PackageItem.containing((ItemStackHandler)this.inventory);
    }
}

