/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.packager;

import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_logistics.CreateFactoryLogistics;
import ru.zznty.create_factory_logistics.FactoryBlocks;
import ru.zznty.create_factory_logistics.FactoryCapabilities;
import ru.zznty.create_factory_logistics.logistics.ingredient.capability.PackagerAttachedHandler;
import ru.zznty.create_factory_logistics.logistics.jarPackager.JarPackagerAttachedHandler;
import ru.zznty.create_factory_logistics.logistics.jarPackager.JarPackagerBlockEntity;
import ru.zznty.create_factory_logistics.logistics.packager.BuiltInPackagerAttachedHandler;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
@ApiStatus.Internal
public final class CapabilityAttacher {
    private static final TagKey<Block> ITEM_PACKAGER = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)CreateFactoryLogistics.resource("packager_item"));

    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object = event.getObject();
        if (object instanceof PackagerBlockEntity) {
            PackagerBlockEntity packagerBE = (PackagerBlockEntity)object;
            if (packagerBE.m_58900_().m_204336_(ITEM_PACKAGER)) {
                BuiltInPackagerCapabilityProvider provider = new BuiltInPackagerCapabilityProvider(packagerBE);
                event.addCapability(BuiltInPackagerCapabilityProvider.IDENTIFIER, (ICapabilityProvider)provider);
            } else if (packagerBE instanceof JarPackagerBlockEntity) {
                JarPackagerBlockEntity jarPackagerBE = (JarPackagerBlockEntity)packagerBE;
                if (packagerBE.m_58900_().m_60713_((Block)FactoryBlocks.JAR_PACKAGER.get())) {
                    JarPackagerCapabilityProvider provider = new JarPackagerCapabilityProvider(jarPackagerBE);
                    event.addCapability(JarPackagerCapabilityProvider.IDENTIFIER, (ICapabilityProvider)provider);
                }
            }
        }
    }

    private CapabilityAttacher() {
    }

    private static final class BuiltInPackagerCapabilityProvider
    implements ICapabilityProvider {
        public static final ResourceLocation IDENTIFIER = CreateFactoryLogistics.resource("packager_cap");
        private final BuiltInPackagerAttachedHandler backend;
        private final LazyOptional<PackagerAttachedHandler> handler;

        private BuiltInPackagerCapabilityProvider(PackagerBlockEntity packagerBE) {
            this.backend = new BuiltInPackagerAttachedHandler(packagerBE);
            this.handler = LazyOptional.of(() -> this.backend);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return FactoryCapabilities.PACKAGER_ATTACHED.orEmpty(cap, this.handler);
        }
    }

    private static final class JarPackagerCapabilityProvider
    implements ICapabilityProvider {
        public static final ResourceLocation IDENTIFIER = CreateFactoryLogistics.resource("jar_packager_cap");
        private final JarPackagerAttachedHandler backend;
        private final LazyOptional<PackagerAttachedHandler> handler;

        private JarPackagerCapabilityProvider(JarPackagerBlockEntity packagerBE) {
            this.backend = new JarPackagerAttachedHandler(packagerBE);
            this.handler = LazyOptional.of(() -> this.backend);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return FactoryCapabilities.PACKAGER_ATTACHED.orEmpty(cap, this.handler);
        }
    }
}

