/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.panel.request;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Pair;
import org.apache.commons.lang3.mutable.MutableBoolean;
import ru.zznty.create_factory_logistics.logistics.ingredient.BigIngredientStack;
import ru.zznty.create_factory_logistics.logistics.ingredient.BoardIngredient;
import ru.zznty.create_factory_logistics.logistics.panel.request.IngredientOrder;
import ru.zznty.create_factory_logistics.logistics.panel.request.IngredientRequest;
import ru.zznty.create_factory_logistics.logistics.panel.request.LogisticallyLinkedIngredientBehaviour;
import ru.zznty.create_factory_logistics.logistics.panel.request.PackagerIngredientBlockEntity;
import ru.zznty.create_factory_logistics.logistics.stock.IngredientInventorySummary;

public final class IngredientLogisticsManager {
    private static final Random r = new Random();

    public static boolean broadcastPackageRequest(UUID freqId, LogisticallyLinkedBehaviour.RequestType type, IngredientOrder order, @Nullable IdentifiedInventory ignoredHandler, String address) {
        if (order.isEmpty()) {
            return false;
        }
        Multimap<PackagerBlockEntity, IngredientRequest> requests = IngredientLogisticsManager.findPackagersForRequest(freqId, order, ignoredHandler, address);
        for (PackagerBlockEntity packager : requests.keySet()) {
            if (!packager.isTooBusyFor(type)) continue;
            return false;
        }
        IngredientLogisticsManager.performPackageRequests(requests);
        return true;
    }

    public static Multimap<PackagerBlockEntity, IngredientRequest> findPackagersForRequest(UUID freqId, IngredientOrder order, @Nullable IdentifiedInventory ignoredHandler, String address) {
        List<BigIngredientStack> stacks = order.stacks();
        HashMultimap requests = HashMultimap.create();
        Collection availableLinks = LogisticallyLinkedBehaviour.getAllPresent((UUID)freqId, (boolean)true);
        ArrayList<LogisticallyLinkedBehaviour> usedLinks = new ArrayList<LogisticallyLinkedBehaviour>();
        MutableBoolean finalLinkTracker = new MutableBoolean(false);
        IngredientOrder contextToSend = order;
        int orderId = r.nextInt();
        block0: for (int i = 0; i < stacks.size(); ++i) {
            BigIngredientStack entry = stacks.get(i);
            int remainingCount = entry.getCount();
            boolean finalEntry = i == stacks.size() - 1;
            BoardIngredient requestedIngredient = entry.ingredient();
            for (LogisticallyLinkedBehaviour link : availableLinks) {
                LogisticallyLinkedIngredientBehaviour ingredientLink;
                Pair<PackagerBlockEntity, IngredientRequest> request;
                int usedIndex = usedLinks.indexOf(link);
                int linkIndex = usedIndex == -1 ? usedLinks.size() : usedIndex;
                MutableBoolean isFinalLink = new MutableBoolean(false);
                if (linkIndex == usedLinks.size() - 1) {
                    isFinalLink = finalLinkTracker;
                }
                if ((request = (ingredientLink = (LogisticallyLinkedIngredientBehaviour)link).processRequest(requestedIngredient.withAmount(remainingCount), address, linkIndex, isFinalLink, orderId, contextToSend, ignoredHandler)) == null) continue;
                requests.put((Object)((PackagerBlockEntity)request.getFirst()), (Object)((IngredientRequest)request.getSecond()));
                int processedCount = ((IngredientRequest)request.getSecond()).getCount();
                if (processedCount > 0 && usedIndex == -1) {
                    contextToSend = null;
                    usedLinks.add(link);
                    finalLinkTracker = isFinalLink;
                }
                if ((remainingCount -= processedCount) > 0) continue;
                if (!finalEntry) continue block0;
                finalLinkTracker.setTrue();
                continue block0;
            }
        }
        return requests;
    }

    public static void performPackageRequests(Multimap<PackagerBlockEntity, IngredientRequest> requests) {
        for (Map.Entry entry : requests.asMap().entrySet().stream().toList()) {
            Collection queuedRequests = (Collection)entry.getValue();
            PackagerBlockEntity packager = (PackagerBlockEntity)entry.getKey();
            if (!queuedRequests.isEmpty()) {
                packager.flashLink();
            }
            for (int i = 0; i < 100 && !queuedRequests.isEmpty(); ++i) {
                PackagerIngredientBlockEntity ingredientPackager = (PackagerIngredientBlockEntity)packager;
                ingredientPackager.attemptToSendIngredients(queuedRequests);
            }
            packager.triggerStockCheck();
            packager.notifyUpdate();
        }
    }

    public static int getStockOf(UUID freqId, BoardIngredient ingredient, @Nullable IdentifiedInventory ignoredHandler) {
        int sum = 0;
        for (LogisticallyLinkedBehaviour link : LogisticallyLinkedBehaviour.getAllPresent((UUID)freqId, (boolean)false)) {
            sum += ((IngredientInventorySummary)link.getSummary(ignoredHandler)).getCountOf(ingredient.key());
        }
        return sum;
    }
}

