/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.logistics.panel.request;

import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import ru.zznty.create_factory_logistics.logistics.ingredient.BigIngredientStack;
import ru.zznty.create_factory_logistics.logistics.panel.request.PanelRequestedIngredients;

public record IngredientOrder(List<BigIngredientStack> stacks, List<PackageOrderWithCrafts.CraftingEntry> crafts) {
    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Entries", (Tag)NBTHelper.writeCompoundList(this.stacks, s -> s.asStack().write()));
        tag.m_128365_("Crafts", (Tag)NBTHelper.writeCompoundList(this.crafts, PackageOrderWithCrafts.CraftingEntry::write));
        return tag;
    }

    public static IngredientOrder empty() {
        return new IngredientOrder(List.of(), List.of());
    }

    public static IngredientOrder order(List<BigIngredientStack> stacks) {
        return new IngredientOrder(stacks, List.of());
    }

    public static IngredientOrder craftingOrder(List<BigIngredientStack> stacks, List<BigItemStack> craftPattern) {
        return new IngredientOrder(stacks, List.of(new PackageOrderWithCrafts.CraftingEntry(new PackageOrder(craftPattern), 1)));
    }

    public static IngredientOrder of(PanelRequestedIngredients ingredients) {
        return ingredients.hasCraftingContext() ? IngredientOrder.craftingOrder(ingredients.ingredients(), ingredients.craftingContext()) : IngredientOrder.order(ingredients.ingredients());
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public static IngredientOrder read(CompoundTag tag) {
        ListTag listTag = tag.m_128437_("Entries", 10);
        ArrayList<BigIngredientStack> stacks = new ArrayList<BigIngredientStack>(listTag.size());
        NBTHelper.iterateCompoundList((ListTag)listTag, entryTag -> stacks.add((BigIngredientStack)BigItemStack.read((CompoundTag)entryTag)));
        listTag = tag.m_128437_("Crafts", 10);
        ArrayList<PackageOrderWithCrafts.CraftingEntry> crafts = new ArrayList<PackageOrderWithCrafts.CraftingEntry>(listTag.size());
        NBTHelper.iterateCompoundList((ListTag)listTag, entryTag -> crafts.add(PackageOrderWithCrafts.CraftingEntry.read((CompoundTag)entryTag)));
        return new IngredientOrder(stacks, crafts);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.stacks.size());
        for (BigIngredientStack bigIngredientStack : this.stacks) {
            bigIngredientStack.asStack().send(buffer);
        }
        buffer.m_130130_(this.crafts.size());
        for (PackageOrderWithCrafts.CraftingEntry craftingEntry : this.crafts) {
            craftingEntry.write(buffer);
        }
    }

    public PackageOrderWithCrafts asCrafting() {
        return new PackageOrderWithCrafts(new PackageOrder(this.stacks.stream().map(BigIngredientStack::asStack).toList()), this.crafts);
    }

    public static IngredientOrder read(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        ArrayList<BigIngredientStack> stacks = new ArrayList<BigIngredientStack>(size);
        for (int i = 0; i < size; ++i) {
            stacks.add((BigIngredientStack)BigItemStack.receive((FriendlyByteBuf)buffer));
        }
        int craftSize = buffer.m_130242_();
        ArrayList<PackageOrderWithCrafts.CraftingEntry> crafts = new ArrayList<PackageOrderWithCrafts.CraftingEntry>(craftSize);
        for (int i = 0; i < craftSize; ++i) {
            crafts.add(PackageOrderWithCrafts.CraftingEntry.read((FriendlyByteBuf)buffer));
        }
        return new IngredientOrder(stacks, crafts);
    }

    public static void set(ItemStack box, int orderId, int linkIndex, boolean isFinalLink, int fragmentIndex, boolean isFinal, @Nullable IngredientOrder orderContext) {
        PackageOrderWithCrafts craftingOrder;
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("OrderId", orderId);
        tag.m_128405_("LinkIndex", linkIndex);
        tag.m_128379_("IsFinalLink", isFinalLink);
        tag.m_128405_("Index", fragmentIndex);
        tag.m_128379_("IsFinal", isFinal);
        if (orderContext != null && (craftingOrder = orderContext.asCrafting()) != null) {
            tag.m_128365_("OrderContext", (Tag)craftingOrder.write());
        }
        box.m_41784_().m_128365_("Fragment", (Tag)tag);
    }

    public static IngredientOrder of(PackageOrderWithCrafts orderWithCrafts) {
        return new IngredientOrder(orderWithCrafts.stacks().stream().map(it -> (BigIngredientStack)it).toList(), orderWithCrafts.orderedCrafts());
    }
}

