/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.packager;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.content.logistics.packagerLink.RequestPromise;
import com.simibubi.create.content.logistics.packagerLink.RequestPromiseQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import ru.zznty.create_factory_logistics.logistics.ingredient.BigIngredientStack;
import ru.zznty.create_factory_logistics.logistics.ingredient.BoardIngredient;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKey;
import ru.zznty.create_factory_logistics.logistics.panel.request.IngredientPromiseQueue;

@Mixin(value={RequestPromiseQueue.class})
public class IngredientPromiseQueueMixin
implements IngredientPromiseQueue {
    @Unique
    private final Multimap<IngredientKey, RequestPromise> createFactoryLogistics$promises = HashMultimap.create();
    @Shadow(remap=false)
    private Runnable onChanged;

    @Overwrite(remap=false)
    public void forceClear(ItemStack stack) {
        this.forceClear(new BoardIngredient(IngredientKey.of(stack), 1));
    }

    @Overwrite(remap=false)
    public int getTotalPromisedAndRemoveExpired(ItemStack stack, int expiryTime) {
        return this.getTotalPromisedAndRemoveExpired(new BoardIngredient(IngredientKey.of(stack), 1), expiryTime);
    }

    @Overwrite(remap=false)
    public void itemEnteredSystem(ItemStack stack, int amount) {
        this.ingredientEnteredSystem(new BoardIngredient(IngredientKey.of(stack), amount));
    }

    @Override
    public void add(BigIngredientStack stack) {
        this.add(new RequestPromise(stack.asStack()));
    }

    @Override
    public void forceClear(BoardIngredient ingredient) {
        Collection promises = this.createFactoryLogistics$promises.get(ingredient.key().genericCopy());
        if (promises.isEmpty()) {
            return;
        }
        Iterator iterator = promises.iterator();
        while (iterator.hasNext()) {
            RequestPromise promise = (RequestPromise)iterator.next();
            BigIngredientStack stack = (BigIngredientStack)promise.promisedStack;
            if (!stack.ingredient().canStack(ingredient)) continue;
            iterator.remove();
            this.onChanged.run();
        }
    }

    @Override
    public int getTotalPromisedAndRemoveExpired(BoardIngredient ingredient, int expiryTime) {
        int promised = 0;
        Collection promises = this.createFactoryLogistics$promises.get(ingredient.key().genericCopy());
        if (promises.isEmpty()) {
            return promised;
        }
        Iterator iterator = promises.iterator();
        while (iterator.hasNext()) {
            RequestPromise promise = (RequestPromise)iterator.next();
            BigIngredientStack stack = (BigIngredientStack)promise.promisedStack;
            if (!ingredient.canStack(stack.ingredient())) continue;
            if (expiryTime != -1 && promise.ticksExisted >= expiryTime) {
                iterator.remove();
                this.onChanged.run();
                continue;
            }
            promised += promise.promisedStack.count;
        }
        return promised;
    }

    @Override
    public void ingredientEnteredSystem(BoardIngredient ingredient) {
        Collection promises = this.createFactoryLogistics$promises.get(ingredient.key().genericCopy());
        if (promises.isEmpty()) {
            return;
        }
        int amount = ingredient.amount();
        Iterator iterator = promises.iterator();
        while (iterator.hasNext()) {
            RequestPromise requestPromise = (RequestPromise)iterator.next();
            BigIngredientStack stack = (BigIngredientStack)requestPromise.promisedStack;
            if (!ingredient.canStack(stack.ingredient())) continue;
            int toSubtract = Math.min(amount, stack.getCount());
            amount -= toSubtract;
            stack.setCount(stack.getCount() - toSubtract);
            if (stack.getCount() <= 0) {
                iterator.remove();
                this.onChanged.run();
            }
            if (amount > 0) continue;
            break;
        }
    }

    @Overwrite(remap=false)
    public void add(RequestPromise promise) {
        BigIngredientStack stack = (BigIngredientStack)promise.promisedStack;
        this.createFactoryLogistics$promises.put(stack.ingredient().key().genericCopy(), (Object)promise);
        if (!stack.ingredient().isEmpty()) {
            this.onChanged.run();
        }
    }

    @Overwrite(remap=false)
    public void tick() {
        this.createFactoryLogistics$promises.forEach((key, promise) -> promise.tick());
    }

    @Overwrite(remap=false)
    public boolean isEmpty() {
        return this.createFactoryLogistics$promises.isEmpty();
    }

    @Overwrite(remap=false)
    public List<RequestPromise> flatten(boolean sorted) {
        ArrayList<RequestPromise> all = new ArrayList<RequestPromise>(this.createFactoryLogistics$promises.values());
        if (sorted) {
            all.sort(RequestPromise.ageComparator());
        }
        return all;
    }
}

