/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.panel;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.AllPackets;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelEffectPacket;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.LogisticsManager;
import com.simibubi.create.content.logistics.packagerLink.RequestPromise;
import com.simibubi.create.content.logistics.packagerLink.RequestPromiseQueue;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import ru.zznty.create_factory_logistics.Config;
import ru.zznty.create_factory_logistics.FactoryCapabilities;
import ru.zznty.create_factory_logistics.compat.extra_gauges.AbstractPanelBehaviourStub;
import ru.zznty.create_factory_logistics.logistics.ingredient.BigIngredientStack;
import ru.zznty.create_factory_logistics.logistics.ingredient.BoardIngredient;
import ru.zznty.create_factory_logistics.logistics.ingredient.capability.PackagerAttachedHandler;
import ru.zznty.create_factory_logistics.logistics.panel.request.IngredientLogisticsManager;
import ru.zznty.create_factory_logistics.logistics.panel.request.IngredientOrder;
import ru.zznty.create_factory_logistics.logistics.panel.request.IngredientRequest;
import ru.zznty.create_factory_logistics.logistics.panel.request.PanelRequestedIngredients;
import ru.zznty.create_factory_logistics.logistics.stock.IngredientInventorySummary;

@Mixin(value={FactoryPanelBehaviour.class})
public abstract class FactoryPanelRequestMixin
extends FilteringBehaviour
implements MenuProvider {
    @Shadow(remap=false)
    public Map<FactoryPanelPosition, FactoryPanelConnection> targetedBy;
    @Shadow(remap=false)
    public RequestPromiseQueue restockerPromises;
    @Shadow(remap=false)
    public boolean satisfied;
    @Shadow(remap=false)
    public boolean promisedSatisfied;
    @Shadow(remap=false)
    public boolean waitingForNetwork;
    @Shadow(remap=false)
    public boolean redstonePowered;
    @Shadow(remap=false)
    private int timer;
    @Shadow(remap=false)
    private int recipeOutput;
    @Shadow(remap=false)
    public String recipeAddress;
    @Shadow(remap=false)
    public List<ItemStack> activeCraftingArrangement;
    @Shadow(remap=false)
    public UUID network;

    public FactoryPanelRequestMixin(SmartBlockEntity be, ValueBoxTransform slot) {
        super(be, slot);
    }

    @Shadow(remap=false)
    public FactoryPanelBlockEntity panelBE() {
        return null;
    }

    @Shadow(remap=false)
    public void resetTimer() {
    }

    @Shadow(remap=false)
    public FactoryPanelPosition getPanelPosition() {
        return null;
    }

    @Shadow(remap=false)
    public int getLevelInStorage() {
        return 0;
    }

    @Shadow(remap=false)
    public int getPromised() {
        return 0;
    }

    @Shadow(remap=false)
    private int getConfigRequestIntervalInTicks() {
        return 0;
    }

    @Shadow
    protected abstract void sendEffect(FactoryPanelPosition var1, boolean var2);

    @Unique
    private void createFactoryLogistics$sendEffect(FactoryPanelPosition fromPos, FactoryPanelPosition toPos, boolean success) {
        AllPackets.sendToNear((Level)this.getWorld(), (BlockPos)this.getPos(), (int)64, (Object)new FactoryPanelEffectPacket(fromPos, toPos, success));
    }

    @Unique
    private void createFactoryLogistics$tryRestock() {
        FactoryPanelBlockEntity panelBE = this.panelBE();
        PackagerBlockEntity packager = panelBE.getRestockedPackager();
        if (packager == null) {
            return;
        }
        Optional handler = packager.getCapability(FactoryCapabilities.PACKAGER_ATTACHED).resolve();
        if (handler.isEmpty()) {
            return;
        }
        BoardIngredient ingredient = BoardIngredient.of((FactoryPanelBehaviour)this);
        IdentifiedInventory identifiedInventory = ((PackagerAttachedHandler)handler.get()).identifiedInventory();
        if (identifiedInventory == null) {
            return;
        }
        int availableOnNetwork = IngredientLogisticsManager.getStockOf(this.network, ingredient, identifiedInventory);
        if (availableOnNetwork == 0) {
            this.sendEffect(this.getPanelPosition(), false);
            return;
        }
        int inStorage = this.getLevelInStorage();
        int promised = this.getPromised();
        int demand = ingredient.amount();
        int amountToOrder = Math.max(0, demand - promised - inStorage);
        BigIngredientStack orderedIngredient = BigIngredientStack.of(ingredient, Math.min(amountToOrder, availableOnNetwork));
        IngredientOrder order = IngredientOrder.order(List.of(orderedIngredient));
        this.sendEffect(this.getPanelPosition(), true);
        if (!IngredientLogisticsManager.broadcastPackageRequest(this.network, LogisticallyLinkedBehaviour.RequestType.RESTOCK, order, identifiedInventory, this.recipeAddress)) {
            return;
        }
        this.restockerPromises.add(new RequestPromise(orderedIngredient.asStack()));
    }

    @Unique
    private boolean createFactoryLogistics$requestDependent(Multimap<UUID, PanelRequestedIngredients> toRequest, FactoryPanelConnection sourceConnection, FactoryPanelBehaviour context, Set<FactoryPanelPosition> visited) {
        FactoryPanelBehaviour source = FactoryPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelConnection)sourceConnection);
        if (source == null) {
            return false;
        }
        if (!visited.add(sourceConnection.from)) {
            // empty if block
        }
        BoardIngredient ingredient = BoardIngredient.of(source).withAmount(sourceConnection.amount);
        IngredientInventorySummary summary = (IngredientInventorySummary)LogisticsManager.getSummaryOfNetwork((UUID)source.network, (boolean)true);
        if (ingredient.isEmpty() || summary.isEmpty()) {
            this.createFactoryLogistics$sendEffect(sourceConnection.from, context.getPanelPosition(), false);
            return false;
        }
        if (summary.getCountOf(ingredient.key()) >= ingredient.amount()) {
            return true;
        }
        if (source.getLevelInStorage() + source.getPromised() >= ingredient.amount()) {
            return false;
        }
        if (Config.factoryGaugeCascadeRequest && !source.targetedBy.isEmpty() && !source.recipeAddress.isBlank()) {
            for (FactoryPanelConnection connection : source.targetedBy.values()) {
                if (this.createFactoryLogistics$requestDependent(toRequest, connection, source, visited)) continue;
                return false;
            }
        } else {
            return false;
        }
        toRequest.put((Object)source.network, (Object)PanelRequestedIngredients.of(source));
        this.createFactoryLogistics$sendEffect(sourceConnection.from, context.getPanelPosition(), true);
        return true;
    }

    @WrapMethod(method={"tickRequests"}, remap=false)
    private void tickRequests(Operation<Void> original) {
        FactoryPanelBehaviour source = (FactoryPanelBehaviour)this;
        if (AbstractPanelBehaviourStub.is(source)) {
            original.call(new Object[0]);
            return;
        }
        FactoryPanelBlockEntity panelBE = this.panelBE();
        if (this.targetedBy.isEmpty() && !panelBE.restocker) {
            return;
        }
        if (this.satisfied || this.promisedSatisfied || this.waitingForNetwork || this.redstonePowered) {
            return;
        }
        if (this.timer > 0) {
            this.timer = org.joml.Math.min((int)this.timer, (int)this.getConfigRequestIntervalInTicks());
            --this.timer;
            return;
        }
        this.resetTimer();
        if (this.recipeAddress.isBlank()) {
            return;
        }
        if (panelBE.restocker) {
            this.createFactoryLogistics$tryRestock();
            return;
        }
        HashMultimap toRequest = HashMultimap.create();
        HashSet<FactoryPanelPosition> visited = new HashSet<FactoryPanelPosition>();
        for (Object connection : source.targetedBy.values()) {
            if (this.createFactoryLogistics$requestDependent((Multimap<UUID, PanelRequestedIngredients>)toRequest, (FactoryPanelConnection)connection, source, visited)) continue;
            this.sendEffect(((FactoryPanelConnection)connection).from, false);
            return;
        }
        if (visited.size() == this.targetedBy.size()) {
            toRequest.put((Object)source.network, (Object)PanelRequestedIngredients.of(source));
        }
        HashMap<PanelRequestedIngredients, Multimap<PackagerBlockEntity, IngredientRequest>> requests = new HashMap<PanelRequestedIngredients, Multimap<PackagerBlockEntity, IngredientRequest>>();
        for (Map.Entry entry : toRequest.asMap().entrySet()) {
            for (PanelRequestedIngredients requestedIngredients : (Collection)entry.getValue()) {
                IngredientOrder order = IngredientOrder.of(requestedIngredients);
                Multimap<PackagerBlockEntity, IngredientRequest> request = IngredientLogisticsManager.findPackagersForRequest((UUID)entry.getKey(), order, null, requestedIngredients.recipeAddress());
                if (request.isEmpty()) continue;
                requests.put(requestedIngredients, request);
            }
        }
        for (Multimap multimap : requests.values()) {
            for (PackagerBlockEntity packager : multimap.keySet()) {
                if (!packager.isTooBusyFor(LogisticallyLinkedBehaviour.RequestType.RESTOCK)) continue;
                return;
            }
        }
        for (Multimap multimap : requests.values()) {
            IngredientLogisticsManager.performPackageRequests((Multimap<PackagerBlockEntity, IngredientRequest>)multimap);
        }
        RequestPromiseQueue promises = Create.LOGISTICS.getQueuedPromises(this.network);
        if (promises != null) {
            for (Map.Entry entry : requests.entrySet()) {
                if (!((Multimap)entry.getValue()).isEmpty()) continue;
                promises.add(new RequestPromise(((PanelRequestedIngredients)entry.getKey()).result().asStack()));
            }
        }
        panelBE.advancements.awardPlayer(AllAdvancements.FACTORY_GAUGE);
    }

    @ModifyVariable(method={"tickStorageMonitor"}, at=@At(value="STORE"), ordinal=0, remap=false)
    private boolean setSatisfied(boolean value, @Local(ordinal=1) int promised) {
        return value && promised == 0;
    }
}

