/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.redstoneRequester;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterBlockEntity;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterConfigurationPacket;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterMenu;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterScreen;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import ru.zznty.create_factory_logistics.Config;
import ru.zznty.create_factory_logistics.logistics.ingredient.BigIngredientStack;
import ru.zznty.create_factory_logistics.logistics.ingredient.BoardIngredient;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientGui;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKey;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientProviders;
import ru.zznty.create_factory_logistics.logistics.panel.request.IngredientGhostMenu;
import ru.zznty.create_factory_logistics.logistics.panel.request.IngredientRedstoneRequester;
import ru.zznty.create_factory_logistics.logistics.panel.request.IngredientRedstoneRequesterConfigurationPacket;

@Mixin(value={RedstoneRequesterScreen.class})
public abstract class RedstoneRequesterScreenMixin
extends AbstractSimiContainerScreen<RedstoneRequesterMenu> {
    @Shadow(remap=false)
    private List<Integer> amounts;
    @Shadow(remap=false)
    private EditBox addressBox;

    public RedstoneRequesterScreenMixin(RedstoneRequesterMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    public void m_280092_(GuiGraphics p_281607_, Slot p_282613_) {
        if (p_282613_ instanceof SlotItemHandler) {
            IngredientGhostMenu ghostMenu = (IngredientGhostMenu)this.f_97732_;
            BoardIngredient ingredient = ghostMenu.getIngredientInSlot(p_282613_.getSlotIndex());
            IngredientGui.renderSlot(p_281607_, ingredient.key(), p_282613_.f_40220_, p_282613_.f_40221_);
            return;
        }
        super.m_280092_(p_281607_, p_282613_);
    }

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/PackageOrderWithCrafts;stacks()Ljava/util/List;")}, remap=false)
    private List<BigIngredientStack> getOrderAmounts(PackageOrderWithCrafts instance, Operation<List<BigItemStack>> original) {
        IngredientRedstoneRequester requester = (IngredientRedstoneRequester)((RedstoneRequesterMenu)this.f_97732_).contentHolder;
        return requester.getOrder().stacks();
    }

    @WrapOperation(method={"renderForeground"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/items/ItemStackHandler;getStackInSlot(I)Lnet/minecraft/world/item/ItemStack;")}, remap=false)
    private ItemStack getIngredientInSlot(ItemStackHandler instance, int slot, Operation<ItemStack> original, @Share(value="ingredient") LocalRef<BoardIngredient> ingredient) {
        IngredientGhostMenu ghostMenu = (IngredientGhostMenu)this.f_97732_;
        ingredient.set((Object)ghostMenu.getIngredientInSlot(slot));
        return ItemStack.f_41583_;
    }

    @ModifyExpressionValue(method={"renderForeground"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z")})
    private boolean isIngredientEmpty(boolean original, @Share(value="ingredient") LocalRef<BoardIngredient> ingredient) {
        return ((BoardIngredient)ingredient.get()).isEmpty();
    }

    @Redirect(method={"renderForeground"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"))
    private void renderIngredient(GuiGraphics instance, Font l, ItemStack i, int j, int k, String i1, @Local(index=7) int index, @Share(value="ingredient") LocalRef<BoardIngredient> ingredient) {
        IngredientGui.renderDecorations(instance, ((BoardIngredient)ingredient.get()).withAmount(this.amounts.get(index)), j, k);
    }

    @WrapOperation(method={"mouseScrolled"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/items/ItemStackHandler;getStackInSlot(I)Lnet/minecraft/world/item/ItemStack;")})
    private ItemStack getIngredientInSlotMouseHandler(ItemStackHandler instance, int slot, Operation<ItemStack> original, @Share(value="ingredient") LocalRef<BoardIngredient> ingredient) {
        IngredientGhostMenu ghostMenu = (IngredientGhostMenu)this.f_97732_;
        ingredient.set((Object)ghostMenu.getIngredientInSlot(slot));
        return ItemStack.f_41583_;
    }

    @ModifyExpressionValue(method={"mouseScrolled"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z")})
    private boolean isIngredientEmptyMouseHandler(boolean original, @Share(value="ingredient") LocalRef<BoardIngredient> ingredient) {
        return ((BoardIngredient)ingredient.get()).isEmpty();
    }

    @ModifyConstant(method={"mouseScrolled"}, constant={@Constant(intValue=256)})
    private int modifyMaxAmount(int constant, @Share(value="ingredient") LocalRef<BoardIngredient> ingredient) {
        return ((BoardIngredient)ingredient.get()).key().provider() == IngredientProviders.FLUID.get() ? 16 * Config.jarCapacity : constant;
    }

    protected void m_280072_(GuiGraphics graphics, int x, int y) {
        if (((RedstoneRequesterMenu)this.f_97732_).m_142621_().m_41619_() && this.f_97734_ instanceof SlotItemHandler) {
            IngredientGhostMenu ghostMenu = (IngredientGhostMenu)this.f_97732_;
            BoardIngredient ingredient = ghostMenu.getIngredientInSlot(this.f_97734_.getSlotIndex());
            if (!ingredient.isEmpty()) {
                LangBuilder name = CreateLang.translate((String)"gui.factory_panel.send_item", (Object[])new Object[]{IngredientGui.nameBuilder(ingredient.withAmount(this.amounts.get(this.f_97734_.getSlotIndex())))});
                List<MutableComponent> components = List.of(name.color(ScrollInput.HEADER_RGB).component(), CreateLang.translate((String)"gui.factory_panel.scroll_to_change_amount", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component(), CreateLang.translate((String)"gui.scrollInput.shiftScrollsFaster", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component());
                graphics.m_280677_(this.f_96547_, components, Optional.empty(), x, y);
                return;
            }
            if (((RedstoneRequesterMenu)this.f_97732_).m_142621_().m_41619_()) {
                List<MutableComponent> components = List.of(Component.m_237115_((String)"create_factory_logistics.gui.redstone_requester.fluid_slot_mode").m_130940_(ChatFormatting.GRAY));
                graphics.m_280677_(this.f_96547_, components, Optional.empty(), x, y);
                return;
            }
        }
        super.m_280072_(graphics, x, y);
    }

    @WrapOperation(method={"getTooltipFromContainerItem"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/foundation/gui/menu/AbstractSimiContainerScreen;getTooltipFromContainerItem(Lnet/minecraft/world/item/ItemStack;)Ljava/util/List;")})
    private List<Component> getTooltipFromContainerItem(RedstoneRequesterScreen instance, ItemStack itemStack, Operation<List<Component>> original) {
        if (!(this.f_97734_ instanceof SlotItemHandler)) {
            return (List)original.call(new Object[]{instance, itemStack});
        }
        return List.of();
    }

    @Overwrite(remap=false)
    protected void m_181908_() {
        super.m_181908_();
        this.addressBox.m_94120_();
        IngredientGhostMenu ghostMenu = (IngredientGhostMenu)this.f_97732_;
        for (int i = 0; i < this.amounts.size(); ++i) {
            if (!ghostMenu.getIngredientInSlot(i).isEmpty()) continue;
            this.amounts.set(i, 1);
        }
    }

    protected void m_6597_(@Nullable Slot p_97778_, int p_97779_, int p_97780_, ClickType p_97781_) {
        if (p_97778_ instanceof SlotItemHandler) {
            IngredientGhostMenu ghostMenu = (IngredientGhostMenu)this.f_97732_;
            if (((RedstoneRequesterMenu)this.f_97732_).m_142621_().m_41619_()) {
                ghostMenu.setIngredientInSlot(p_97778_.getSlotIndex(), BoardIngredient.of());
            } else {
                if (RedstoneRequesterScreenMixin.m_96639_() && GenericItemEmptying.canItemBeEmptied((Level)((RedstoneRequesterBlockEntity)((RedstoneRequesterMenu)this.f_97732_).contentHolder).m_58904_(), (ItemStack)((RedstoneRequesterMenu)this.f_97732_).m_142621_())) {
                    FluidStack stack = (FluidStack)GenericItemEmptying.emptyItem((Level)((RedstoneRequesterBlockEntity)((RedstoneRequesterMenu)this.f_97732_).contentHolder).m_58904_(), (ItemStack)((RedstoneRequesterMenu)this.f_97732_).m_142621_(), (boolean)true).getFirst();
                    if (!stack.isEmpty()) {
                        ghostMenu.setIngredientInSlot(p_97778_.getSlotIndex(), new BoardIngredient(IngredientKey.of(stack), 1));
                    }
                    return;
                }
                ghostMenu.setIngredientInSlot(p_97778_.getSlotIndex(), new BoardIngredient(IngredientKey.of(((RedstoneRequesterMenu)this.f_97732_).m_142621_().m_41777_()), 1));
            }
        }
        super.m_6597_(p_97778_, p_97779_, p_97780_, p_97781_);
    }

    @ModifyExpressionValue(method={"removed"}, at={@At(value="NEW", target="(Lnet/minecraft/core/BlockPos;Ljava/lang/String;ZLjava/util/List;)Lcom/simibubi/create/content/logistics/redstoneRequester/RedstoneRequesterConfigurationPacket;")})
    private RedstoneRequesterConfigurationPacket createPacket(RedstoneRequesterConfigurationPacket original) {
        IngredientGhostMenu ghostMenu = (IngredientGhostMenu)this.f_97732_;
        List<BoardIngredient> ingredients = ghostMenu.getIngredients();
        ArrayList<BigIngredientStack> stacks = new ArrayList<BigIngredientStack>(ingredients.size());
        for (int i = 0; i < ingredients.size(); ++i) {
            if (ingredients.get(i).isEmpty()) continue;
            stacks.add(BigIngredientStack.of(ingredients.get(i), this.amounts.get(i)));
        }
        IngredientRedstoneRequesterConfigurationPacket packet = (IngredientRedstoneRequesterConfigurationPacket)original;
        packet.setStacks(stacks);
        return original;
    }
}

