/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.stock;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import ru.zznty.create_factory_logistics.logistics.ingredient.BigIngredientStack;
import ru.zznty.create_factory_logistics.logistics.ingredient.BoardIngredient;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKey;
import ru.zznty.create_factory_logistics.logistics.ingredient.impl.item.ItemIngredientKey;
import ru.zznty.create_factory_logistics.logistics.stock.IngredientInventorySummary;

@Mixin(value={InventorySummary.class})
public class InventorySummaryMixin
implements IngredientInventorySummary {
    @Unique
    private final Multimap<IngredientKey, BigIngredientStack> createFactoryLogistics$ingredients = HashMultimap.create();
    @Unique
    private List<BigIngredientStack> createFactoryLogistics$stacksByCount;
    @Shadow(remap=false)
    private int totalCount;
    @Shadow(remap=false)
    public int contributingLinks;

    @Overwrite(remap=false)
    public void add(ItemStack stack, int count) {
        if (stack.m_41619_() || count == 0) {
            return;
        }
        this.add(new BoardIngredient(IngredientKey.of(stack), count));
    }

    @Overwrite(remap=false)
    public int getCountOf(ItemStack stack) {
        return this.getCountOf(IngredientKey.of(stack));
    }

    @Overwrite(remap=false)
    public List<BigIngredientStack> getStacks() {
        ArrayList<BigIngredientStack> stacks = new ArrayList<BigIngredientStack>();
        for (Collection value : this.createFactoryLogistics$ingredients.asMap().values()) {
            Iterator iter = value.iterator();
            BigIngredientStack stack = BigIngredientStack.of(((BigIngredientStack)iter.next()).ingredient());
            while (iter.hasNext()) {
                stack.setCount(stack.getCount() + ((BigIngredientStack)iter.next()).getCount());
            }
            stacks.add(stack);
        }
        return stacks;
    }

    @Override
    public List<BoardIngredient> get() {
        ArrayList<BoardIngredient> list = new ArrayList<BoardIngredient>(this.createFactoryLogistics$ingredients.size());
        for (BigIngredientStack stack : this.createFactoryLogistics$ingredients.values()) {
            list.add(stack.ingredient());
        }
        return list;
    }

    @Overwrite(remap=false)
    public boolean erase(ItemStack stack) {
        return this.erase(IngredientKey.of(stack));
    }

    @Overwrite(remap=false)
    public void add(InventorySummary summary) {
        IngredientInventorySummary otherSummary = (IngredientInventorySummary)summary;
        for (BoardIngredient ingredient : otherSummary.get()) {
            this.add(ingredient);
        }
        this.contributingLinks += summary.contributingLinks;
    }

    @Overwrite(remap=false)
    public InventorySummary copy() {
        IngredientInventorySummary copy = (IngredientInventorySummary)new InventorySummary();
        copy.add(this);
        return (InventorySummary)copy;
    }

    @Overwrite(remap=false)
    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("List", (Tag)NBTHelper.writeCompoundList((Iterable)this.createFactoryLogistics$ingredients.values(), stack -> stack.asStack().write()));
        return tag;
    }

    @Overwrite(remap=false)
    public static InventorySummary read(CompoundTag tag) {
        IngredientInventorySummary summary = (IngredientInventorySummary)new InventorySummary();
        ListTag listTag = tag.m_128437_("List", 10);
        NBTHelper.iterateCompoundList((ListTag)listTag, compoundTag -> summary.add(((BigIngredientStack)BigItemStack.read((CompoundTag)compoundTag)).ingredient()));
        return (InventorySummary)summary;
    }

    @Override
    @Overwrite(remap=false)
    public boolean isEmpty() {
        return this.createFactoryLogistics$ingredients.isEmpty();
    }

    @Overwrite(remap=false)
    public List<BigIngredientStack> getStacksByCount() {
        if (this.createFactoryLogistics$stacksByCount == null) {
            this.createFactoryLogistics$stacksByCount = this.getStacks();
            this.createFactoryLogistics$stacksByCount.sort(BigIngredientStack.COMPARATOR);
        }
        return this.createFactoryLogistics$stacksByCount;
    }

    @Overwrite(remap=false)
    public Map<Item, List<BigIngredientStack>> getItemMap() {
        IdentityHashMap<Item, List<BigIngredientStack>> map = new IdentityHashMap<Item, List<BigIngredientStack>>();
        for (Map.Entry entry : this.createFactoryLogistics$ingredients.asMap().entrySet()) {
            Object k = entry.getKey();
            if (!(k instanceof ItemIngredientKey)) continue;
            ItemIngredientKey itemKey = (ItemIngredientKey)k;
            map.put(itemKey.stack().m_41720_(), new ArrayList((Collection)entry.getValue()));
        }
        return map;
    }

    @Overwrite(remap=false)
    public void add(BigItemStack stack) {
        this.add(((BigIngredientStack)stack).ingredient());
    }

    @Override
    public void add(BoardIngredient ingredient) {
        if (ingredient.isEmpty()) {
            return;
        }
        this.createFactoryLogistics$invalidate();
        if (this.totalCount < 1000000000) {
            this.totalCount += ingredient.amount();
        }
        Collection stacks = this.createFactoryLogistics$ingredients.get(ingredient.key().genericCopy());
        for (BigIngredientStack stack : stacks) {
            if (!stack.ingredient().canStack(ingredient)) continue;
            if (!stack.isInfinite()) {
                stack.setCount(stack.getCount() + ingredient.amount());
            }
            return;
        }
        stacks.add(BigIngredientStack.of(ingredient, ingredient.amount()));
    }

    @Override
    public void add(IngredientInventorySummary summary) {
        this.add((InventorySummary)summary);
    }

    @Override
    public int getCountOf(IngredientKey key) {
        int count = 0;
        for (BigIngredientStack stack : this.createFactoryLogistics$ingredients.get(key.genericCopy())) {
            if (!stack.ingredient().canStack(key) || count >= 1000000000) continue;
            count += stack.getCount();
        }
        return count;
    }

    @Override
    public int getCountOf(BigIngredientStack stack) {
        return this.getCountOf(stack.ingredient().key());
    }

    @Override
    public boolean erase(IngredientKey key) {
        Collection stacks = this.createFactoryLogistics$ingredients.get(key.genericCopy());
        if (stacks.isEmpty()) {
            return false;
        }
        Iterator iterator = stacks.iterator();
        while (iterator.hasNext()) {
            BigIngredientStack existing = (BigIngredientStack)iterator.next();
            if (!existing.ingredient().canStack(key)) continue;
            this.totalCount -= existing.getCount();
            iterator.remove();
            this.createFactoryLogistics$invalidate();
            return true;
        }
        return false;
    }

    @Unique
    private void createFactoryLogistics$invalidate() {
        this.createFactoryLogistics$stacksByCount = null;
    }
}

