/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.stockKeeper;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.stockTicker.CraftableBigItemStack;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestScreen;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import ru.zznty.create_factory_logistics.logistics.ingredient.BigIngredientStack;
import ru.zznty.create_factory_logistics.logistics.ingredient.BoardIngredient;
import ru.zznty.create_factory_logistics.logistics.ingredient.CraftableIngredientStack;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientGui;
import ru.zznty.create_factory_logistics.logistics.ingredient.IngredientKey;
import ru.zznty.create_factory_logistics.logistics.ingredient.impl.fluid.FluidIngredientKey;
import ru.zznty.create_factory_logistics.logistics.stock.IngredientInventorySummary;

@Mixin(value={StockKeeperRequestScreen.class})
public abstract class StockKeeperRequestScreenMixin
extends AbstractSimiContainerScreen<StockKeeperRequestMenu> {
    @Shadow(remap=false)
    private InventorySummary forcedEntries;
    @Shadow(remap=false)
    public List<BigItemStack> itemsToOrder;
    @Shadow(remap=false)
    StockTickerBlockEntity blockEntity;
    @Shadow(remap=false)
    public List<List<BigItemStack>> currentItemSource;
    @Shadow(remap=false)
    public List<CraftableBigItemStack> recipesToOrder;
    @Shadow(remap=false)
    private boolean canRequestCraftingPackage;
    @Shadow
    private int orderY;

    public StockKeeperRequestScreenMixin(StockKeeperRequestMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    @Shadow(remap=false)
    private Pair<Integer, List<List<BigItemStack>>> maxCraftable(CraftableBigItemStack cbis, InventorySummary summary, Function<ItemStack, Integer> countModifier, int newTypeLimit) {
        return null;
    }

    @Redirect(method={"containerTick"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/packager/InventorySummary;getCountOf(Lnet/minecraft/world/item/ItemStack;)I"))
    private int getCountInForced(InventorySummary instance, ItemStack $, @Local BigItemStack entry) {
        BigIngredientStack stack = (BigIngredientStack)entry;
        return ((IngredientInventorySummary)instance).getCountOf(stack);
    }

    @Redirect(method={"containerTick"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/packager/InventorySummary;erase(Lnet/minecraft/world/item/ItemStack;)Z"))
    private boolean eraseFromForced(InventorySummary instance, ItemStack $, @Local BigItemStack entry) {
        BigIngredientStack stack = (BigIngredientStack)entry;
        IngredientInventorySummary summary = (IngredientInventorySummary)instance;
        return summary.erase(stack.ingredient().key());
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="NEW", target="(Lnet/minecraft/world/item/ItemStack;I)Lcom/simibubi/create/content/logistics/BigItemStack;"))
    private BigItemStack createOrderForIngredientInClicked(ItemStack $, int count, @Local(ordinal=0) BigItemStack entry) {
        BigIngredientStack stack = (BigIngredientStack)entry;
        return BigIngredientStack.of(stack.ingredient().withAmount(1), 0).asStack();
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="NEW", target="(Lnet/minecraft/world/item/ItemStack;I)Lcom/simibubi/create/content/logistics/BigItemStack;"))
    private BigItemStack createOrderForIngredientInScrolled(ItemStack $, int count, @Local(ordinal=0) BigItemStack entry) {
        BigIngredientStack stack = (BigIngredientStack)entry;
        return BigIngredientStack.of(stack.ingredient().withAmount(1), 0).asStack();
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/packager/InventorySummary;getCountOf(Lnet/minecraft/world/item/ItemStack;)I"))
    private int getCountInSummary(InventorySummary instance, ItemStack $, @Local(ordinal=0) BigItemStack entry) {
        BigIngredientStack stack = (BigIngredientStack)entry;
        return ((IngredientInventorySummary)instance).getCountOf(stack);
    }

    @Unique
    private BigIngredientStack createFactoryLogistics$getOrderForIngredient(BoardIngredient ingredient) {
        for (BigItemStack entry : this.itemsToOrder) {
            BigIngredientStack stack = (BigIngredientStack)entry;
            if (!stack.ingredient().canStack(ingredient)) continue;
            return stack;
        }
        return null;
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/StockKeeperRequestScreen;getOrderForItem(Lnet/minecraft/world/item/ItemStack;)Lcom/simibubi/create/content/logistics/BigItemStack;"))
    private BigItemStack getExistingOrderInClicked(StockKeeperRequestScreen instance, ItemStack $, @Local BigItemStack itemStack) {
        BigIngredientStack stack = (BigIngredientStack)itemStack;
        BigIngredientStack order = this.createFactoryLogistics$getOrderForIngredient(stack.ingredient());
        return order == null ? null : order.asStack();
    }

    @Redirect(method={"renderItemEntry"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/StockKeeperRequestScreen;getOrderForItem(Lnet/minecraft/world/item/ItemStack;)Lcom/simibubi/create/content/logistics/BigItemStack;"), remap=false)
    private BigItemStack getExistingOrderInRender(StockKeeperRequestScreen instance, ItemStack $, @Local(argsOnly=true) BigItemStack itemStack) {
        BigIngredientStack stack = (BigIngredientStack)itemStack;
        BigIngredientStack order = this.createFactoryLogistics$getOrderForIngredient(stack.ingredient());
        return order == null ? null : order.asStack();
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getMaxStackSize()I"))
    private int getMaxStackSize(ItemStack instance, @Local BigItemStack itemStack) {
        BigIngredientStack stack = (BigIngredientStack)itemStack;
        return IngredientGui.stackSize(stack.ingredient().key());
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/StockKeeperRequestScreen;getOrderForItem(Lnet/minecraft/world/item/ItemStack;)Lcom/simibubi/create/content/logistics/BigItemStack;"))
    private BigItemStack getExistingOrderInScrolled(StockKeeperRequestScreen instance, ItemStack $, @Local BigItemStack itemStack) {
        BigIngredientStack stack = (BigIngredientStack)itemStack;
        BigIngredientStack order = this.createFactoryLogistics$getOrderForIngredient(stack.ingredient());
        return order == null ? null : order.asStack();
    }

    @Overwrite(remap=false)
    private void revalidateOrders() {
        HashSet<BigItemStack> invalid = new HashSet<BigItemStack>(this.itemsToOrder);
        IngredientInventorySummary summary = (IngredientInventorySummary)this.blockEntity.getLastClientsideStockSnapshotAsSummary();
        if (this.currentItemSource == null || summary == null) {
            this.itemsToOrder.removeAll(invalid);
            return;
        }
        for (BigItemStack entry : this.itemsToOrder) {
            BigIngredientStack stack = (BigIngredientStack)entry;
            stack.setCount(Math.min(summary.getCountOf(stack), stack.getCount()));
            if (stack.getCount() <= 0) continue;
            invalid.remove(entry);
        }
        this.itemsToOrder.removeAll(invalid);
    }

    @Redirect(method={"renderForeground"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;renderTooltip(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;II)V"))
    private void renderTooltip(GuiGraphics instance, Font p_282308_, ItemStack p_282781_, int p_282687_, int p_282292_, @Local BigItemStack itemStack, @Local(ordinal=1) boolean orderHovered) {
        BigIngredientStack stack = (BigIngredientStack)itemStack;
        BigIngredientStack order = this.createFactoryLogistics$getOrderForIngredient(stack.ingredient());
        int customCount = stack.getCount();
        if (stack.getCount() < 1000000000 && !orderHovered) {
            int forcedCount = ((IngredientInventorySummary)this.forcedEntries).getCountOf(stack);
            if (forcedCount != 0) {
                customCount = Math.min(customCount, -forcedCount - 1);
            }
            if (order != null) {
                customCount -= order.getCount();
            }
            customCount = Math.max(0, customCount);
        }
        instance.m_280666_(p_282308_, IngredientGui.tooltipBuilder(stack.ingredient().key(), customCount), p_282687_, p_282292_);
    }

    @Redirect(method={"renderForeground"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getTooltipLines(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/TooltipFlag;)Ljava/util/List;"))
    private List<Component> getCraftableTooltip(ItemStack instance, Player player, TooltipFlag flag, @Local BigItemStack itemStack) {
        BigIngredientStack stack = (BigIngredientStack)itemStack;
        return IngredientGui.tooltipBuilder(stack.ingredient().key(), stack.ingredient().amount());
    }

    @WrapOperation(method={"refreshSearchResults"}, at={@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;stack:Lnet/minecraft/world/item/ItemStack;")}, remap=false)
    private ItemStack fluidStackSearchPlaceholder(BigItemStack instance, Operation<ItemStack> original) {
        BigIngredientStack stack = (BigIngredientStack)instance;
        IngredientKey<?> ingredientKey = stack.ingredient().key();
        if (ingredientKey instanceof FluidIngredientKey) {
            FluidIngredientKey fluidKey = (FluidIngredientKey)ingredientKey;
            return fluidKey.stack().getFluid().m_6859_().m_7968_();
        }
        return (ItemStack)original.call(new Object[]{instance});
    }

    @Redirect(method={"renderItemEntry"}, at=@At(value="INVOKE", target="Lnet/createmod/catnip/gui/element/GuiGameElement;of(Lnet/minecraft/world/item/ItemStack;)Lnet/createmod/catnip/gui/element/GuiGameElement$GuiRenderBuilder;"), remap=false)
    private GuiGameElement.GuiRenderBuilder renderIngredientEntry(ItemStack itemStack, @Local(argsOnly=true) BigItemStack entry, @Local(argsOnly=true) GuiGraphics graphics) {
        BigIngredientStack stack = (BigIngredientStack)entry;
        IngredientGui.renderSlot(graphics, stack.ingredient().key(), 0, 0);
        return GuiGameElement.of((ItemLike)Blocks.f_50016_);
    }

    @Redirect(method={"renderItemEntry"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/StockKeeperRequestScreen;drawItemCount(Lnet/minecraft/client/gui/GuiGraphics;II)V"), remap=false)
    private void renderIngredientEntryAmount(StockKeeperRequestScreen instance, GuiGraphics graphics, int count, int customCount, @Local(argsOnly=true) BigItemStack entry, @Local(argsOnly=true, ordinal=0) boolean isStackHovered, @Local(argsOnly=true, ordinal=1) boolean isRenderingOrders) {
        if (isStackHovered && isRenderingOrders && !(entry instanceof CraftableBigItemStack)) {
            return;
        }
        BigIngredientStack stack = (BigIngredientStack)entry;
        count = customCount;
        IngredientGui.renderDecorations(graphics, stack.ingredient().withAmount(count), 1, 1);
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=1))
    private void decreaseOrderCount(BigItemStack instance, int count) {
        BigIngredientStack stack = (BigIngredientStack)instance;
        stack.setCount(count);
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=4))
    private void increaseOrderCount(BigItemStack instance, int count) {
        BigIngredientStack stack = (BigIngredientStack)instance;
        stack.setCount(count);
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=1))
    private void scrollDecreaseOrderCount(BigItemStack instance, int count) {
        BigIngredientStack stack = (BigIngredientStack)instance;
        stack.setCount(count);
    }

    @Redirect(method={"mouseScrolled"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=4))
    private void scrollIncreaseOrderCount(BigItemStack instance, int count) {
        BigIngredientStack stack = (BigIngredientStack)instance;
        stack.setCount(count);
    }

    @Redirect(method={"requestCraftable"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/stockTicker/CraftableBigItemStack;count:I", ordinal=2), remap=false)
    private void updateOrderCountCraftable(CraftableBigItemStack instance, int count) {
        BigIngredientStack stack = (BigIngredientStack)instance;
        stack.setCount(count);
    }

    @Redirect(method={"requestCraftable"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=3), remap=false)
    private void decreaseOrderCountCraftable(BigItemStack instance, int count) {
        BigIngredientStack stack = (BigIngredientStack)instance;
        stack.setCount(count);
    }

    @Redirect(method={"requestCraftable"}, at=@At(value="FIELD", target="Lcom/simibubi/create/content/logistics/BigItemStack;count:I", ordinal=6), remap=false)
    private void increaseOrderCountCraftable(BigItemStack instance, int count) {
        BigIngredientStack stack = (BigIngredientStack)instance;
        stack.setCount(count);
    }

    @Overwrite(remap=false)
    private void updateCraftableAmounts() {
        BigIngredientStack orderedStack;
        InventorySummary usedItems = new InventorySummary();
        InventorySummary availableItems = new InventorySummary();
        IngredientInventorySummary usedIngredients = (IngredientInventorySummary)usedItems;
        IngredientInventorySummary availableIngredients = (IngredientInventorySummary)availableItems;
        for (BigItemStack ordered : this.itemsToOrder) {
            orderedStack = (BigIngredientStack)ordered;
            availableIngredients.add(orderedStack.ingredient());
        }
        block1: for (CraftableBigItemStack cbis : this.recipesToOrder) {
            Pair<Integer, List<List<BigItemStack>>> craftingResult;
            CraftableIngredientStack craftableStack = (CraftableIngredientStack)cbis;
            if (craftableStack.ingredients().isEmpty()) {
                craftingResult = this.maxCraftable(cbis, availableItems, stack -> -usedItems.getCountOf(stack), -1);
                int maxCraftable = (Integer)craftingResult.getFirst();
                List validEntriesByIngredient = (List)craftingResult.getSecond();
                int outputCount = craftableStack.outputCount(this.blockEntity.m_58904_());
                craftableStack.setCount(Math.min(craftableStack.getCount(), maxCraftable));
                block2: for (List list : validEntriesByIngredient) {
                    int remaining = cbis.count / outputCount;
                    for (BigItemStack entry : list) {
                        if (remaining <= 0) continue block2;
                        usedItems.add(entry.stack, Math.min(remaining, entry.count));
                        remaining -= entry.count;
                    }
                }
                continue;
            }
            craftingResult = this.createFactoryLogistics$maxCraftable(craftableStack, availableIngredients, stack -> -usedIngredients.getCountOf(stack.key()), -1);
            int outputCount = craftableStack.outputCount(this.blockEntity.m_58904_());
            craftableStack.setCount(Math.min(craftableStack.getCount(), (Integer)craftingResult.getFirst()));
            int remaining = cbis.count / outputCount;
            for (Pair ingredient : (List)craftingResult.getSecond()) {
                if (remaining <= 0) continue block1;
                int count = usedIngredients.getCountOf(((BoardIngredient)ingredient.getSecond()).key());
                usedIngredients.add(((BoardIngredient)ingredient.getSecond()).withAmount(Math.min(remaining, count)));
                remaining -= count;
            }
        }
        this.canRequestCraftingPackage = false;
        for (BigItemStack ordered : this.itemsToOrder) {
            orderedStack = (BigIngredientStack)ordered;
            if (usedIngredients.getCountOf(orderedStack) == orderedStack.getCount()) continue;
            return;
        }
        this.canRequestCraftingPackage = true;
    }

    @WrapMethod(method={"requestCraftable"}, remap=false)
    private void requestIngredients(CraftableBigItemStack cbis, int requestedDifference, Operation<Void> original) {
        boolean takeOrdersAway;
        CraftableIngredientStack stack = (CraftableIngredientStack)cbis;
        if (stack.ingredients().isEmpty()) {
            original.call(new Object[]{cbis, requestedDifference});
            return;
        }
        boolean bl = takeOrdersAway = requestedDifference < 0;
        if (takeOrdersAway) {
            requestedDifference = Math.max(-cbis.count, requestedDifference);
        }
        if (requestedDifference == 0) {
            return;
        }
        IngredientInventorySummary availableItems = (IngredientInventorySummary)this.blockEntity.getLastClientsideStockSnapshotAsSummary();
        Function<BoardIngredient, Integer> countModifier = ingredient -> {
            BigIngredientStack ordered = this.createFactoryLogistics$getOrderForIngredient((BoardIngredient)ingredient);
            return ordered == null ? 0 : -ordered.getCount();
        };
        if (takeOrdersAway) {
            availableItems = (IngredientInventorySummary)new InventorySummary();
            for (BigItemStack ordered : this.itemsToOrder) {
                BigIngredientStack orderedStack = (BigIngredientStack)ordered;
                availableItems.add(orderedStack.ingredient());
            }
            countModifier = ingredient -> 0;
        }
        CraftableIngredientStack craftableStack = (CraftableIngredientStack)cbis;
        Pair<Integer, List<Pair<BoardIngredient, BoardIngredient>>> craftingResult = this.createFactoryLogistics$maxCraftable(craftableStack, availableItems, countModifier, takeOrdersAway ? -1 : 9 - this.itemsToOrder.size());
        int outputCount = craftableStack.outputCount(this.blockEntity.m_58904_());
        int adjustToRecipeAmount = Mth.m_14167_((float)((float)Math.abs(requestedDifference) / (float)outputCount)) * outputCount;
        int maxCraftable = Math.min(adjustToRecipeAmount, (Integer)craftingResult.getFirst());
        if (maxCraftable == 0) {
            return;
        }
        craftableStack.setCount(craftableStack.getCount() + (takeOrdersAway ? -maxCraftable : maxCraftable));
        List validEntriesByIngredient = (List)craftingResult.getSecond();
        for (Pair entry : validEntriesByIngredient) {
            int remaining = maxCraftable / outputCount;
            for (int i = 0; i < maxCraftable && remaining > 0; --remaining, ++i) {
                int toTransfer = Math.min(remaining, ((BoardIngredient)entry.getSecond()).amount());
                BigIngredientStack order = this.createFactoryLogistics$getOrderForIngredient((BoardIngredient)entry.getSecond());
                if (takeOrdersAway) {
                    if (order == null) continue;
                    order.setCount(order.getCount() - toTransfer * ((BoardIngredient)entry.getFirst()).amount());
                    if (order.getCount() > 0) continue;
                    this.itemsToOrder.remove(order);
                    continue;
                }
                if (order == null) {
                    order = (BigIngredientStack)new BigItemStack(ItemStack.f_41583_, 0);
                    order.setIngredient(((BoardIngredient)entry.getSecond()).withAmount(0));
                    this.itemsToOrder.add(order.asStack());
                }
                order.setCount(order.getCount() + toTransfer * ((BoardIngredient)entry.getFirst()).amount());
            }
        }
    }

    @Unique
    private Pair<Integer, List<Pair<BoardIngredient, BoardIngredient>>> createFactoryLogistics$maxCraftable(CraftableIngredientStack cbis, IngredientInventorySummary summary, Function<BoardIngredient, Integer> countModifier, int newTypeLimit) {
        ArrayList<Pair> validIngredients = new ArrayList<Pair>(cbis.ingredients().size());
        for (BoardIngredient ingredient : cbis.ingredients()) {
            BoardIngredient storedIngredient = ingredient.withAmount(summary.getCountOf(ingredient.key()));
            int storedAmount = storedIngredient.amount() + countModifier.apply(storedIngredient);
            validIngredients.add(Pair.of((Object)ingredient, (Object)storedIngredient.withAmount(storedAmount / ingredient.amount())));
        }
        if (newTypeLimit != -1) {
            int toRemove = (int)validIngredients.stream().filter(entry -> this.createFactoryLogistics$getOrderForIngredient((BoardIngredient)entry.getSecond()) == null).distinct().count() - newTypeLimit;
            validIngredients.sort(Comparator.comparingInt(p -> ((BoardIngredient)p.getSecond()).amount()));
            for (int i = 0; i < toRemove; ++i) {
                validIngredients.remove(validIngredients.size() - 1);
            }
        }
        int minCount = Integer.MAX_VALUE;
        for (Pair ingredient : validIngredients) {
            minCount = Math.min(((BoardIngredient)ingredient.getSecond()).amount() * ((BoardIngredient)ingredient.getFirst()).amount(), minCount);
        }
        if (minCount == 0) {
            return Pair.of((Object)0, List.of());
        }
        int outputCount = cbis.outputCount(this.blockEntity.m_58904_());
        return Pair.of((Object)(minCount * outputCount), validIngredients);
    }
}

