/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.mixin.logistics.stockKeeper;

import com.simibubi.create.compat.jei.StockKeeperTransferHandler;
import com.simibubi.create.content.logistics.stockTicker.CraftableBigItemStack;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestScreen;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.library.transfer.RecipeTransferErrorMissingSlots;
import mezz.jei.library.transfer.RecipeTransferErrorTooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import ru.zznty.create_factory_logistics.compat.jei.IngredientTransfer;
import ru.zznty.create_factory_logistics.compat.jei.TransferOperation;
import ru.zznty.create_factory_logistics.compat.jei.TransferOperationsResult;
import ru.zznty.create_factory_logistics.logistics.ingredient.BoardIngredient;
import ru.zznty.create_factory_logistics.logistics.ingredient.CraftableIngredientStack;
import ru.zznty.create_factory_logistics.logistics.stock.IngredientInventorySummary;

@Mixin(value={StockKeeperTransferHandler.class})
public class StockKeeperTransferHandlerMixin {
    @Shadow(remap=false)
    private IJeiHelpers helpers;

    @Overwrite(remap=false)
    @Nullable
    private IRecipeTransferError transferRecipeOnClient(StockKeeperRequestMenu container, Recipe<?> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        Iterator iterator = container.screenReference;
        if (!(iterator instanceof StockKeeperRequestScreen)) {
            return null;
        }
        StockKeeperRequestScreen screen = (StockKeeperRequestScreen)iterator;
        for (CraftableBigItemStack cbis : screen.recipesToOrder) {
            if (cbis.recipe != recipe) continue;
            return new RecipeTransferErrorTooltip((Component)CreateLang.translate((String)"gui.stock_keeper.already_ordering_recipe", (Object[])new Object[0]).component());
        }
        if (screen.itemsToOrder.size() >= 9) {
            return new RecipeTransferErrorTooltip((Component)CreateLang.translate((String)"gui.stock_keeper.slots_full", (Object[])new Object[0]).component());
        }
        IngredientInventorySummary summary = (IngredientInventorySummary)((StockTickerBlockEntity)((StockKeeperRequestMenu)screen.m_6262_()).contentHolder).getLastClientsideStockSnapshotAsSummary();
        if (summary == null) {
            return null;
        }
        List<BoardIngredient> availableStacks = summary.get();
        RecipeWrapper outputDummy = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(9));
        ArrayList<Slot> craftingSlots = new ArrayList<Slot>();
        for (int i = 0; i < outputDummy.m_6643_(); ++i) {
            craftingSlots.add(new Slot((Container)outputDummy, i, 0, 0));
        }
        TransferOperationsResult transferOperations = IngredientTransfer.getRecipeTransferOperations(this.helpers.getIngredientManager(), availableStacks, recipeSlots.getSlotViews(RecipeIngredientRole.INPUT), craftingSlots);
        if (!transferOperations.missingItems().isEmpty()) {
            return new RecipeTransferErrorMissingSlots((Component)CreateLang.translate((String)"gui.stock_keeper.not_in_stock", (Object[])new Object[0]).component(), transferOperations.missingItems());
        }
        if (screen.itemsToOrder.size() + transferOperations.results().size() >= 9) {
            return new RecipeTransferErrorTooltip((Component)CreateLang.translate((String)"gui.stock_keeper.slots_full", (Object[])new Object[0]).component());
        }
        if (!doTransfer) {
            return null;
        }
        CraftableBigItemStack cbis = new CraftableBigItemStack(recipe.m_8043_(player.m_9236_().m_9598_()), recipe);
        CraftableIngredientStack ingredientStack = (CraftableIngredientStack)cbis;
        ingredientStack.setCount(0);
        for (TransferOperation operation : transferOperations.results()) {
            IIngredientHelper helper = this.helpers.getIngredientManager().getIngredientHelper(operation.selectedIngredient().getType());
            ingredientStack.ingredients().add(availableStacks.get(operation.from()).withAmount((int)helper.getAmount(operation.selectedIngredient().getIngredient())));
        }
        for (IRecipeSlotView slotView : recipeSlots.getSlotViews(RecipeIngredientRole.OUTPUT)) {
            Optional<BoardIngredient> ingredient;
            Optional displayedIngredient = slotView.getDisplayedIngredient();
            if (displayedIngredient.isEmpty() || (ingredient = IngredientTransfer.tryConvert(this.helpers.getIngredientManager(), (ITypedIngredient)displayedIngredient.get())).isEmpty()) continue;
            ingredientStack.results().add(ingredient.get());
        }
        if (cbis.stack.m_41619_() && !ingredientStack.results().isEmpty()) {
            ingredientStack.setIngredient(ingredientStack.results().get(0).withAmount(0));
        }
        screen.recipesToOrder.add(cbis);
        screen.searchBox.m_94144_("");
        screen.refreshSearchNextTick = true;
        screen.requestCraftable(cbis, maxTransfer && !cbis.stack.m_41619_() ? cbis.stack.m_41741_() : 1);
        return null;
    }
}

