/*
 * Decompiled with CFR 0.152.
 */
package ru.zznty.create_factory_logistics.render;

import com.mojang.math.Axis;
import com.simibubi.create.content.fluids.FluidMesh;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.visual.util.SmartRecycler;
import java.util.Arrays;
import java.util.function.Function;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class FluidVisual {
    private final SmartRecycler<TextureAtlasSprite, TransformedInstance> surface = new SmartRecycler(key -> (TransformedInstance)context.instancerProvider().instancer(InstanceTypes.TRANSFORMED, FluidMesh.surface((TextureAtlasSprite)key, (float)1.0f)).createInstance());
    private final Direction[] sides;
    private final boolean renderGasesFromTop;

    public FluidVisual(VisualizationContext context, boolean renderBottom, boolean renderGasesFromTop) {
        this.sides = renderBottom ? Iterate.directions : Arrays.copyOfRange(Iterate.directions, 1, Iterate.directions.length);
        this.renderGasesFromTop = renderGasesFromTop;
    }

    public TransformedInstance[] setupBuffers(FluidStack fluidStack, int start) {
        if (fluidStack.isEmpty()) {
            return null;
        }
        TransformedInstance[] buffers = new TransformedInstance[start + this.sides.length];
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        TextureAtlasSprite stillTexture = (TextureAtlasSprite)atlas.apply(clientFluid.getStillTexture(fluidStack));
        for (int i = 0; i < this.sides.length; ++i) {
            buffers[start + i] = (TransformedInstance)this.surface.get((Object)stillTexture);
            buffers[start + i].colorArgb(clientFluid.getTintColor(fluidStack));
        }
        return buffers;
    }

    public void setupBuffer(FluidStack fluidStack, int capacity, TransformedInstance buffer, int index, float width, float height) {
        Direction side = this.sides[index];
        width -= 0.00390625f;
        float fillFactor = (float)fluidStack.getAmount() / (float)capacity;
        buffer.translateY(-1.1875f);
        if (side.m_122434_().m_122479_()) {
            buffer.translateY(fillFactor * height / 2.0f);
            buffer.scaleY(fillFactor / 2.0f);
        } else {
            buffer.translateY(fillFactor * height / 2.0f + height / 2.0f);
        }
        float horizontalOffset = width / 4.0f + width;
        horizontalOffset *= side.m_122421_() == Direction.AxisDirection.POSITIVE ? 1.0f : -1.0f;
        if (side.m_122434_() == Direction.Axis.X) {
            buffer.translateX(horizontalOffset);
        } else if (side.m_122434_() == Direction.Axis.Z) {
            buffer.translateZ(horizontalOffset);
        }
        buffer.scale(0.5f);
        if (this.renderGasesFromTop && fluidStack.getFluid().getFluidType().isLighterThanAir()) {
            buffer.rotateDegrees(180.0f, Axis.f_252529_);
        }
        buffer.rotateTo(Direction.UP, side);
        if (side.m_122434_().m_122478_()) {
            buffer.scale(width);
        }
        if (side.m_122434_() == Direction.Axis.X) {
            buffer.scaleZ(width);
        } else if (side.m_122434_() == Direction.Axis.Z) {
            buffer.scaleX(width);
        }
    }

    public void begin() {
        this.surface.resetCount();
    }

    public void end() {
        this.surface.discardExtra();
    }

    public void delete() {
        this.surface.delete();
    }
}

