/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.gbd.entities;

import com.ibarnstormer.gbd.capability.ModCapabilityProvider;
import com.ibarnstormer.gbd.registry.ModEntities;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class BeamReactorLaserEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_TICK = SynchedEntityData.m_135353_(BeamReactorLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_CACHED_OWNER_ID = SynchedEntityData.m_135353_(BeamReactorLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private int clientSideAttackTime;
    private int beamTick;
    public Vec3 offsetOld = Vec3.f_82478_;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected int lerpSteps;

    public BeamReactorLaserEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public BeamReactorLaserEntity(Level level, Entity owner) {
        super((EntityType)ModEntities.BEAM_REACTOR_LASER_ENTITY.get(), level);
        this.f_19804_.m_135381_(DATA_TICK, (Object)0);
        this.cachedOwner = owner;
        this.ownerUUID = owner.m_20148_();
        this.f_19804_.m_135381_(DATA_CACHED_OWNER_ID, (Object)owner.m_19879_());
        this.beamTick = 0;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_TICK, (Object)0);
        this.f_19804_.m_135372_(DATA_CACHED_OWNER_ID, (Object)0);
    }

    protected void m_7378_(CompoundTag p_20052_) {
        if (p_20052_.m_128403_("Owner")) {
            this.ownerUUID = p_20052_.m_128342_("Owner");
        }
    }

    protected void m_7380_(@NotNull CompoundTag p_20139_) {
        if (this.ownerUUID != null) {
            p_20139_.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        this.f_19811_ = true;
        if ((Integer)this.f_19804_.m_135370_(DATA_TICK) < 40) {
            this.f_19804_.m_135381_(DATA_TICK, (Object)((Integer)this.f_19804_.m_135370_(DATA_TICK) + 1));
        }
        ++this.beamTick;
        if (this.m_9236_().f_46443_ && this.clientSideAttackTime < 41) {
            ++this.clientSideAttackTime;
        }
        if (!this.m_9236_().f_46443_ && (entity = this.getOwner()) instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(ModCapabilityProvider.BEAM_REACTOR_CAPABILITY).ifPresent(cap -> {
                if (cap.getBeam() != this) {
                    this.m_146870_();
                }
            });
        }
        if (!this.m_213877_()) {
            this.lerpPosition();
        }
        if (this.getOwner() != null) {
            this.m_6034_(this.getOwner().m_20182_().f_82479_, this.getOwner().m_20188_() + 0.2, this.getOwner().m_20182_().f_82481_);
        }
    }

    public void m_6453_(double p_20977_, double p_20978_, double p_20979_, float p_20980_, float p_20981_, int p_20982_, boolean p_20983_) {
        this.lerpX = p_20977_;
        this.lerpY = p_20978_;
        this.lerpZ = p_20979_;
        this.lerpSteps = p_20982_;
    }

    public void lerpPosition() {
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d2 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d4 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            --this.lerpSteps;
            this.m_6034_(d0, d2, d4);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public float getAttackAnimationScale(float p_32813_) {
        return ((float)this.clientSideAttackTime + p_32813_) / 40.0f;
    }

    @Nullable
    public Entity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public int getTick() {
        return (Integer)this.f_19804_.m_135370_(DATA_TICK);
    }

    public int getBeamTick() {
        return this.beamTick;
    }

    public int getClientSideAttackTime() {
        return this.clientSideAttackTime;
    }

    @Nullable
    public Entity getCachedOwner() {
        if (this.m_9236_().f_46443_) {
            Entity owner = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(DATA_CACHED_OWNER_ID)).intValue());
            if (owner instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)owner;
                return livingOwner;
            }
            return null;
        }
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity livingOwner = (LivingEntity)entity;
            return livingOwner;
        }
        return null;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(@NotNull DamageSource p_37616_, float p_37617_) {
        return false;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

