/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.computercraft.implementation;

import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.implementation.peripherals.DisplayLinkPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.SequencedGearshiftPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.SpeedControllerPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.SpeedGaugePeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.StationPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.StressGaugePeripheral;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.simibubi.create.content.kinetics.speedController.SpeedControllerBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ForgeRegistries;

public class ComputerBehaviour
extends AbstractComputerBehaviour {
    protected static final Capability<IPeripheral> PERIPHERAL_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPeripheral>(){});
    LazyOptional<IPeripheral> peripheral;
    NonNullSupplier<IPeripheral> peripheralSupplier;

    public ComputerBehaviour(SmartBlockEntity te) {
        super(te);
        this.peripheralSupplier = ComputerBehaviour.getPeripheralFor(te);
    }

    public static NonNullSupplier<IPeripheral> getPeripheralFor(SmartBlockEntity be) {
        if (be instanceof SpeedControllerBlockEntity) {
            SpeedControllerBlockEntity scbe = (SpeedControllerBlockEntity)be;
            return () -> new SpeedControllerPeripheral(scbe, scbe.targetSpeed);
        }
        if (be instanceof DisplayLinkBlockEntity) {
            DisplayLinkBlockEntity dlbe = (DisplayLinkBlockEntity)be;
            return () -> new DisplayLinkPeripheral(dlbe);
        }
        if (be instanceof SequencedGearshiftBlockEntity) {
            SequencedGearshiftBlockEntity sgbe = (SequencedGearshiftBlockEntity)be;
            return () -> new SequencedGearshiftPeripheral(sgbe);
        }
        if (be instanceof SpeedGaugeBlockEntity) {
            SpeedGaugeBlockEntity sgbe = (SpeedGaugeBlockEntity)be;
            return () -> new SpeedGaugePeripheral(sgbe);
        }
        if (be instanceof StressGaugeBlockEntity) {
            StressGaugeBlockEntity sgbe = (StressGaugeBlockEntity)be;
            return () -> new StressGaugePeripheral(sgbe);
        }
        if (be instanceof StationBlockEntity) {
            StationBlockEntity sbe = (StationBlockEntity)be;
            return () -> new StationPeripheral(sbe);
        }
        throw new IllegalArgumentException("No peripheral available for " + String.valueOf(ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)be.m_58903_())));
    }

    @Override
    public <T> boolean isPeripheralCap(Capability<T> cap) {
        return cap == PERIPHERAL_CAPABILITY;
    }

    @Override
    public <T> LazyOptional<T> getPeripheralCapability() {
        if (this.peripheral == null || !this.peripheral.isPresent()) {
            this.peripheral = LazyOptional.of(this.peripheralSupplier);
        }
        return this.peripheral.cast();
    }

    @Override
    public void removePeripheral() {
        if (this.peripheral != null) {
            this.peripheral.invalidate();
        }
    }
}

