/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.pipes.valve;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.IAxisPipe;
import com.simibubi.create.content.fluids.pipes.valve.FluidValveBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import javax.annotation.Nonnull;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;

public class FluidValveBlock
extends DirectionalAxisKineticBlock
implements IAxisPipe,
IBE<FluidValveBlockEntity>,
ProperWaterloggedBlock {
    public static final BooleanProperty ENABLED = BooleanProperty.m_61465_((String)"enabled");

    public FluidValveBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return AllShapes.FLUID_VALVE.get(FluidValveBlock.getPipeAxis(state));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{ENABLED, WATERLOGGED}));
    }

    @Override
    protected boolean prefersConnectionTo(LevelReader reader, BlockPos pos, Direction facing, boolean shaftAxis) {
        if (!shaftAxis) {
            BlockPos offset = pos.m_121945_(facing);
            BlockState blockState = reader.m_8055_(offset);
            return FluidPipeBlock.canConnectTo((BlockAndTintGetter)reader, offset, blockState, facing);
        }
        return super.prefersConnectionTo(reader, pos, facing, shaftAxis);
    }

    @Nonnull
    public static Direction.Axis getPipeAxis(BlockState state) {
        if (!(state.m_60734_() instanceof FluidValveBlock)) {
            throw new IllegalStateException("Provided BlockState is for a different block.");
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean alongFirst = (Boolean)state.m_61143_((Property)AXIS_ALONG_FIRST_COORDINATE) == false;
        for (Direction.Axis axis : Iterate.axes) {
            if (axis == facing.m_122434_()) continue;
            if (!alongFirst) {
                alongFirst = true;
                continue;
            }
            return axis;
        }
        throw new IllegalStateException("Impossible axis.");
    }

    @Override
    public Direction.Axis getAxis(BlockState state) {
        return FluidValveBlock.getPipeAxis(state);
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean blockTypeChanged;
        boolean bl = blockTypeChanged = !state.m_60713_(newState.m_60734_());
        if (blockTypeChanged && !world.f_46443_) {
            FluidPropagator.propagateChangedPipe((LevelAccessor)world, pos, state);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public boolean m_7898_(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        return true;
    }

    @Override
    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        if (world.f_46443_) {
            return;
        }
        if (state != oldState) {
            world.m_186464_(pos, (Block)this, 1, TickPriority.HIGH);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        DebugPackets.m_133708_((Level)world, (BlockPos)pos);
        Direction d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null) {
            return;
        }
        if (!FluidValveBlock.isOpenAt(state, d)) {
            return;
        }
        world.m_186464_(pos, (Block)this, 1, TickPriority.HIGH);
    }

    public static boolean isOpenAt(BlockState state, Direction d) {
        return d.m_122434_() == FluidValveBlock.getPipeAxis(state);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource r) {
        FluidPropagator.propagateChangedPipe((LevelAccessor)world, pos, state);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public Class<FluidValveBlockEntity> getBlockEntityClass() {
        return FluidValveBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends FluidValveBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.FLUID_VALVE.get();
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.withWater(super.m_5573_(context), context);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        this.updateWater(world, state, pos);
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return this.fluidState(state);
    }
}

