/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.spout;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;

public class SpoutRenderer
extends SafeBlockEntityRenderer<SpoutBlockEntity> {
    static final PartialModel[] BITS = new PartialModel[]{AllPartialModels.SPOUT_TOP, AllPartialModels.SPOUT_MIDDLE, AllPartialModels.SPOUT_BOTTOM};

    public SpoutRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(SpoutBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        SmartFluidTankBehaviour tank = be.tank;
        if (tank == null) {
            return;
        }
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float level = primaryTank.getFluidLevel().getValue(partialTicks);
        if (!fluidStack.isEmpty() && level != 0.0f) {
            boolean top = fluidStack.getFluid().getFluidType().isLighterThanAir();
            level = Math.max(level, 0.175f);
            float min = 0.15625f;
            float max = min + 0.6875f;
            float yOffset = 0.6875f * level;
            ms.m_85836_();
            if (!top) {
                ms.m_252880_(0.0f, yOffset, 0.0f);
            } else {
                ms.m_252880_(0.0f, max - min, 0.0f);
            }
            FluidRenderer.renderFluidBox((Fluid)fluidStack.getFluid(), (long)fluidStack.getAmount(), (float)min, (float)(min - yOffset), (float)min, (float)max, (float)min, (float)max, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)false, (boolean)true, (CompoundTag)fluidStack.getTag());
            ms.m_85849_();
        }
        int processingTicks = be.processingTicks;
        float processingPT = (float)processingTicks - partialTicks;
        float processingProgress = 1.0f - (processingPT - 5.0f) / 10.0f;
        processingProgress = Mth.m_14036_((float)processingProgress, (float)0.0f, (float)1.0f);
        float radius = 0.0f;
        if (!fluidStack.isEmpty() && processingTicks != -1) {
            radius = (float)(Math.pow(2.0f * processingProgress - 1.0f, 2.0) - 1.0);
            AABB bb = new AABB(0.5, 0.0, 0.5, 0.5, -1.2, 0.5).m_82400_((double)(radius / 32.0f));
            FluidRenderer.renderFluidBox((Fluid)fluidStack.getFluid(), (long)fluidStack.getAmount(), (float)((float)bb.f_82288_), (float)((float)bb.f_82289_), (float)((float)bb.f_82290_), (float)((float)bb.f_82291_), (float)((float)bb.f_82292_), (float)((float)bb.f_82293_), (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)true, (boolean)true, (CompoundTag)fluidStack.getTag());
        }
        float squeeze = radius;
        if (processingPT < 0.0f) {
            squeeze = 0.0f;
        } else if (processingPT < 2.0f) {
            squeeze = Mth.m_14179_((float)(processingPT / 2.0f), (float)0.0f, (float)-1.0f);
        } else if (processingPT < 10.0f) {
            squeeze = -1.0f;
        }
        ms.m_85836_();
        for (PartialModel bit : BITS) {
            CachedBuffers.partial((PartialModel)bit, (BlockState)be.m_58900_()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
            ms.m_252880_(0.0f, -3.0f * squeeze / 32.0f, 0.0f);
        }
        ms.m_85849_();
    }
}

