/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.chainConveyor;

import com.google.common.cache.Cache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorConnectionPacket;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorRidingHandler;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorShape;
import com.simibubi.create.content.kinetics.chainConveyor.ChainPackageInteractionPacket;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.PackagePortTarget;
import com.simibubi.create.content.logistics.packagePort.PackagePortTargetSelectionHandler;
import com.simibubi.create.foundation.utility.RaycastHelper;
import com.simibubi.create.foundation.utility.TickBasedCache;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.data.WorldAttached;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ChainConveyorInteractionHandler {
    public static WorldAttached<Cache<BlockPos, List<ChainConveyorShape>>> loadedChains = new WorldAttached($ -> new TickBasedCache(60, true));
    public static BlockPos selectedLift;
    public static float selectedChainPosition;
    public static BlockPos selectedConnection;
    public static Vec3 selectedBakedPosition;
    public static ChainConveyorShape selectedShape;

    public static void clientTick() {
        if (!ChainConveyorInteractionHandler.isActive()) {
            selectedLift = null;
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ItemStack mainHandItem = mc.f_91074_.m_21205_();
        boolean isWrench = AllTags.AllItemTags.CHAIN_RIDEABLE.matches(mainHandItem);
        boolean dismantling = isWrench && mc.f_91074_.m_6144_();
        double range = mc.f_91074_.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_() + 1.0;
        Vec3 from = RaycastHelper.getTraceOrigin((Player)mc.f_91074_);
        Vec3 to = RaycastHelper.getTraceTarget((Player)mc.f_91074_, range, from);
        HitResult hitResult = mc.f_91077_;
        double bestDiff = 3.4028234663852886E38;
        if (hitResult != null) {
            bestDiff = hitResult.m_82450_().m_82557_(from);
        }
        BlockPos bestLift = null;
        ChainConveyorShape bestShape = null;
        selectedConnection = null;
        for (Map.Entry entry : ((Cache)loadedChains.get((LevelAccessor)Minecraft.m_91087_().f_91073_)).asMap().entrySet()) {
            BlockPos liftPos = (BlockPos)entry.getKey();
            for (ChainConveyorShape chainConveyorShape : (List)entry.getValue()) {
                double distanceToSqr;
                Vec3 liftVec;
                Vec3 intersect;
                if (chainConveyorShape instanceof ChainConveyorShape.ChainConveyorBB && dismantling || (intersect = chainConveyorShape.intersect(from.m_82546_(liftVec = Vec3.m_82528_((Vec3i)liftPos)), to.m_82546_(liftVec))) == null || (distanceToSqr = intersect.m_82549_(liftVec).m_82557_(from)) > bestDiff) continue;
                bestDiff = distanceToSqr;
                bestLift = liftPos;
                bestShape = chainConveyorShape;
                selectedChainPosition = chainConveyorShape.getChainPosition(intersect);
                if (!(chainConveyorShape instanceof ChainConveyorShape.ChainConveyorOBB)) continue;
                ChainConveyorShape.ChainConveyorOBB obb = (ChainConveyorShape.ChainConveyorOBB)chainConveyorShape;
                selectedConnection = obb.connection;
            }
        }
        selectedLift = bestLift;
        if (bestLift == null) {
            return;
        }
        selectedShape = bestShape;
        selectedBakedPosition = bestShape.getVec(bestLift, selectedChainPosition);
        if (!isWrench) {
            Outliner.getInstance().chaseAABB((Object)"ChainPointSelection", new AABB(selectedBakedPosition, selectedBakedPosition)).colored(Color.WHITE).lineWidth(0.16666667f).disableLineNormals();
        }
    }

    private static boolean isActive() {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack mainHandItem = mc.f_91074_.m_21205_();
        return AllTags.AllItemTags.CHAIN_RIDEABLE.matches(mainHandItem) || AllBlocks.PACKAGE_FROGPORT.isIn(mainHandItem) || PackageItem.isPackage(mainHandItem);
    }

    public static boolean onUse() {
        if (selectedLift == null) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        ItemStack mainHandItem = mc.f_91074_.m_21205_();
        if (AllTags.AllItemTags.CHAIN_RIDEABLE.matches(mainHandItem)) {
            if (!mc.f_91074_.m_6144_()) {
                ChainConveyorRidingHandler.embark(selectedLift, selectedChainPosition, selectedConnection);
                return true;
            }
            AllPackets.getChannel().sendToServer((Object)new ChainConveyorConnectionPacket(selectedLift, selectedLift.m_121955_((Vec3i)selectedConnection), mainHandItem, false));
            return true;
        }
        if (AllBlocks.PACKAGE_FROGPORT.isIn(mainHandItem)) {
            PackagePortTargetSelectionHandler.exactPositionOfTarget = selectedBakedPosition;
            PackagePortTargetSelectionHandler.activePackageTarget = new PackagePortTarget.ChainConveyorFrogportTarget(selectedLift, selectedChainPosition, selectedConnection);
            return true;
        }
        if (PackageItem.isPackage(mainHandItem)) {
            AllPackets.getChannel().sendToServer((Object)new ChainPackageInteractionPacket(selectedLift, selectedConnection, selectedChainPosition, mainHandItem));
            return true;
        }
        return true;
    }

    public static void drawCustomBlockSelection(PoseStack ms, MultiBufferSource buffer, Vec3 camera) {
        if (selectedLift == null || selectedShape == null) {
            return;
        }
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110504_());
        ms.m_85836_();
        ms.m_85837_((double)selectedLift.m_123341_() - camera.f_82479_, (double)selectedLift.m_123342_() - camera.f_82480_, (double)selectedLift.m_123343_() - camera.f_82481_);
        selectedShape.drawOutline(selectedLift, ms, vb);
        ms.m_85849_();
    }

    @SubscribeEvent
    public static void hideVanillaBlockSelection(RenderHighlightEvent.Block event) {
        if (selectedLift == null || selectedShape == null) {
            return;
        }
        event.setCanceled(true);
    }
}

