/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.thresholdSwitch;

import com.google.common.base.Predicate;
import com.simibubi.create.compat.thresholdSwitch.FunctionalStorage;
import com.simibubi.create.compat.thresholdSwitch.SophisticatedStorage;
import com.simibubi.create.compat.thresholdSwitch.StorageDrawers;
import com.simibubi.create.compat.thresholdSwitch.ThresholdSwitchCompat;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.redstone.DirectedDirectionalBlock;
import com.simibubi.create.content.redstone.FilteredDetectorFilterSlot;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchBlock;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.TankManipulationBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.math.BlockFace;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class ThresholdSwitchBlockEntity
extends SmartBlockEntity {
    public int onWhenAbove = 128;
    public int offWhenBelow = 64;
    public int currentMinLevel;
    public int currentLevel = -1;
    public int currentMaxLevel;
    public boolean inStacks;
    private boolean redstoneState = false;
    private boolean inverted = false;
    private boolean poweredAfterDelay = false;
    private FilteringBehaviour filtering;
    private InvManipulationBehaviour observedInventory;
    private TankManipulationBehaviour observedTank;
    private VersionedInventoryTrackerBehaviour invVersionTracker;
    private static final List<ThresholdSwitchCompat> COMPAT = List.of(new FunctionalStorage(), new SophisticatedStorage(), new StorageDrawers());

    public ThresholdSwitchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.onWhenAbove = compound.m_128451_("OnAboveAmount");
        this.offWhenBelow = compound.m_128451_("OffBelowAmount");
        this.currentLevel = compound.m_128451_("CurrentAmount");
        this.currentMinLevel = compound.m_128451_("CurrentMinAmount");
        this.currentMaxLevel = compound.m_128451_("CurrentMaxAmount");
        this.inStacks = compound.m_128471_("InStacks");
        this.redstoneState = compound.m_128471_("Powered");
        this.inverted = compound.m_128471_("Inverted");
        this.poweredAfterDelay = compound.m_128471_("PoweredAfterDelay");
        super.read(compound, clientPacket);
    }

    protected void writeCommon(CompoundTag compound) {
        compound.m_128350_("OnAboveAmount", (float)this.onWhenAbove);
        compound.m_128350_("OffBelowAmount", (float)this.offWhenBelow);
        compound.m_128379_("Inverted", this.inverted);
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        this.writeCommon(compound);
        compound.m_128405_("CurrentAmount", this.currentLevel);
        compound.m_128405_("CurrentMinAmount", this.currentMinLevel);
        compound.m_128405_("CurrentMaxAmount", this.currentMaxLevel);
        compound.m_128379_("InStacks", this.inStacks);
        compound.m_128379_("Powered", this.redstoneState);
        compound.m_128379_("PoweredAfterDelay", this.poweredAfterDelay);
        super.write(compound, clientPacket);
    }

    @Override
    public void writeSafe(CompoundTag compound) {
        this.writeCommon(compound);
        super.writeSafe(compound);
    }

    public int getMinLevel() {
        return this.currentMinLevel;
    }

    public int getStockLevel() {
        return this.currentLevel;
    }

    public int getMaxLevel() {
        return this.currentMaxLevel;
    }

    public void updateCurrentLevel() {
        boolean changed = false;
        int prevLevel = this.currentLevel;
        int prevMaxLevel = this.currentMaxLevel;
        BlockPos target = this.getTargetPos();
        BlockEntity targetBlockEntity = this.f_58857_.m_7702_(target);
        this.observedInventory.findNewCapability();
        this.observedTank.findNewCapability();
        if (targetBlockEntity instanceof ThresholdSwitchObservable) {
            ThresholdSwitchObservable observable = (ThresholdSwitchObservable)targetBlockEntity;
            this.currentMinLevel = observable.getMinValue();
            this.currentLevel = observable.getCurrentValue();
            this.currentMaxLevel = observable.getMaxValue();
        } else if (this.observedInventory.hasInventory() || this.observedTank.hasInventory()) {
            FluidStack stackInSlot;
            int slot;
            this.currentMinLevel = 0;
            this.currentLevel = 0;
            this.currentMaxLevel = 0;
            if (this.observedInventory.hasInventory()) {
                IItemHandler inv = (IItemHandler)this.observedInventory.getInventory();
                if (this.invVersionTracker.stillWaiting(inv)) {
                    this.currentLevel = prevLevel;
                    this.currentMaxLevel = prevMaxLevel;
                } else {
                    this.invVersionTracker.awaitNewVersion(inv);
                    for (slot = 0; slot < inv.getSlots(); ++slot) {
                        stackInSlot = inv.getStackInSlot(slot);
                        int finalSlot = slot;
                        long space = COMPAT.stream().filter(compat -> compat.isFromThisMod(targetBlockEntity)).map(compat -> compat.getSpaceInSlot(inv, finalSlot)).findFirst().orElseGet(() -> ThresholdSwitchBlockEntity.lambda$updateCurrentLevel$2((ItemStack)stackInSlot, inv, finalSlot));
                        int count = stackInSlot.m_41613_();
                        if (space == 0L) continue;
                        this.currentMaxLevel = (int)((long)this.currentMaxLevel + space);
                        if (!this.filtering.test((ItemStack)stackInSlot)) continue;
                        this.currentLevel += count;
                    }
                }
            }
            if (this.observedTank.hasInventory()) {
                IFluidHandler tank = (IFluidHandler)this.observedTank.getInventory();
                for (slot = 0; slot < tank.getTanks(); ++slot) {
                    stackInSlot = tank.getFluidInTank(slot);
                    int space = tank.getTankCapacity(slot);
                    int count = stackInSlot.getAmount();
                    if (space == 0) continue;
                    this.currentMaxLevel += space;
                    if (!this.filtering.test(stackInSlot)) continue;
                    this.currentLevel += count;
                }
            }
        } else {
            this.currentMinLevel = -1;
            this.currentMaxLevel = -1;
            if (this.currentLevel == -1) {
                return;
            }
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ThresholdSwitchBlock.LEVEL, (Comparable)Integer.valueOf(0)), 3);
            this.currentLevel = -1;
            this.redstoneState = false;
            this.sendData();
            this.scheduleBlockTick();
            return;
        }
        this.currentLevel = Mth.m_14045_((int)this.currentLevel, (int)this.currentMinLevel, (int)this.currentMaxLevel);
        changed = this.currentLevel != prevLevel;
        boolean previouslyPowered = this.redstoneState;
        if (this.redstoneState && this.currentLevel <= this.offWhenBelow) {
            this.redstoneState = false;
        } else if (!this.redstoneState && this.currentLevel >= this.onWhenAbove) {
            this.redstoneState = true;
        }
        boolean update = previouslyPowered != this.redstoneState;
        int displayLevel = 0;
        float normedLevel = (float)(this.currentLevel - this.currentMinLevel) / (float)(this.currentMaxLevel - this.currentMinLevel);
        if (this.currentLevel > 0) {
            displayLevel = (int)(1.0f + normedLevel * 4.0f);
        }
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ThresholdSwitchBlock.LEVEL, (Comparable)Integer.valueOf(displayLevel)), update ? 3 : 2);
        if (update) {
            this.scheduleBlockTick();
        }
        if (changed || update) {
            DisplayLinkBlock.notifyGatherers((LevelAccessor)this.f_58857_, this.f_58858_);
            this.notifyUpdate();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSuitableInventory(BlockEntity be) {
        if (be == null) return false;
        if (be instanceof StockTickerBlockEntity) return false;
        if (be.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(ProcessingInventory.class::isInstance).isPresent()) return false;
        return true;
    }

    private BlockPos getTargetPos() {
        return this.f_58858_.m_121945_(ThresholdSwitchBlock.getTargetDirection(this.m_58900_()));
    }

    public ItemStack getDisplayItemForScreen() {
        BlockPos target = this.getTargetPos();
        return new ItemStack((ItemLike)this.f_58857_.m_8055_(target).m_60734_());
    }

    public MutableComponent format(int value, boolean stacks) {
        BlockEntity blockEntity;
        ThresholdType type = this.getTypeOfCurrentTarget();
        if (type == ThresholdType.CUSTOM && (blockEntity = this.f_58857_.m_7702_(this.getTargetPos())) instanceof ThresholdSwitchObservable) {
            ThresholdSwitchObservable tso = (ThresholdSwitchObservable)blockEntity;
            return tso.format(value);
        }
        String suffix = type == ThresholdType.ITEM ? (stacks ? "schedule.condition.threshold.stacks" : "schedule.condition.threshold.items") : "schedule.condition.threshold.buckets";
        return CreateLang.text(value + " ").add(CreateLang.translate(suffix, new Object[0])).component();
    }

    public ThresholdType getTypeOfCurrentTarget() {
        if (this.observedInventory.hasInventory()) {
            return ThresholdType.ITEM;
        }
        if (this.observedTank.hasInventory()) {
            return ThresholdType.FLUID;
        }
        if (this.f_58857_.m_7702_(this.getTargetPos()) instanceof ThresholdSwitchObservable) {
            return ThresholdType.CUSTOM;
        }
        return ThresholdType.UNSUPPORTED;
    }

    protected void scheduleBlockTick() {
        Block block = this.m_58900_().m_60734_();
        if (!this.f_58857_.m_183326_().m_183588_(this.f_58858_, (Object)block)) {
            this.f_58857_.m_186464_(this.f_58858_, block, 2, TickPriority.NORMAL);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateCurrentLevel();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour(this, new FilteredDetectorFilterSlot(true)).withCallback($ -> {
            this.updateCurrentLevel();
            this.invVersionTracker.reset();
        });
        behaviours.add(this.filtering);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
        CapManipulationBehaviourBase.InterfaceProvider towardBlockFacing = (w, p, s) -> new BlockFace(p, DirectedDirectionalBlock.getTargetDirection(s));
        this.observedInventory = (InvManipulationBehaviour)((InvManipulationBehaviour)new InvManipulationBehaviour(this, towardBlockFacing).bypassSidedness()).withFilter((Predicate<BlockEntity>)((Predicate)this::isSuitableInventory));
        behaviours.add(this.observedInventory);
        this.observedTank = (TankManipulationBehaviour)new TankManipulationBehaviour(this, towardBlockFacing).bypassSidedness();
        behaviours.add(this.observedTank);
    }

    public float getLevelForDisplay() {
        return this.currentLevel == -1 ? 0.0f : (float)this.currentLevel;
    }

    public boolean getState() {
        return this.redstoneState;
    }

    public boolean shouldBePowered() {
        return this.inverted != this.redstoneState;
    }

    public void updatePowerAfterDelay() {
        this.poweredAfterDelay = this.shouldBePowered();
        this.f_58857_.m_6289_(this.f_58858_, this.m_58900_().m_60734_());
        this.sendData();
    }

    public boolean isPowered() {
        return this.poweredAfterDelay;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        if (inverted == this.inverted) {
            return;
        }
        this.inverted = inverted;
        this.updatePowerAfterDelay();
    }

    private static /* synthetic */ Long lambda$updateCurrentLevel$2(ItemStack stackInSlot, IItemHandler inv, int finalSlot) {
        return Math.min(stackInSlot.m_41741_(), inv.getSlotLimit(finalSlot));
    }

    public static enum ThresholdType {
        UNSUPPORTED,
        ITEM,
        FLUID,
        CUSTOM;

    }
}

