/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest.tests;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.simibubi.create.content.contraptions.elevator.ElevatorPulleyBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlock;
import com.simibubi.create.infrastructure.gametest.CreateGameTestHelper;
import com.simibubi.create.infrastructure.gametest.GameTestGroup;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

@GameTestGroup(path="contraptions")
public class TestContraptions {
    @GameTest(template="arrow_dispenser", timeoutTicks=200)
    public static void arrowDispenser(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(2, 3, 1);
        helper.m_177421_(lever);
        BlockPos pos1 = new BlockPos(0, 5, 0);
        BlockPos pos2 = new BlockPos(4, 5, 4);
        helper.m_177361_(() -> {
            helper.assertSecondsPassed(7);
            List arrows = helper.getEntitiesBetween(EntityType.f_20548_, pos1, pos2);
            if (arrows.size() != 4) {
                helper.m_177284_("Expected 4 arrows");
            }
            helper.powerLever(lever);
            BlockPos dispenser = new BlockPos(2, 5, 2);
            helper.m_177242_(dispenser, Items.f_42412_);
        });
    }

    @GameTest(template="crop_farming", timeoutTicks=200)
    public static void cropFarming(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(4, 3, 1);
        helper.m_177421_(lever);
        BlockPos output = new BlockPos(1, 3, 12);
        helper.m_177361_(() -> helper.assertAnyContained(output, Items.f_42405_, Items.f_42620_, Items.f_42619_));
    }

    @GameTest(template="mounted_item_extract", timeoutTicks=400)
    public static void mountedItemExtract(CreateGameTestHelper helper) {
        BlockPos barrel = new BlockPos(1, 3, 2);
        Object2LongMap<Item> content = helper.getItemContent(barrel);
        BlockPos lever = new BlockPos(1, 5, 1);
        helper.m_177421_(lever);
        BlockPos outputPos = new BlockPos(4, 2, 1);
        helper.m_177361_(() -> {
            helper.assertContentPresent(content, outputPos);
            helper.powerLever(lever);
            helper.m_177440_(barrel);
        });
    }

    @GameTest(template="mounted_fluid_drain", timeoutTicks=200)
    public static void mountedFluidDrain(CreateGameTestHelper helper) {
        BlockPos tank = new BlockPos(1, 3, 2);
        FluidStack fluid = helper.getTankContents(tank);
        if (fluid.isEmpty()) {
            helper.m_177284_("Tank empty");
        }
        BlockPos lever = new BlockPos(1, 5, 1);
        helper.m_177421_(lever);
        BlockPos output = new BlockPos(4, 2, 1);
        helper.m_177361_(() -> {
            helper.assertFluidPresent(fluid, output);
            helper.powerLever(lever);
            helper.assertTankEmpty(tank);
        });
    }

    @GameTest(template="ploughing")
    public static void ploughing(CreateGameTestHelper helper) {
        BlockPos dirt = new BlockPos(4, 2, 1);
        BlockPos lever = new BlockPos(3, 3, 2);
        helper.m_177421_(lever);
        helper.m_177361_(() -> helper.m_177208_(Blocks.f_50093_, dirt));
    }

    @GameTest(template="redstone_contacts")
    public static void redstoneContacts(CreateGameTestHelper helper) {
        BlockPos end = new BlockPos(5, 10, 1);
        BlockPos lever = new BlockPos(1, 3, 2);
        helper.m_177421_(lever);
        helper.m_177361_(() -> helper.m_177208_(Blocks.f_50090_, end));
    }

    @GameTest(template="controls", timeoutTicks=200)
    public static void controls(CreateGameTestHelper helper) {
        BlockPos button = new BlockPos(5, 5, 4);
        BlockPos gearshift = new BlockPos(4, 5, 4);
        BlockPos bearingPos = new BlockPos(4, 4, 4);
        AtomicInteger step = new AtomicInteger(1);
        List<BlockPos> dirt = List.of(new BlockPos(4, 2, 6), new BlockPos(2, 2, 4), new BlockPos(4, 2, 2));
        List<BlockPos> wheat = List.of(new BlockPos(4, 3, 7), new BlockPos(1, 3, 4), new BlockPos(4, 3, 1));
        helper.m_177385_(button);
        helper.m_177361_(() -> {
            helper.m_177255_(gearshift, (Property)SequencedGearshiftBlock.STATE, Integer.valueOf(0));
            if (step.get() == 4) {
                return;
            }
            MechanicalBearingBlockEntity bearing = (MechanicalBearingBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.MECHANICAL_BEARING.get(), bearingPos);
            if (bearing.getMovedContraption() == null) {
                helper.m_177284_("Contraption not assembled");
            }
            Contraption contraption = bearing.getMovedContraption().getContraption();
            switch (step.get()) {
                case 1: {
                    helper.m_177208_(Blocks.f_50093_, (BlockPos)dirt.get(0));
                    helper.m_177255_((BlockPos)wheat.get(0), (Property)CropBlock.f_52244_, Integer.valueOf(0));
                    helper.toggleActorsOfType(contraption, (ItemLike)AllBlocks.MECHANICAL_HARVESTER.get());
                    helper.m_177385_(button);
                    step.incrementAndGet();
                    helper.m_177284_("Entering step 2");
                    break;
                }
                case 2: {
                    helper.m_177208_(Blocks.f_50093_, (BlockPos)dirt.get(1));
                    helper.m_177255_((BlockPos)wheat.get(1), (Property)CropBlock.f_52244_, Integer.valueOf(7));
                    helper.toggleActorsOfType(contraption, (ItemLike)AllBlocks.MECHANICAL_PLOUGH.get());
                    helper.m_177385_(button);
                    step.incrementAndGet();
                    helper.m_177284_("Entering step 3");
                    break;
                }
                case 3: {
                    helper.m_177208_(Blocks.f_50493_, (BlockPos)dirt.get(2));
                    helper.m_177255_((BlockPos)wheat.get(2), (Property)CropBlock.f_52244_, Integer.valueOf(7));
                    helper.m_177385_(button);
                    step.incrementAndGet();
                    helper.m_177284_("Entering step 4");
                }
            }
        });
    }

    @GameTest(template="elevator")
    public static void elevator(CreateGameTestHelper helper) {
        BlockPos pulley = new BlockPos(5, 12, 3);
        BlockPos secondaryPulley = new BlockPos(5, 12, 1);
        BlockPos bottomLamp = new BlockPos(2, 3, 2);
        BlockPos topLamp = new BlockPos(2, 12, 2);
        BlockPos lever = new BlockPos(1, 11, 2);
        BlockPos elevatorStart = new BlockPos(4, 2, 2);
        BlockPos cowSpawn = new BlockPos(4, 4, 2);
        BlockPos cowEnd = new BlockPos(4, 13, 2);
        helper.m_177127_(1L, () -> helper.m_177176_(EntityType.f_20557_, cowSpawn));
        helper.m_177127_(15L, () -> ((ElevatorPulleyBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.ELEVATOR_PULLEY.get(), pulley)).clicked());
        helper.m_177361_(() -> {
            helper.assertSecondsPassed(1);
            if (!((Boolean)helper.m_177232_(lever).m_61143_((Property)LeverBlock.f_54622_)).booleanValue()) {
                helper.getFirstEntity((EntityType)AllEntityTypes.CONTROLLED_CONTRAPTION.get(), elevatorStart);
                helper.m_177255_(topLamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(false));
                helper.m_177255_(bottomLamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(true));
                ElevatorPulleyBlockEntity secondary = (ElevatorPulleyBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.ELEVATOR_PULLEY.get(), secondaryPulley);
                if (secondary.getMirrorParent() == null) {
                    helper.m_177284_("Secondary pulley has no parent");
                }
                helper.m_177421_(lever);
                helper.m_177284_("Entering step 2");
            } else {
                helper.m_177255_(topLamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(true));
                helper.m_177255_(bottomLamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(false));
                helper.m_177374_(EntityType.f_20557_, cowEnd);
                ((ElevatorPulleyBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.ELEVATOR_PULLEY.get(), pulley)).clicked();
            }
        });
    }

    @GameTest(template="roller_filling")
    public static void rollerFilling(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(7, 6, 1);
        BlockPos barrelEnd = new BlockPos(2, 5, 2);
        List existing = BlockPos.m_121990_((BlockPos)new BlockPos(1, 3, 2), (BlockPos)new BlockPos(4, 2, 2)).toList();
        List<BlockPos> filled = BlockPos.m_121990_((BlockPos)new BlockPos(1, 2, 1), (BlockPos)new BlockPos(4, 3, 3)).filter(pos -> !existing.contains(pos)).toList();
        List tracks = BlockPos.m_121990_((BlockPos)new BlockPos(1, 4, 2), (BlockPos)new BlockPos(4, 4, 2)).toList();
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            helper.assertSecondsPassed(4);
            existing.forEach(pos -> helper.m_177208_((Block)AllBlocks.RAILWAY_CASING.get(), (BlockPos)pos));
            filled.forEach(pos -> helper.m_177208_((Block)AllBlocks.ANDESITE_CASING.get(), (BlockPos)pos));
            tracks.forEach(pos -> helper.m_177208_((Block)AllBlocks.TRACK.get(), (BlockPos)pos));
            helper.m_177440_(barrelEnd);
        });
    }

    @GameTest(template="roller_paving_and_clearing", timeoutTicks=200)
    public static void rollerPavingAndClearing(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(8, 5, 1);
        List paved = BlockPos.m_121990_((BlockPos)new BlockPos(1, 2, 1), (BlockPos)new BlockPos(4, 2, 1)).toList();
        BlockPos cleared = new BlockPos(2, 3, 1);
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            helper.assertSecondsPassed(9);
            paved.forEach(pos -> helper.m_177208_((Block)AllBlocks.ANDESITE_CASING.get(), (BlockPos)pos));
            helper.m_177208_(Blocks.f_50016_, cleared);
        });
    }

    @GameTest(template="dispensers_dont_fight")
    public static void dispensersDontFight(CreateGameTestHelper helper) {
        helper.m_177302_(2, 3, 1);
        BlockPos bottom = new BlockPos(6, 4, 1);
        BlockPos top = new BlockPos(6, 6, 1);
        BlockPos dispenser = new BlockPos(3, 4, 1);
        helper.m_177361_(() -> {
            helper.m_239371_(EntityType.f_20548_, bottom, 3, 0.0);
            helper.m_177402_(EntityType.f_20548_, top);
            helper.m_177208_(Blocks.f_50061_, dispenser);
            helper.assertContainerContains(dispenser, new ItemStack((ItemLike)Items.f_42412_, 2));
        });
    }

    @GameTest(template="dispensers_refill")
    public static void dispensersRefill(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(2, 3, 1);
        helper.m_177421_(lever);
        BlockPos barrel = lever.m_7494_();
        BlockPos dispenser = barrel.m_122029_();
        helper.m_177361_(() -> {
            helper.m_177208_(Blocks.f_50061_, dispenser);
            helper.assertContainerContains(dispenser, new ItemStack((ItemLike)Items.f_42737_, 2));
            helper.m_177440_(barrel);
        });
    }

    @GameTest(template="vaults_protect_fuel")
    public static void vaultsProtectFuel(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(2, 2, 1);
        helper.m_177421_(lever);
        BlockPos barrelLamp = new BlockPos(1, 3, 3);
        BlockPos vaultLamp = barrelLamp.m_122030_(2);
        helper.m_177127_(10L, () -> helper.m_177421_(lever));
        helper.m_177361_(() -> {
            helper.m_177255_(barrelLamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(false));
            helper.m_177255_(vaultLamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(true));
        });
    }
}

