/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.gbd.event;

import com.ibarnstormer.gbd.capability.ModCapabilityProvider;
import com.ibarnstormer.gbd.client.keybinds.KeyBindings;
import com.ibarnstormer.gbd.entities.BeamReactorLaserEntity;
import com.ibarnstormer.gbd.entities.TurretBeamLaserEntity;
import com.ibarnstormer.gbd.network.ToggleBeamReactorPacket;
import com.ibarnstormer.gbd.registry.ModNetwork;
import com.ibarnstormer.gbd.sounds.BeamReactorSoundInstance;
import com.ibarnstormer.gbd.sounds.TurretBeamSoundInstance;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ClientModEvents {

    @Mod.EventBusSubscriber(modid="creategbd", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(KeyBindings.BEAM_REACTOR_TOGGLE);
        }
    }

    @Mod.EventBusSubscriber(modid="creategbd", value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (event.getKey() == KeyBindings.BEAM_REACTOR_TOGGLE.getKey().m_84873_() && event.getAction() == 1) {
                ClientForgeEvents.handleKeyPress(event.getKey());
            }
        }

        private static void handleKeyPress(int key) {
            if (key == KeyBindings.BEAM_REACTOR_TOGGLE.getKey().m_84873_() && Minecraft.m_91087_().f_91080_ == null) {
                LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
                assert (clientPlayer != null);
                clientPlayer.getCapability(ModCapabilityProvider.BEAM_REACTOR_CAPABILITY).ifPresent(cap -> ModNetwork.sendPacketToServer(new ToggleBeamReactorPacket(!cap.isActive())));
                return;
            }
        }

        public static void handleBeamReactorSound(Entity sourcePlayer, Entity beam) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new BeamReactorSoundInstance((Player)sourcePlayer, (BeamReactorLaserEntity)beam));
        }

        public static void handleTurretBeamSound(Entity laser) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new TurretBeamSoundInstance((TurretBeamLaserEntity)laser));
        }
    }
}

