/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.generation.brushes;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.cna.CNABlockEntityTypes;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.electricity.generation.coil.GeneratorCoilBlock;
import org.antarcticgardens.cna.content.electricity.generation.coil.GeneratorCoilBlockEntity;
import org.antarcticgardens.cna.util.StringFormatUtil;
import org.antarcticgardens.esl.energy.EnergyHelper;
import org.antarcticgardens.esl.energy.EnergyStorage;
import org.antarcticgardens.esl.energy.SimpleEnergyStorage;
import org.antarcticgardens.esl.transaction.Transaction;
import org.antarcticgardens.esl.transaction.TransactionContext;
import org.antarcticgardens.esl.transaction.TransactionStack;

public class CarbonBrushesBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    private final SimpleEnergyStorage storage = new SimpleEnergyStorage(0L).setSupportsInsertion(false);
    private int lastOutput = 0;
    private int syncOut = 0;

    public CarbonBrushesBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        EnergyStorage.registerForBlockEntity((blockEntity, direction) -> blockEntity.storage, (BlockEntityType)((BlockEntityType)CNABlockEntityTypes.CARBON_BRUSHES.get()));
        this.setLazyTickRate(20);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("lastOutput", this.lastOutput);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.lastOutput = compound.m_128451_("lastOutput");
        super.read(compound, clientPacket);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"tooltip.create_new_age.energy_stats", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.energy_output", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.energy_per_tick", (Object[])new Object[]{StringFormatUtil.formatLong(this.lastOutput)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        return true;
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING);
        this.storage.setCapacity((long)this.lastOutput * 20L);
        int coilsLeft = (Integer)CNAConfig.getCommon().maxCoils.get();
        this.lastOutput = 0;
        coilsLeft = this.processCoil(this.f_58858_, facing, coilsLeft);
        this.processCoil(this.f_58858_, facing.m_122424_(), coilsLeft);
        try (Transaction t = TransactionStack.get().openOuter();){
            EnergyHelper.insertToSurrounding((EnergyStorage)this.storage, (BlockPos)this.m_58899_(), (Level)this.m_58904_(), (long)this.storage.getStoredEnergy(), (TransactionContext)t);
            t.commit();
        }
    }

    public void lazyTick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.syncOut > 0) {
            this.syncOut = 0;
            this.m_6596_();
            this.sendData();
        }
    }

    private int processCoil(BlockPos pos, Direction dir, int left) {
        GeneratorCoilBlockEntity coil;
        if (left <= 0) {
            return 0;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(pos = pos.m_121945_(dir));
        if (blockEntity instanceof GeneratorCoilBlockEntity && ((Direction.Axis)(coil = (GeneratorCoilBlockEntity)blockEntity).m_58900_().m_61143_((Property)GeneratorCoilBlock.AXIS)).test(dir)) {
            int energy = coil.takeGeneratedEnergy();
            this.lastOutput += energy;
            this.syncOut += energy;
            this.storage.internalInsert((long)energy, false);
            return this.processCoil(pos, dir, left - 1);
        }
        return left;
    }
}

