/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packagePort;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.equipment.clipboard.ClipboardOverrides;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.PackagePortAutomationInventoryWrapper;
import com.simibubi.create.content.logistics.packagePort.PackagePortMenu;
import com.simibubi.create.content.logistics.packagePort.PackagePortTarget;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.animatedContainer.AnimatedContainerBehaviour;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackagePortBlockEntity
extends SmartBlockEntity
implements MenuProvider {
    public boolean acceptsPackages = true;
    public String addressFilter = "";
    public PackagePortTarget target;
    public SmartInventory inventory = new SmartInventory(18, this, (slot, stack) -> PackageItem.isPackage(stack));
    protected AnimatedContainerBehaviour<PackagePortMenu> openTracker;
    protected LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new PackagePortAutomationInventoryWrapper(this.inventory, this));

    public PackagePortBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean isBackedUp() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void filterChanged() {
        if (this.target != null) {
            this.target.deregister(this, (LevelAccessor)this.f_58857_, this.f_58858_);
            this.target.register(this, (LevelAccessor)this.f_58857_, this.f_58858_);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.target != null) {
            this.target.register(this, (LevelAccessor)this.f_58857_, this.f_58858_);
        }
    }

    public String getFilterString() {
        return this.acceptsPackages ? this.addressFilter : null;
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.target != null) {
            tag.m_128365_("Target", (Tag)this.target.write());
        }
        tag.m_128359_("AddressFilter", this.addressFilter);
        tag.m_128379_("AcceptsPackages", this.acceptsPackages);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        PackagePortTarget prevTarget = this.target;
        this.target = PackagePortTarget.read(tag.m_128469_("Target"));
        this.addressFilter = tag.m_128461_("AddressFilter");
        this.acceptsPackages = tag.m_128471_("AcceptsPackages");
        if (clientPacket && prevTarget != this.target) {
            this.invalidateRenderBoundingBox();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidate() {
        this.itemHandler.invalidate();
        super.invalidate();
    }

    @Override
    public void destroy() {
        if (this.target != null) {
            this.target.deregister(this, (LevelAccessor)this.f_58857_, this.f_58858_);
        }
        super.destroy();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.drop(this.inventory.getStackInSlot(i));
        }
    }

    public void drop(ItemStack box) {
        if (box.m_41619_()) {
            return;
        }
        Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)box);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.openTracker = new AnimatedContainerBehaviour<PackagePortMenu>(this, PackagePortMenu.class);
        behaviours.add(this.openTracker);
        this.openTracker.onOpenChanged(this::onOpenChange);
    }

    protected abstract void onOpenChange(boolean var1);

    public InteractionResult use(Player player) {
        if (player == null || player.m_6047_()) {
            return InteractionResult.PASS;
        }
        if (player instanceof FakePlayer) {
            return InteractionResult.PASS;
        }
        ItemStack mainHandItem = player.m_21205_();
        boolean clipboard = AllBlocks.CLIPBOARD.isIn(mainHandItem);
        if (this.f_58857_.f_46443_) {
            if (!clipboard) {
                this.onOpenedManually();
            }
            return InteractionResult.SUCCESS;
        }
        if (clipboard) {
            this.addAddressToClipboard(player, mainHandItem);
            return InteractionResult.SUCCESS;
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
        return InteractionResult.SUCCESS;
    }

    protected void onOpenedManually() {
    }

    private void addAddressToClipboard(Player player, ItemStack mainHandItem) {
        if (this.addressFilter == null || this.addressFilter.isBlank()) {
            return;
        }
        List<List<ClipboardEntry>> list = ClipboardEntry.readAll(mainHandItem);
        for (List<ClipboardEntry> page : list) {
            for (ClipboardEntry entry : page) {
                String existing = entry.text.getString();
                if (!existing.equals("#" + this.addressFilter) && !existing.equals("# " + this.addressFilter)) continue;
                return;
            }
        }
        List<ClipboardEntry> page = null;
        for (List<ClipboardEntry> freePage : list) {
            if (freePage.size() > 11) continue;
            page = freePage;
            break;
        }
        if (page == null) {
            page = new ArrayList<ClipboardEntry>();
            list.add(page);
        }
        page.add(new ClipboardEntry(false, Component.m_237113_((String)("#" + this.addressFilter))));
        player.m_5661_((Component)CreateLang.translate("clipboard.address_added", this.addressFilter).component(), true);
        ClipboardEntry.saveAll(list, mainHandItem);
        mainHandItem.m_41783_().m_128405_("Type", ClipboardOverrides.ClipboardType.WRITTEN.ordinal());
    }

    public Component m_5446_() {
        return Component.m_237119_();
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return PackagePortMenu.create(pContainerId, pPlayerInventory, this);
    }

    public int getComparatorOutput() {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.inventory);
    }
}

