/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;

public class TrainCommand {
    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"train").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"train", (ArgumentType)UuidArgument.m_113850_()).executes(ctx -> TrainCommand.runDelete((CommandSourceStack)ctx.getSource(), UuidArgument.m_113853_((CommandContext)ctx, (String)"train")))))).then(Commands.m_82127_((String)"tp").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"train", (ArgumentType)UuidArgument.m_113850_()).requires(CommandSourceStack::m_230897_)).executes(ctx -> TrainCommand.runTeleport((CommandSourceStack)ctx.getSource(), UuidArgument.m_113853_((CommandContext)ctx, (String)"train")))));
    }

    private static int runDelete(CommandSourceStack source, UUID argument) {
        Train train = Create.RAILWAYS.trains.get(argument);
        if (train == null) {
            source.m_81352_((Component)Component.m_237113_((String)("No Train with id " + argument.toString().substring(0, 5) + "[...] was found")));
            return 0;
        }
        train.invalid = true;
        source.m_288197_(() -> Component.m_237113_((String)"Train '").m_7220_(train.name).m_130946_("' removed successfully"), true);
        return 1;
    }

    private static int runTeleport(CommandSourceStack source, UUID argument) throws CommandSyntaxException {
        ServerPlayer serverPlayer = source.m_81375_();
        GameType gameMode = serverPlayer.f_8941_.m_9290_();
        if (gameMode != GameType.CREATIVE && gameMode != GameType.SPECTATOR) {
            source.m_81352_((Component)Component.m_237113_((String)"Can only teleport to train when in Creative or Spectator Mode!"));
            return 0;
        }
        Train train = Create.RAILWAYS.trains.get(argument);
        if (train == null) {
            source.m_81352_((Component)Component.m_237113_((String)("No Train with id " + argument.toString().substring(0, 5) + "[...] was found")));
            return 0;
        }
        List<ResourceKey<Level>> presentDimensions = train.getPresentDimensions();
        if (presentDimensions.isEmpty()) {
            source.m_81352_((Component)Component.m_237113_((String)"Unable to teleport to Train. No valid location found"));
            return 0;
        }
        ResourceKey<Level> levelKey = presentDimensions.get(0);
        ServerLevel serverLevel = serverPlayer.m_20194_().m_129880_(levelKey);
        Optional<BlockPos> positionInDimension = train.getPositionInDimension(levelKey);
        if (positionInDimension.isEmpty() || serverLevel == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Unable to teleport to Train. No valid location found"));
            return 0;
        }
        BlockPos pos = positionInDimension.get();
        serverPlayer.m_8999_(serverLevel, (double)pos.m_123341_(), (double)(pos.m_123342_() + 5), (double)pos.m_123343_(), serverPlayer.m_5675_(0.0f), serverPlayer.m_5686_(0.0f));
        source.m_288197_(() -> Component.m_237113_((String)"Teleported to Train '").m_7220_(train.name).m_130946_("' successfully"), true);
        return 1;
    }
}

